"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation_shallow import ActionRelationShallow, ActionRelationShallowPlain


class SshKeyRelation(DevopnessBaseModel):
    """
    SshKeyRelation

    Attributes:
        id (int): The Id of the given SSH public key
        created_by (int, optional): The Id of the user to which the SSH key belongs to
        project_id (int, optional): The project id to which the SSH public key belongs to
        environment_id (int): The environment id to which the SSH public key belongs to
        name (str): The name entered by the user to uniquely identify the public SSH key
        fingerprint (str): The hashed fingerprint of the public key
        last_action (ActionRelationShallow, optional, nullable):
        created_at (str, optional): The date and time when the record was created
        updated_at (str, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The Id of the given SSH public key")
    created_by: Optional[StrictInt] = Field(
        default=None, description="The Id of the user to which the SSH key belongs to"
    )
    project_id: Optional[StrictInt] = Field(
        default=None,
        description="The project id to which the SSH public key belongs to",
    )
    environment_id: StrictInt = Field(
        description="The environment id to which the SSH public key belongs to"
    )
    name: StrictStr = Field(
        description="The name entered by the user to uniquely identify the public SSH key"
    )
    fingerprint: StrictStr = Field(
        description="The hashed fingerprint of the public key"
    )
    last_action: Optional[ActionRelationShallow] = None
    created_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class SshKeyRelationPlain(TypedDict, total=False):
    """
    Plain version of SshKeyRelation.
    """

    id: Required[int]
    created_by: Optional[int]
    project_id: Optional[int]
    environment_id: Required[int]
    name: Required[str]
    fingerprint: Required[str]
    last_action: Optional[
        Union[
            ActionRelationShallow,
            ActionRelationShallowPlain,
        ]
    ]
    created_at: Optional[str]
    updated_at: Optional[str]
