"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .ssl_certificate_issuer import SslCertificateIssuer, SslCertificateIssuerPlain
from .ssl_certificate_type import SslCertificateType, SslCertificateTypePlain
from .ssl_certificate_validation_level import (
    SslCertificateValidationLevel,
    SslCertificateValidationLevelPlain,
)
from .user_relation import UserRelation, UserRelationPlain


class SslCertificate(DevopnessBaseModel):
    """
    SslCertificate

    Attributes:
        id (int): The unique ID of the given SSL certificate
        name (str): The name given to SSL certificate
        type (SslCertificateType):
        issuer (SslCertificateIssuer):
        validation_level (SslCertificateValidationLevel):
        active (bool): Tells if the certificate is active for all linked servers and applications
        created_by_user (UserRelation):
        last_action (ActionRelation, optional, nullable):
        expires_at (str, optional, nullable): The date and time when this certificate will no longer be valid, down to minute precision
        last_renewed_at (str, optional, nullable): The date and time when this certificate was renewed for the last time
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given SSL certificate")
    name: StrictStr = Field(description="The name given to SSL certificate")
    type: SslCertificateType
    issuer: SslCertificateIssuer
    validation_level: SslCertificateValidationLevel
    active: StrictBool = Field(
        description="Tells if the certificate is active for all linked servers and applications"
    )
    created_by_user: UserRelation
    last_action: Optional[ActionRelation]
    expires_at: Optional[StrictStr] = Field(
        description="The date and time when this certificate will no longer be valid, down to minute precision"
    )
    last_renewed_at: Optional[StrictStr] = Field(
        description="The date and time when this certificate was renewed for the last time"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class SslCertificatePlain(TypedDict, total=False):
    """
    Plain version of SslCertificate.
    """

    id: Required[int]
    name: Required[str]
    type: Required[
        Union[
            SslCertificateType,
            SslCertificateTypePlain,
        ]
    ]
    issuer: Required[
        Union[
            SslCertificateIssuer,
            SslCertificateIssuerPlain,
        ]
    ]
    validation_level: Required[
        Union[
            SslCertificateValidationLevel,
            SslCertificateValidationLevelPlain,
        ]
    ]
    active: Required[bool]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    expires_at: Optional[str]
    last_renewed_at: Optional[str]
    created_at: Required[str]
    updated_at: Required[str]
