"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .service_type import ServiceType, ServiceTypePlain
from .static_service_type_supported_versions_inner import (
    StaticServiceTypeSupportedVersionsInner,
    StaticServiceTypeSupportedVersionsInnerPlain,
)


class StaticServiceType(DevopnessBaseModel):
    """
    StaticServiceType

    Attributes:
        value (ServiceType):
        human_readable (str): Displayable version of the service name
        hint (str): Descriptive text to help users to know what data is stored in the field and optional extra information on how to enter data to the field
        supported_versions (List[StaticServiceTypeSupportedVersionsInner]): List of service versions supported by Devopness
    """

    value: ServiceType
    human_readable: StrictStr = Field(
        description="Displayable version of the service name"
    )
    hint: StrictStr = Field(
        description="Descriptive text to help users to know what data is stored in the field and optional extra information on how to enter data to the field"
    )
    supported_versions: List[StaticServiceTypeSupportedVersionsInner] = Field(
        description="List of service versions supported by Devopness"
    )


class StaticServiceTypePlain(TypedDict, total=False):
    """
    Plain version of StaticServiceType.
    """

    value: Required[
        Union[
            ServiceType,
            ServiceTypePlain,
        ]
    ]
    human_readable: Required[str]
    hint: Required[str]
    supported_versions: Required[
        List[
            Union[
                StaticServiceTypeSupportedVersionsInner,
                StaticServiceTypeSupportedVersionsInnerPlain,
            ]
        ]
    ]
