"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .credential_relation import CredentialRelation, CredentialRelationPlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .network_relation import NetworkRelation, NetworkRelationPlain
from .project_relation import ProjectRelation, ProjectRelationPlain
from .subnet_provision_input import SubnetProvisionInput, SubnetProvisionInputPlain
from .subnet_type import SubnetType, SubnetTypePlain
from .user_relation import UserRelation, UserRelationPlain


class Subnet(DevopnessBaseModel):
    """
    Subnet

    Attributes:
        id (int): The unique id of the given record
        name (str): The subnet&#39;s name
        type (SubnetType):
        is_auto_generated (bool): True if this subnet is auto-generated or false if this was created by the user
        provision_input (SubnetProvisionInput):
        created_by_user (UserRelation):
        project (ProjectRelation, optional, nullable):
        environment (EnvironmentRelation, optional, nullable):
        network (NetworkRelation, optional, nullable):
        credential (CredentialRelation, optional, nullable):
        last_action (ActionRelation, optional, nullable):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique id of the given record")
    name: StrictStr = Field(description="The subnet's name")
    type: SubnetType
    is_auto_generated: StrictBool = Field(
        description="True if this subnet is auto-generated or false if this was created by the user"
    )
    provision_input: SubnetProvisionInput
    created_by_user: UserRelation
    project: Optional[ProjectRelation]
    environment: Optional[EnvironmentRelation]
    network: Optional[NetworkRelation]
    credential: Optional[CredentialRelation]
    last_action: Optional[ActionRelation]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class SubnetPlain(TypedDict, total=False):
    """
    Plain version of Subnet.
    """

    id: Required[int]
    name: Required[str]
    type: Required[
        Union[
            SubnetType,
            SubnetTypePlain,
        ]
    ]
    is_auto_generated: Required[bool]
    provision_input: Required[
        Union[
            SubnetProvisionInput,
            SubnetProvisionInputPlain,
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    project: Optional[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    environment: Optional[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    network: Optional[
        Union[
            NetworkRelation,
            NetworkRelationPlain,
        ]
    ]
    credential: Optional[
        Union[
            CredentialRelation,
            CredentialRelationPlain,
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
