"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .subnet_provision_input import SubnetProvisionInput, SubnetProvisionInputPlain
from .subnet_type import SubnetType, SubnetTypePlain


class SubnetRelation(DevopnessBaseModel):
    """
    SubnetRelation

    Attributes:
        id (int): The unique id of the given record
        project_id (int): Numeric ID of the project to which the subnet belongs to
        environment_id (int): Numeric ID of the environment to which the subnet belongs to
        created_by (int): The id of the user who created the subnet
        network_id (int): Numeric ID of the network to which the subnet belongs to
        name (str): The subnet&#39;s name
        type (SubnetType):
        is_auto_generated (bool): True if this subnet is auto-generated or false if this was created by the user
        provision_input (SubnetProvisionInput):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique id of the given record")
    project_id: StrictInt = Field(
        description="Numeric ID of the project to which the subnet belongs to"
    )
    environment_id: StrictInt = Field(
        description="Numeric ID of the environment to which the subnet belongs to"
    )
    created_by: StrictInt = Field(
        description="The id of the user who created the subnet"
    )
    network_id: StrictInt = Field(
        description="Numeric ID of the network to which the subnet belongs to"
    )
    name: StrictStr = Field(description="The subnet's name")
    type: SubnetType
    is_auto_generated: StrictBool = Field(
        description="True if this subnet is auto-generated or false if this was created by the user"
    )
    provision_input: SubnetProvisionInput
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class SubnetRelationPlain(TypedDict, total=False):
    """
    Plain version of SubnetRelation.
    """

    id: Required[int]
    project_id: Required[int]
    environment_id: Required[int]
    created_by: Required[int]
    network_id: Required[int]
    name: Required[str]
    type: Required[
        Union[
            SubnetType,
            SubnetTypePlain,
        ]
    ]
    is_auto_generated: Required[bool]
    provision_input: Required[
        Union[
            SubnetProvisionInput,
            SubnetProvisionInputPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
