"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    List,
    Optional,
    TypedDict,
    Union,
)

from pydantic import Field, StrictFloat, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .subscription_balance import SubscriptionBalance, SubscriptionBalancePlain


class Subscription(DevopnessBaseModel):
    """
    Subscription

    Attributes:
        id (int, optional): The ID of the subscription
        user_id (int, optional): The ID of the user this subscription belongs to
        plan_name (str, optional): The plan name of this subscription
        status (str, optional): Status of this subscription
        quantity (int, optional): Amount of plans purchased in this subscription
        price_unit (float, optional): Unitary price of the subscribed plan
        price_total (float, optional): Total price of this subscription (quantity x price_unit)
        price_currency (str, optional): Currency of the prices
        cancelled_at (datetime, optional, nullable): If not null, indicates the date when this subscription was cancelled
        ends_at (datetime, optional): Indicates the date and time when this subscription ends
        created_at (datetime, optional): The date and time when the record was created
        updated_at (datetime, optional): The date and time when the record was last updated
        current_balance (SubscriptionBalance, optional, nullable):
        balances (List[SubscriptionBalance], optional): The list of subscription balances
    """

    id: Optional[StrictInt] = Field(
        default=None, description="The ID of the subscription"
    )
    user_id: Optional[StrictInt] = Field(
        default=None, description="The ID of the user this subscription belongs to"
    )
    plan_name: Optional[StrictStr] = Field(
        default=None, description="The plan name of this subscription"
    )
    status: Optional[StrictStr] = Field(
        default=None, description="Status of this subscription"
    )
    quantity: Optional[StrictInt] = Field(
        default=None, description="Amount of plans purchased in this subscription"
    )
    price_unit: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Unitary price of the subscribed plan"
    )
    price_total: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Total price of this subscription (quantity x price_unit)",
    )
    price_currency: Optional[StrictStr] = Field(
        default=None, description="Currency of the prices"
    )
    cancelled_at: Optional[datetime] = Field(
        default=None,
        description="If not null, indicates the date when this subscription was cancelled",
    )
    ends_at: Optional[datetime] = Field(
        default=None,
        description="Indicates the date and time when this subscription ends",
    )
    created_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was last updated"
    )
    current_balance: Optional[SubscriptionBalance] = None
    balances: Optional[List[Optional[SubscriptionBalance]]] = Field(
        default=None, description="The list of subscription balances"
    )


class SubscriptionPlain(TypedDict, total=False):
    """
    Plain version of Subscription.
    """

    id: Optional[int]
    user_id: Optional[int]
    plan_name: Optional[str]
    status: Optional[str]
    quantity: Optional[int]
    price_unit: Optional[float]
    price_total: Optional[float]
    price_currency: Optional[str]
    cancelled_at: Optional[datetime]
    ends_at: Optional[datetime]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
    current_balance: Optional[
        Union[
            SubscriptionBalance,
            SubscriptionBalancePlain,
        ]
    ]
    balances: Optional[
        List[
            Union[
                SubscriptionBalance,
                SubscriptionBalancePlain,
            ]
        ]
    ]
