"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .project_relation import ProjectRelation, ProjectRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class Team(DevopnessBaseModel):
    """
    Team

    Attributes:
        id (int): The unique ID of the given team
        name (str): The name of the given team
        photo_url (str, optional, nullable): The URL to team&#39;s image
        project (ProjectRelation, optional, nullable):
        users (List[UserRelation]): The list of users
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the given team")
    name: StrictStr = Field(description="The name of the given team")
    photo_url: Optional[StrictStr] = Field(description="The URL to team's image")
    project: Optional[ProjectRelation]
    users: List[UserRelation] = Field(description="The list of users")
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class TeamPlain(TypedDict, total=False):
    """
    Plain version of Team.
    """

    id: Required[int]
    name: Required[str]
    photo_url: Optional[str]
    project: Optional[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    users: Required[
        List[
            Union[
                UserRelation,
                UserRelationPlain,
            ]
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
