"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .project_relation import ProjectRelation, ProjectRelationPlain
from .team_invitation_status import TeamInvitationStatus, TeamInvitationStatusPlain
from .team_invitation_type import TeamInvitationType, TeamInvitationTypePlain
from .team_relation import TeamRelation, TeamRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class TeamInvitationRelation(DevopnessBaseModel):
    """
    TeamInvitationRelation

    Attributes:
        id (str): The unique UUID of the given invitation
        type (TeamInvitationType):
        email (str, optional, nullable): The email of the user that has been invited to team
        status (TeamInvitationStatus):
        status_human_readable (str): Human readable version of the invitation status
        public_accept_url (str, optional, nullable): The URL to accept the public invitation
        accepted_from_ip (str, optional, nullable): The IP of the user who accepted the invitation
        created_by_user (UserRelation):
        team (TeamRelation, optional, nullable):
        project (ProjectRelation, optional, nullable):
        accepted_at (str, optional, nullable): The date and time when the invitation was accepted
        expires_at (str): The date and time when the invitation will expire
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictStr = Field(description="The unique UUID of the given invitation")
    type: TeamInvitationType
    email: Optional[StrictStr] = Field(
        description="The email of the user that has been invited to team"
    )
    status: TeamInvitationStatus
    status_human_readable: StrictStr = Field(
        description="Human readable version of the invitation status"
    )
    public_accept_url: Optional[StrictStr] = Field(
        description="The URL to accept the public invitation"
    )
    accepted_from_ip: Optional[StrictStr] = Field(
        description="The IP of the user who accepted the invitation"
    )
    created_by_user: UserRelation
    team: Optional[TeamRelation]
    project: Optional[ProjectRelation]
    accepted_at: Optional[StrictStr] = Field(
        description="The date and time when the invitation was accepted"
    )
    expires_at: StrictStr = Field(
        description="The date and time when the invitation will expire"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class TeamInvitationRelationPlain(TypedDict, total=False):
    """
    Plain version of TeamInvitationRelation.
    """

    id: Required[str]
    type: Required[
        Union[
            TeamInvitationType,
            TeamInvitationTypePlain,
        ]
    ]
    email: Optional[str]
    status: Required[
        Union[
            TeamInvitationStatus,
            TeamInvitationStatusPlain,
        ]
    ]
    status_human_readable: Required[str]
    public_accept_url: Optional[str]
    accepted_from_ip: Optional[str]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    team: Optional[
        Union[
            TeamRelation,
            TeamRelationPlain,
        ]
    ]
    project: Optional[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    accepted_at: Optional[str]
    expires_at: Required[str]
    created_at: Required[str]
    updated_at: Required[str]
