"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class UserLoginResponse(DevopnessBaseModel):
    """
    UserLoginResponse

    Attributes:
        token_type (str): The type of the authorization token being issued
        expires_in (int): The number of seconds remaining to the token expiration time, to be counted since the token issue date and time
        access_token (str): The issued JWT access token
        refresh_token (str): A token to be used after the original access token has expired, to issue a new token without requiring a new request to the /users/login endpoint
    """

    token_type: StrictStr = Field(
        description="The type of the authorization token being issued"
    )
    expires_in: StrictInt = Field(
        description="The number of seconds remaining to the token expiration time, to be counted since the token issue date and time"
    )
    access_token: StrictStr = Field(description="The issued JWT access token")
    refresh_token: StrictStr = Field(
        description="A token to be used after the original access token has expired, to issue a new token without requiring a new request to the /users/login endpoint"
    )


class UserLoginResponsePlain(TypedDict, total=False):
    """
    Plain version of UserLoginResponse.
    """

    token_type: Required[str]
    expires_in: Required[int]
    access_token: Required[str]
    refresh_token: Required[str]
