"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing_extensions import Annotated

from .. import DevopnessBaseModel
from .language import Language, LanguagePlain


class UserRelation(DevopnessBaseModel):
    """
    UserRelation

    Attributes:
        id (int): The Id of the given user
        name (str): User&#39;s full name
        email (str): The e-mail that will uniquely identify the user on the system and become its login credential
        url_slug (str, optional): The URL Slug of the user
        language (Language, optional, nullable):
        active (bool, optional): Tells if the user is active or not
        created_at (datetime, optional): The date and time when the record was created
        updated_at (datetime, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The Id of the given user")
    name: Annotated[str, Field(min_length=3, strict=True, max_length=255)] = Field(
        description="User's full name"
    )
    email: StrictStr = Field(
        description="The e-mail that will uniquely identify the user on the system and become its login credential"
    )
    url_slug: Optional[StrictStr] = Field(
        default=None, description="The URL Slug of the user"
    )
    language: Optional[Language] = None
    active: Optional[StrictBool] = Field(
        default=None, description="Tells if the user is active or not"
    )
    created_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class UserRelationPlain(TypedDict, total=False):
    """
    Plain version of UserRelation.
    """

    id: Required[int]
    name: Required[str]
    email: Required[str]
    url_slug: Optional[str]
    language: Optional[
        Union[
            Language,
            LanguagePlain,
        ]
    ]
    active: Optional[bool]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
