"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictStr

from .. import DevopnessBaseModel
from .variable_target import VariableTarget, VariableTargetPlain
from .variable_type import VariableType, VariableTypePlain


class VariableCreate(DevopnessBaseModel):
    """
    VariableCreate

    Attributes:
        key (str): The unique key used to identify the variable on the target. Must not be greater than 100 characters.
        value (str): The value to be assigned to this variable when deployed to its target.                 When variable is of type &#x60;file&#x60;, this is the file content. Must not be greater than 21504 characters.
        description (str, optional): A text describing the variable, provided by the end user. Must not be greater than 255 characters.
        target (VariableTarget):
        type (VariableType):
        hidden (bool): Indicates if the variable value should be visible or not in the deployment logs.
    """

    key: StrictStr = Field(
        description="The unique key used to identify the variable on the target. Must not be greater than 100 characters."
    )
    value: StrictStr = Field(
        description="The value to be assigned to this variable when deployed to its target.                 When variable is of type `file`, this is the file content. Must not be greater than 21504 characters."
    )
    description: Optional[StrictStr] = Field(
        default=None,
        description="A text describing the variable, provided by the end user. Must not be greater than 255 characters.",
    )
    target: VariableTarget
    type: VariableType
    hidden: StrictBool = Field(
        description="Indicates if the variable value should be visible or not in the deployment logs."
    )


class VariableCreatePlain(TypedDict, total=False):
    """
    Plain version of VariableCreate.
    """

    key: Required[str]
    value: Required[str]
    description: Optional[str]
    target: Required[
        Union[
            VariableTarget,
            VariableTargetPlain,
        ]
    ]
    type: Required[
        Union[
            VariableType,
            VariableTypePlain,
        ]
    ]
    hidden: Required[bool]
