"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .application_relation import ApplicationRelation, ApplicationRelationPlain
from .ssl_certificate_relation import (
    SslCertificateRelation,
    SslCertificateRelationPlain,
)
from .user_relation import UserRelation, UserRelationPlain
from .virtual_host_type import VirtualHostType, VirtualHostTypePlain


class VirtualHost(DevopnessBaseModel):
    """
    VirtualHost

    Attributes:
        id (int): Unique ID of the Virtual Host
        type (VirtualHostType):
        type_human_readable (str): The human readable version of the type
        name (str): The name of the Virtual Host
        application (ApplicationRelation, optional, nullable):
        root_directory (str, optional, nullable): The document root location, within the application directory, that contains the public files to be served when a user visits the domain name associated with this virtual host
        application_listen_address (str, optional, nullable): The network name or IP address on which the application linked to this virtual host is configured to listen for incoming requests. A valid address has &#x60;http&#x60; or &#x60;https&#x60; protocol, a domain name or IP address, an optional port and optional path. You can also specify a UNIX-socket using &#x60;unix:&#x60; protocol. Examples: &#x60;http://127.0.0.1:8080&#x60; (for applications exposing port &#x60;8080&#x60;, for example running in a Docker container), &#x60;http://127.0.0.1:3000&#x60; (for applications kept alive by a daemon/background process that listens on port &#x60;3000&#x60;), &#x60;unix:/var/run/example.sock&#x60; (for applications listening on a custom socket)
        ssl_certificate (SslCertificateRelation, optional, nullable):
        last_action (ActionRelation, optional, nullable):
        created_by_user (UserRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was updated
    """

    id: StrictInt = Field(description="Unique ID of the Virtual Host")
    type: VirtualHostType
    type_human_readable: StrictStr = Field(
        description="The human readable version of the type"
    )
    name: StrictStr = Field(description="The name of the Virtual Host")
    application: Optional[ApplicationRelation]
    root_directory: Optional[StrictStr] = Field(
        description="The document root location, within the application directory, that contains the public files to be served when a user visits the domain name associated with this virtual host"
    )
    application_listen_address: Optional[StrictStr] = Field(
        description="The network name or IP address on which the application linked to this virtual host is configured to listen for incoming requests. A valid address has `http` or `https` protocol, a domain name or IP address, an optional port and optional path. You can also specify a UNIX-socket using `unix:` protocol. Examples: `http://127.0.0.1:8080` (for applications exposing port `8080`, for example running in a Docker container), `http://127.0.0.1:3000` (for applications kept alive by a daemon/background process that listens on port `3000`), `unix:/var/run/example.sock` (for applications listening on a custom socket)"
    )
    ssl_certificate: Optional[SslCertificateRelation]
    last_action: Optional[ActionRelation]
    created_by_user: UserRelation
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was updated"
    )


class VirtualHostPlain(TypedDict, total=False):
    """
    Plain version of VirtualHost.
    """

    id: Required[int]
    type: Required[
        Union[
            VirtualHostType,
            VirtualHostTypePlain,
        ]
    ]
    type_human_readable: Required[str]
    name: Required[str]
    application: Optional[
        Union[
            ApplicationRelation,
            ApplicationRelationPlain,
        ]
    ]
    root_directory: Optional[str]
    application_listen_address: Optional[str]
    ssl_certificate: Optional[
        Union[
            SslCertificateRelation,
            SslCertificateRelationPlain,
        ]
    ]
    last_action: Optional[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
