# Copyright 2024 Volvo Car Corporation
# Licensed under Apache 2.0.

"""Defines header file names for different sections generated c-code."""

CVC_CODE_START = 'CVC_CODE_START.h'  # Header file name for CVC code start
CVC_CODE_END = 'CVC_CODE_END.h'  # Header file name for CVC code end
CVC_CODE_ASIL_A_START = 'CVC_CODE_ASIL_A_START.h'  # Header file name for CVC code start
CVC_CODE_ASIL_A_END = 'CVC_CODE_ASIL_A_END.h'  # Header file name for CVC code end
CVC_CODE_ASIL_B_START = 'CVC_CODE_ASIL_B_START.h'  # Header file name for CVC code start
CVC_CODE_ASIL_B_END = 'CVC_CODE_ASIL_B_END.h'  # Header file name for CVC code end
CVC_CODE_ASIL_C_START = 'CVC_CODE_ASIL_C_START.h'  # Header file name for CVC code start
CVC_CODE_ASIL_C_END = 'CVC_CODE_ASIL_C_END.h'  # Header file name for CVC code end
CVC_CODE_ASIL_D_START = 'CVC_CODE_ASIL_D_START.h'  # Header file name for CVC code start
CVC_CODE_ASIL_D_END = 'CVC_CODE_ASIL_D_END.h'  # Header file name for CVC code end

CVC_DISP_START = 'CVC_DISP_START.h'  # Header file name for CVC measurable variables start
CVC_DISP_END = 'CVC_DISP_END.h'  # Header file name for CVC measurable variables end
CVC_DISP_ASIL_A_START = 'CVC_DISP_ASIL_A_START.h'  # Header file name for CVC ASIL A measurable variables start
CVC_DISP_ASIL_A_END = 'CVC_DISP_ASIL_A_END.h'  # Header file name for CVC ASIL A measurable variables end
CVC_DISP_ASIL_B_START = 'CVC_DISP_ASIL_B_START.h'  # Header file name for CVC ASIL B measurable variables start
CVC_DISP_ASIL_B_END = 'CVC_DISP_ASIL_B_END.h'  # Header file name for CVC ASIL B measurable variables end
CVC_DISP_ASIL_C_START = 'CVC_DISP_ASIL_C_START.h'  # Header file name for CVC ASIL C measurable variables start
CVC_DISP_ASIL_C_END = 'CVC_DISP_ASIL_C_END.h'  # Header file name for CVC ASIL C measurable variables end
CVC_DISP_ASIL_D_START = 'CVC_DISP_ASIL_D_START.h'  # Header file name for CVC ASIL D measurable variables start
CVC_DISP_ASIL_D_END = 'CVC_DISP_ASIL_D_END.h'  # Header file name for CVC ASIL D measurable variables end
CVC_DISP_SEC_START = 'CVC_DISP_SEC_START.h'  # Header file name for CVC secure measurable variables start
CVC_DISP_SEC_END = 'CVC_DISP_SEC_END.h'  # Header file name for CVC secure measurable variables end

CVC_CAL_START = 'CVC_CAL_START.h'  # Header file name for CVC calibration data start
CVC_CAL_END = 'CVC_CAL_END.h'  # Header file name for CVC calibration data end
CVC_CAL_ASIL_A_START = 'CVC_CAL_ASIL_A_START.h'  # Header file name for CVC calibration data start
CVC_CAL_ASIL_A_END = 'CVC_CAL_ASIL_A_END.h'  # Header file name for CVC calibration data end
CVC_CAL_ASIL_B_START = 'CVC_CAL_ASIL_B_START.h'  # Header file name for CVC calibration data start
CVC_CAL_ASIL_B_END = 'CVC_CAL_ASIL_B_END.h'  # Header file name for CVC calibration data end
CVC_CAL_ASIL_C_START = 'CVC_CAL_ASIL_C_START.h'  # Header file name for CVC calibration data start
CVC_CAL_ASIL_C_END = 'CVC_CAL_ASIL_C_END.h'  # Header file name for CVC calibration data end
CVC_CAL_ASIL_D_START = 'CVC_CAL_ASIL_D_START.h'  # Header file name for CVC calibration data start
CVC_CAL_ASIL_D_END = 'CVC_CAL_ASIL_D_END.h'  # Header file name for CVC calibration data end

CVC_CONST_START = 'CVC_CONST_START.h'  # Header file name for CVC calibration data start
CVC_CONST_END = 'CVC_CONST_END.h'  # Header file name for CVC calibration data end
CVC_CONST_ASIL_A_START = 'CVC_CONST_ASIL_A_START.h'  # Header file name for CVC calibration data start
CVC_CONST_ASIL_A_END = 'CVC_CONST_ASIL_A_END.h'  # Header file name for CVC calibration data end
CVC_CONST_ASIL_B_START = 'CVC_CONST_ASIL_B_START.h'  # Header file name for CVC calibration data start
CVC_CONST_ASIL_B_END = 'CVC_CONST_ASIL_B_END.h'  # Header file name for CVC calibration data end
CVC_CONST_ASIL_C_START = 'CVC_CONST_ASIL_C_START.h'  # Header file name for CVC calibration data start
CVC_CONST_ASIL_C_END = 'CVC_CONST_ASIL_C_END.h'  # Header file name for CVC calibration data end
CVC_CONST_ASIL_D_START = 'CVC_CONST_ASIL_D_START.h'  # Header file name for CVC calibration data start
CVC_CONST_ASIL_D_END = 'CVC_CONST_ASIL_D_END.h'  # Header file name for CVC calibration data end

CVC_NVM_START = 'CVC_NVM_START.h'  # Header file name for CVC Non Volatile Memory start
CVC_NVM_END = 'CVC_NVM_END.h'  # Header file name for CVC Non Volatile Memory end
CVC_NVM_P_START = 'CVC_NVM_P_START.h'  # Header file name for persistent Non Volatile Memory start
CVC_NVM_P_END = 'CVC_NVM_P_END.h'  # Header file name for persistent Non Volatile Memory end

PREDECL_CODE_START = 'PREDECL_CODE_START.h'  # Header file name for CVC code start
PREDECL_CODE_END = 'PREDECL_CODE_END.h'  # Header file name for CVC code end
PREDECL_CODE_ASIL_A_START = 'PREDECL_CODE_ASIL_A_START.h'  # Header file name for CVC code start
PREDECL_CODE_ASIL_A_END = 'PREDECL_CODE_ASIL_A_END.h'  # Header file name for CVC code end
PREDECL_CODE_ASIL_B_START = 'PREDECL_CODE_ASIL_B_START.h'  # Header file name for CVC code start
PREDECL_CODE_ASIL_B_END = 'PREDECL_CODE_ASIL_B_END.h'  # Header file name for CVC code end
PREDECL_CODE_ASIL_C_START = 'PREDECL_CODE_ASIL_C_START.h'  # Header file name for CVC code start
PREDECL_CODE_ASIL_C_END = 'PREDECL_CODE_ASIL_C_END.h'  # Header file name for CVC code end
PREDECL_CODE_ASIL_D_START = 'PREDECL_CODE_ASIL_D_START.h'  # Header file name for CVC code start
PREDECL_CODE_ASIL_D_END = 'PREDECL_CODE_ASIL_D_END.h'  # Header file name for CVC code end

PREDECL_DISP_START = 'PREDECL_DISP_START.h'  # Header file name for CVC measurable variables start
PREDECL_DISP_END = 'PREDECL_DISP_END.h'  # Header file name for CVC measurable variables end
PREDECL_DISP_ASIL_A_START = 'PREDECL_DISP_ASIL_A_START.h'  # Header file name for CVC ASIL A measurable variables start
PREDECL_DISP_ASIL_A_END = 'PREDECL_DISP_ASIL_A_END.h'  # Header file name for CVC ASIL A measurable variables end
PREDECL_DISP_ASIL_B_START = 'PREDECL_DISP_ASIL_B_START.h'  # Header file name for CVC ASIL B measurable variables start
PREDECL_DISP_ASIL_B_END = 'PREDECL_DISP_ASIL_B_END.h'  # Header file name for CVC ASIL B measurable variables end
PREDECL_DISP_ASIL_C_START = 'PREDECL_DISP_ASIL_C_START.h'  # Header file name for CVC ASIL C measurable variables start
PREDECL_DISP_ASIL_C_END = 'PREDECL_DISP_ASIL_C_END.h'  # Header file name for CVC ASIL C measurable variables end
PREDECL_DISP_ASIL_D_START = 'PREDECL_DISP_ASIL_D_START.h'  # Header file name for CVC ASIL D measurable variables start
PREDECL_DISP_ASIL_D_END = 'PREDECL_DISP_ASIL_D_END.h'  # Header file name for CVC ASIL D measurable variables end
PREDECL_DISP_SEC_START = 'PREDECL_DISP_SEC_START.h'  # Header file name for CVC secure measurable variables start
PREDECL_DISP_SEC_END = 'PREDECL_DISP_SEC_END.h'  # Header file name for CVC secure measurable variables end

PREDECL_CAL_START = 'PREDECL_CAL_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_END = 'PREDECL_CAL_END.h'  # Header file name for CVC calibration data end
PREDECL_CAL_ASIL_A_START = 'PREDECL_CAL_ASIL_A_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_ASIL_A_END = 'PREDECL_CAL_ASIL_A_END.h'  # Header file name for CVC calibration data end
PREDECL_CAL_ASIL_B_START = 'PREDECL_CAL_ASIL_B_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_ASIL_B_END = 'PREDECL_CAL_ASIL_B_END.h'  # Header file name for CVC calibration data end
PREDECL_CAL_ASIL_C_START = 'PREDECL_CAL_ASIL_C_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_ASIL_C_END = 'PREDECL_CAL_ASIL_C_END.h'  # Header file name for CVC calibration data end
PREDECL_CAL_ASIL_D_START = 'PREDECL_CAL_ASIL_D_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_ASIL_D_END = 'PREDECL_CAL_ASIL_D_END.h'  # Header file name for CVC calibration data end
PREDECL_CAL_EXT_START = 'PREDECL_CAL_EXT_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_EXT_END = 'PREDECL_CAL_EXT_END.h'  # Header file name for CVC calibration data end
PREDECL_CAL_MERG_START = 'PREDECL_CAL_MERG_START.h'  # Header file name for CVC calibration data start
PREDECL_CAL_MERG_END = 'PREDECL_CAL_MERG_END.h'  # Header file name for CVC calibration data end

PREDECL_CONST_START = 'PREDECL_CONST_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_END = 'PREDECL_CONST_END.h'  # Header file name for CVC calibration data end
PREDECL_CONST_ASIL_A_START = 'PREDECL_CONST_ASIL_A_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_ASIL_A_END = 'PREDECL_CONST_ASIL_A_END.h'  # Header file name for CVC calibration data end
PREDECL_CONST_ASIL_B_START = 'PREDECL_CONST_ASIL_B_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_ASIL_B_END = 'PREDECL_CONST_ASIL_B_END.h'  # Header file name for CVC calibration data end
PREDECL_CONST_ASIL_C_START = 'PREDECL_CONST_ASIL_C_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_ASIL_C_END = 'PREDECL_CONST_ASIL_C_END.h'  # Header file name for CVC calibration data end
PREDECL_CONST_ASIL_D_START = 'PREDECL_CONST_ASIL_D_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_ASIL_D_END = 'PREDECL_CONST_ASIL_D_END.h'  # Header file name for CVC calibration data end
PREDECL_CONST_EXT_START = 'PREDECL_CONST_EXT_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_EXT_END = 'PREDECL_CONST_EXT_END.h'  # Header file name for CVC calibration data end
PREDECL_CONST_MERG_START = 'PREDECL_CONST_MERG_START.h'  # Header file name for CVC calibration data start
PREDECL_CONST_MERG_END = 'PREDECL_CONST_MERG_END.h'  # Header file name for CVC calibration data end

PREDECL_NVM_START = 'PREDECL_NVM_START.h'  # Header file name for CVC Non Volatile Memory start
PREDECL_NVM_END = 'PREDECL_NVM_END.h'  # Header file name for CVC Non Volatile Memory end
PREDECL_NVM_P_START = 'PREDECL_NVM_P_START.h'  # Header file name for persistent Non Volatile Memory start
PREDECL_NVM_P_END = 'PREDECL_NVM_P_END.h'  # Header file name for persistent Non Volatile Memory end

PREDECL_START = 'PREDECL_START.h'
PREDECL_END = 'PREDECL_END.h'

CVC_CODE_QM = {'START': CVC_CODE_START, 'END': CVC_CODE_END}
CVC_CODE_A = {'START': CVC_CODE_ASIL_A_START, 'END': CVC_CODE_ASIL_A_END}
CVC_CODE_B = {'START': CVC_CODE_ASIL_B_START, 'END': CVC_CODE_ASIL_B_END}
CVC_CODE_C = {'START': CVC_CODE_ASIL_C_START, 'END': CVC_CODE_ASIL_C_END}
CVC_CODE_D = {'START': CVC_CODE_ASIL_D_START, 'END': CVC_CODE_ASIL_D_END}

CVC_DISP_QM = {'START': CVC_DISP_START, 'END': CVC_DISP_END}
CVC_DISP_A = {'START': CVC_DISP_ASIL_A_START, 'END': CVC_DISP_ASIL_A_END}
CVC_DISP_B = {'START': CVC_DISP_ASIL_B_START, 'END': CVC_DISP_ASIL_B_END}
CVC_DISP_C = {'START': CVC_DISP_ASIL_C_START, 'END': CVC_DISP_ASIL_C_END}
CVC_DISP_D = {'START': CVC_DISP_ASIL_D_START, 'END': CVC_DISP_ASIL_D_END}
CVC_DISP_SECURE = {'START': CVC_DISP_SEC_START, 'END': CVC_DISP_SEC_END}

CVC_CAL_QM = {'START': CVC_CAL_START, 'END': CVC_CAL_END}
CVC_CAL_A = {'START': CVC_CAL_ASIL_A_START, 'END': CVC_CAL_ASIL_A_END}
CVC_CAL_B = {'START': CVC_CAL_ASIL_B_START, 'END': CVC_CAL_ASIL_B_END}
CVC_CAL_C = {'START': CVC_CAL_ASIL_C_START, 'END': CVC_CAL_ASIL_C_END}
CVC_CAL_D = {'START': CVC_CAL_ASIL_D_START, 'END': CVC_CAL_ASIL_D_END}

CVC_CONST_QM = {'START': CVC_CONST_START, 'END': CVC_CONST_END}
CVC_CONST_A = {'START': CVC_CONST_ASIL_A_START, 'END': CVC_CONST_ASIL_A_END}
CVC_CONST_B = {'START': CVC_CONST_ASIL_B_START, 'END': CVC_CONST_ASIL_B_END}
CVC_CONST_C = {'START': CVC_CONST_ASIL_C_START, 'END': CVC_CONST_ASIL_C_END}
CVC_CONST_D = {'START': CVC_CONST_ASIL_D_START, 'END': CVC_CONST_ASIL_D_END}

CVC_NVM = {'START': CVC_NVM_START, 'END': CVC_NVM_END}
CVC_NVM_P = {'START': CVC_NVM_P_START, 'END': CVC_NVM_P_END}

PREDECL = {'START': PREDECL_START, 'END': PREDECL_END}

PREDECL_CODE_QM = {'START': PREDECL_CODE_START, 'END': PREDECL_CODE_END}
PREDECL_CODE_A = {'START': PREDECL_CODE_ASIL_A_START, 'END': PREDECL_CODE_ASIL_A_END}
PREDECL_CODE_B = {'START': PREDECL_CODE_ASIL_B_START, 'END': PREDECL_CODE_ASIL_B_END}
PREDECL_CODE_C = {'START': PREDECL_CODE_ASIL_C_START, 'END': PREDECL_CODE_ASIL_C_END}
PREDECL_CODE_D = {'START': PREDECL_CODE_ASIL_D_START, 'END': PREDECL_CODE_ASIL_D_END}

PREDECL_DISP_QM = {'START': PREDECL_DISP_START, 'END': PREDECL_DISP_END}
PREDECL_DISP_A = {'START': PREDECL_DISP_ASIL_A_START, 'END': PREDECL_DISP_ASIL_A_END}
PREDECL_DISP_B = {'START': PREDECL_DISP_ASIL_B_START, 'END': PREDECL_DISP_ASIL_B_END}
PREDECL_DISP_C = {'START': PREDECL_DISP_ASIL_C_START, 'END': PREDECL_DISP_ASIL_C_END}
PREDECL_DISP_D = {'START': PREDECL_DISP_ASIL_D_START, 'END': PREDECL_DISP_ASIL_D_END}
PREDECL_DISP_SECURE = {'START': PREDECL_DISP_SEC_START, 'END': PREDECL_DISP_SEC_END}

PREDECL_CAL_QM = {'START': PREDECL_CAL_START, 'END': PREDECL_CAL_END}
PREDECL_CAL_A = {'START': PREDECL_CAL_ASIL_A_START, 'END': PREDECL_CAL_ASIL_A_END}
PREDECL_CAL_B = {'START': PREDECL_CAL_ASIL_B_START, 'END': PREDECL_CAL_ASIL_B_END}
PREDECL_CAL_C = {'START': PREDECL_CAL_ASIL_C_START, 'END': PREDECL_CAL_ASIL_C_END}
PREDECL_CAL_D = {'START': PREDECL_CAL_ASIL_D_START, 'END': PREDECL_CAL_ASIL_D_END}
PREDECL_CAL_EXT = {'START': PREDECL_CAL_EXT_START, 'END': PREDECL_CAL_EXT_END}
PREDECL_CAL_MERG = {'START': PREDECL_CAL_MERG_START, 'END': PREDECL_CAL_MERG_END}

PREDECL_CONST_QM = {'START': PREDECL_CONST_START, 'END': PREDECL_CONST_END}
PREDECL_CONST_A = {'START': PREDECL_CONST_ASIL_A_START, 'END': PREDECL_CONST_ASIL_A_END}
PREDECL_CONST_B = {'START': PREDECL_CONST_ASIL_B_START, 'END': PREDECL_CONST_ASIL_B_END}
PREDECL_CONST_C = {'START': PREDECL_CONST_ASIL_C_START, 'END': PREDECL_CONST_ASIL_C_END}
PREDECL_CONST_D = {'START': PREDECL_CONST_ASIL_D_START, 'END': PREDECL_CONST_ASIL_D_END}
PREDECL_CONST_EXT = {'START': PREDECL_CONST_EXT_START, 'END': PREDECL_CONST_EXT_END}
PREDECL_CONST_MERG = {'START': PREDECL_CONST_MERG_START, 'END': PREDECL_CONST_MERG_END}

PREDECL_NVM = {'START': PREDECL_NVM_START, 'END': PREDECL_NVM_END}
PREDECL_NVM_P = {'START': PREDECL_NVM_P_START, 'END': PREDECL_NVM_P_END}

CVC_SECURE = {
    'CODE': CVC_CODE_QM,
    'DISP': CVC_DISP_SECURE,
    'CAL': CVC_CAL_QM,
    'CONST': CVC_CONST_QM
}

CVC_ASIL_QM = {
    'CODE': CVC_CODE_QM,
    'DISP': CVC_DISP_QM,
    'CAL': CVC_CAL_QM,
    'CONST': CVC_CONST_QM
}

CVC_ASIL_A = {
    'CODE': CVC_CODE_A,
    'DISP': CVC_DISP_A,
    'CAL': CVC_CAL_A,
    'CONST': CVC_CONST_A
}

CVC_ASIL_B = {
    'CODE': CVC_CODE_B,
    'DISP': CVC_DISP_B,
    'CAL': CVC_CAL_B,
    'CONST': CVC_CONST_B
}

CVC_ASIL_C = {
    'CODE': CVC_CODE_C,
    'DISP': CVC_DISP_C,
    'CAL': CVC_CAL_C,
    'CONST': CVC_CONST_C
}

CVC_ASIL_D = {
    'CODE': CVC_CODE_D,
    'DISP': CVC_DISP_D,
    'CAL': CVC_CAL_D,
    'CONST': CVC_CONST_D
}

PREDECL_SECURE = {
    'CODE': PREDECL_CODE_QM,
    'DISP': PREDECL_DISP_SECURE,
    'CAL': PREDECL_CAL_QM,
    'CONST': PREDECL_CONST_QM
}

PREDECL_ASIL_QM = {
    'CODE': PREDECL_CODE_QM,
    'DISP': PREDECL_DISP_QM,
    'CAL': PREDECL_CAL_QM,
    'CONST': PREDECL_CONST_QM
}

PREDECL_ASIL_A = {
    'CODE': PREDECL_CODE_A,
    'DISP': PREDECL_DISP_A,
    'CAL': PREDECL_CAL_A,
    'CONST': PREDECL_CONST_A
}

PREDECL_ASIL_B = {
    'CODE': PREDECL_CODE_B,
    'DISP': PREDECL_DISP_B,
    'CAL': PREDECL_CAL_B,
    'CONST': PREDECL_CONST_B
}

PREDECL_ASIL_C = {
    'CODE': PREDECL_CODE_C,
    'DISP': PREDECL_DISP_C,
    'CAL': PREDECL_CAL_C,
    'CONST': PREDECL_CONST_C
}

PREDECL_ASIL_D = {
    'CODE': PREDECL_CODE_D,
    'DISP': PREDECL_DISP_D,
    'CAL': PREDECL_CAL_D,
    'CONST': PREDECL_CONST_D
}

PREDECL_EXTRA = {
    'NORM': PREDECL,
    'CAL_EXT': PREDECL_CAL_EXT,
    'CONST_EXT': PREDECL_CONST_EXT,
    'CAL_MERG': PREDECL_CAL_MERG,
    'CONST_MERG': PREDECL_CONST_MERG
}

NVM = {'CVC': CVC_NVM, 'PREDECL': PREDECL_NVM}
NVM_P = {'CVC': CVC_NVM_P, 'PREDECL': PREDECL_NVM_P}
SECURE = {'CVC': CVC_SECURE, 'PREDECL': PREDECL_SECURE}
ASIL_QM = {'CVC': CVC_ASIL_QM, 'PREDECL': PREDECL_ASIL_QM}
ASIL_A = {'CVC': CVC_ASIL_A, 'PREDECL': PREDECL_ASIL_A}
ASIL_B = {'CVC': CVC_ASIL_B, 'PREDECL': PREDECL_ASIL_B}
ASIL_C = {'CVC': CVC_ASIL_C, 'PREDECL': PREDECL_ASIL_C}
ASIL_D = {'CVC': CVC_ASIL_D, 'PREDECL': PREDECL_ASIL_D}

NVM_LEVEL_MAP = {
    'NORMAL': NVM,
    'PROTECTED': NVM_P
}

CVC_ASIL_LEVEL_MAP = {
    'QM': CVC_ASIL_QM,
    'A': CVC_ASIL_A,
    'B': CVC_ASIL_B,
    'C': CVC_ASIL_C,
    'D': CVC_ASIL_D
}

PREDECL_ASIL_LEVEL_MAP = {
    'QM': PREDECL_ASIL_QM,
    'A': PREDECL_ASIL_A,
    'B': PREDECL_ASIL_B,
    'C': PREDECL_ASIL_C,
    'D': PREDECL_ASIL_D
}

ASIL_LEVEL_MAP = {
    'QM': ASIL_QM,
    'A': ASIL_A,
    'B': ASIL_B,
    'C': ASIL_C,
    'D': ASIL_D
}
