# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic.v1 import Field, StrictBool

from typing import Optional

from pieces._vendor.pieces_os_client.models.onboarded_persona_details import OnboardedPersonaDetails
from pieces._vendor.pieces_os_client.models.preonboarded_persona_details import PreonboardedPersonaDetails
from pieces._vendor.pieces_os_client.models.segmented_technical_language import SegmentedTechnicalLanguage
from pieces._vendor.pieces_os_client.models.unsegmented_technical_language import UnsegmentedTechnicalLanguage

from pieces._vendor.pieces_os_client.api_client import ApiClient
from pieces._vendor.pieces_os_client.api_response import ApiResponse
from pieces._vendor.pieces_os_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MachineLearningApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def personification_technical_language_generation(self, preonboarded_persona_details : Optional[PreonboardedPersonaDetails] = None, **kwargs) -> OnboardedPersonaDetails:  # noqa: E501
        """/machine_learning/text/technical_language/generators/personification [GET]  # noqa: E501

        This is going to take in some personification details ie languages & personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.personification_technical_language_generation(preonboarded_persona_details, async_req=True)
        >>> result = thread.get()

        :param preonboarded_persona_details:
        :type preonboarded_persona_details: PreonboardedPersonaDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OnboardedPersonaDetails
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the personification_technical_language_generation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.personification_technical_language_generation_with_http_info(preonboarded_persona_details, **kwargs)  # noqa: E501

    @validate_arguments
    def personification_technical_language_generation_with_http_info(self, preonboarded_persona_details : Optional[PreonboardedPersonaDetails] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """/machine_learning/text/technical_language/generators/personification [GET]  # noqa: E501

        This is going to take in some personification details ie languages & personas.  and will return generated Seeds that can be used as snippets post/pre onboarding.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.personification_technical_language_generation_with_http_info(preonboarded_persona_details, async_req=True)
        >>> result = thread.get()

        :param preonboarded_persona_details:
        :type preonboarded_persona_details: PreonboardedPersonaDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OnboardedPersonaDetails, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'preonboarded_persona_details'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method personification_technical_language_generation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['preonboarded_persona_details'] is not None:
            _body_params = _params['preonboarded_persona_details']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['application']  # noqa: E501

        _response_types_map = {
            '200': "OnboardedPersonaDetails",
            '500': "str",
        }

        return self.api_client.call_api(
            '/machine_learning/text/technical_language/generators/personification', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def segment_technical_language(self, classify : Annotated[Optional[StrictBool], Field(description="This will let us know if you want us to classifiy your code, this is default to false.")] = None, unsegmented_technical_language : Optional[UnsegmentedTechnicalLanguage] = None, **kwargs) -> SegmentedTechnicalLanguage:  # noqa: E501
        """/machine_learning/text/technical_language/parsers/segmentation [POST]  # noqa: E501

        This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along 'classify' then we will optionally classify the just the code that is segmented.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.segment_technical_language(classify, unsegmented_technical_language, async_req=True)
        >>> result = thread.get()

        :param classify: This will let us know if you want us to classifiy your code, this is default to false.
        :type classify: bool
        :param unsegmented_technical_language:
        :type unsegmented_technical_language: UnsegmentedTechnicalLanguage
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SegmentedTechnicalLanguage
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the segment_technical_language_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.segment_technical_language_with_http_info(classify, unsegmented_technical_language, **kwargs)  # noqa: E501

    @validate_arguments
    def segment_technical_language_with_http_info(self, classify : Annotated[Optional[StrictBool], Field(description="This will let us know if you want us to classifiy your code, this is default to false.")] = None, unsegmented_technical_language : Optional[UnsegmentedTechnicalLanguage] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """/machine_learning/text/technical_language/parsers/segmentation [POST]  # noqa: E501

        This is a functional endpoint that will parse a message or text in to text or code.  if the optional query param is passed along 'classify' then we will optionally classify the just the code that is segmented.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.segment_technical_language_with_http_info(classify, unsegmented_technical_language, async_req=True)
        >>> result = thread.get()

        :param classify: This will let us know if you want us to classifiy your code, this is default to false.
        :type classify: bool
        :param unsegmented_technical_language:
        :type unsegmented_technical_language: UnsegmentedTechnicalLanguage
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SegmentedTechnicalLanguage, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'classify',
            'unsegmented_technical_language'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method segment_technical_language" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('classify') is not None:  # noqa: E501
            _query_params.append(('classify', _params['classify']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['unsegmented_technical_language'] is not None:
            _body_params = _params['unsegmented_technical_language']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['application']  # noqa: E501

        _response_types_map = {
            '200': "SegmentedTechnicalLanguage",
            '500': "str",
        }

        return self.api_client.call_api(
            '/machine_learning/text/technical_language/parsers/segmentation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
