# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr

class AppletServingHandlerType(BaseModel):
    """
    A type representing a handler with optional folder/asset flags and a required key  # noqa: E501
    """
    is_folder: Optional[StrictBool] = Field(default=None, alias="isFolder", description="Indicates if the handler is for a folder (optional)")
    is_asset: Optional[StrictBool] = Field(default=None, alias="isAsset", description="Indicates if the handler is for an asset (optional)")
    version: Optional[StrictStr] = Field(default=None, description="The version of the applet served by the handler")
    type: StrictStr = Field(default=..., description="A required unique identifier for the handler")
    __properties = ["isFolder", "isAsset", "version", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AppletServingHandlerType:
        """Create an instance of AppletServingHandlerType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if is_folder (nullable) is None
        # and __fields_set__ contains the field
        if self.is_folder is None and "is_folder" in self.__fields_set__:
            _dict['isFolder'] = None

        # set to None if is_asset (nullable) is None
        # and __fields_set__ contains the field
        if self.is_asset is None and "is_asset" in self.__fields_set__:
            _dict['isAsset'] = None

        # set to None if version (nullable) is None
        # and __fields_set__ contains the field
        if self.version is None and "version" in self.__fields_set__:
            _dict['version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AppletServingHandlerType:
        """Create an instance of AppletServingHandlerType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AppletServingHandlerType.parse_obj(obj)

        _obj = AppletServingHandlerType.parse_obj({
            "is_folder": obj.get("isFolder"),
            "is_asset": obj.get("isAsset"),
            "version": obj.get("version"),
            "type": obj.get("type")
        })
        return _obj


