# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from pieces._vendor.pieces_os_client.models.auth0_identity import Auth0Identity
from pieces._vendor.pieces_os_client.models.auth0_redirects import Auth0Redirects
from pieces._vendor.pieces_os_client.models.auth0_user import Auth0User
from pieces._vendor.pieces_os_client.models.auth0_user_metadata import Auth0UserMetadata
from pieces._vendor.pieces_os_client.models.o_auth_group import OAuthGroup

class Auth0(BaseModel):
    """
    An object representing all of the properties that are available within a Auth0 PKCE Flow  # noqa: E501
    """
    identity: Optional[Auth0Identity] = None
    user: Optional[Auth0User] = None
    metadata: Optional[Auth0UserMetadata] = None
    domain: StrictStr = Field(default=..., description="The domain of your Auth 0 Service")
    client: StrictStr = Field(default=..., description="The Client ID for your Auth0 Service")
    audience: StrictStr = Field(default=..., description="The Server Audience of your Auth0 Service")
    redirects: Auth0Redirects = Field(...)
    o_auth: OAuthGroup = Field(default=..., alias="oAuth")
    namespace: Optional[StrictStr] = Field(default=None, description="An optional namespace parameter to add an additional namespace")
    __properties = ["identity", "user", "metadata", "domain", "client", "audience", "redirects", "oAuth", "namespace"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Auth0:
        """Create an instance of Auth0 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of identity
        if self.identity:
            _dict['identity'] = self.identity.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of redirects
        if self.redirects:
            _dict['redirects'] = self.redirects.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of o_auth
        if self.o_auth:
            _dict['oAuth'] = self.o_auth.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Auth0:
        """Create an instance of Auth0 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Auth0.parse_obj(obj)

        _obj = Auth0.parse_obj({
            "identity": Auth0Identity.from_dict(obj.get("identity")) if obj.get("identity") is not None else None,
            "user": Auth0User.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "metadata": Auth0UserMetadata.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None,
            "domain": obj.get("domain"),
            "client": obj.get("client"),
            "audience": obj.get("audience"),
            "redirects": Auth0Redirects.from_dict(obj.get("redirects")) if obj.get("redirects") is not None else None,
            "o_auth": OAuthGroup.from_dict(obj.get("oAuth")) if obj.get("oAuth") is not None else None,
            "namespace": obj.get("namespace")
        })
        return _obj


