# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictFloat, StrictInt
from pieces._vendor.pieces_os_client.models.backup import Backup
from pieces._vendor.pieces_os_client.models.backup_status_enum import BackupStatusEnum
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class BackupStatus(BaseModel):
    """
    TODO add more description to this.  can eventually add a number that display the percent downloaded an so on.(this is called percent 0-100)  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    value: Optional[BackupStatusEnum] = None
    percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Optionally if the download is in progress you will receive a download percent(from 0-100).")
    backup: Backup = Field(...)
    __properties = ["schema", "value", "percentage", "backup"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BackupStatus:
        """Create an instance of BackupStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of backup
        if self.backup:
            _dict['backup'] = self.backup.to_dict()
        # set to None if percentage (nullable) is None
        # and __fields_set__ contains the field
        if self.percentage is None and "percentage" in self.__fields_set__:
            _dict['percentage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BackupStatus:
        """Create an instance of BackupStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BackupStatus.parse_obj(obj)

        _obj = BackupStatus.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "value": obj.get("value"),
            "percentage": obj.get("percentage"),
            "backup": Backup.from_dict(obj.get("backup")) if obj.get("backup") is not None else None
        })
        return _obj


