# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from pieces._vendor.pieces_os_client.models.auth0_redirects import Auth0Redirects
from pieces._vendor.pieces_os_client.models.descope_user import DescopeUser
from pieces._vendor.pieces_os_client.models.o_auth_group import OAuthGroup

class Descope(BaseModel):
    """
    An object representing all of the properties that are available within a Descope PKCE Flow  # noqa: E501
    """
    redirects: Auth0Redirects = Field(...)
    o_auth: OAuthGroup = Field(default=..., alias="oAuth")
    user: Optional[DescopeUser] = None
    audience: Optional[StrictStr] = None
    __properties = ["redirects", "oAuth", "user", "audience"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Descope:
        """Create an instance of Descope from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of redirects
        if self.redirects:
            _dict['redirects'] = self.redirects.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of o_auth
        if self.o_auth:
            _dict['oAuth'] = self.o_auth.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Descope:
        """Create an instance of Descope from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Descope.parse_obj(obj)

        _obj = Descope.parse_obj({
            "redirects": Auth0Redirects.from_dict(obj.get("redirects")) if obj.get("redirects") is not None else None,
            "o_auth": OAuthGroup.from_dict(obj.get("oAuth")) if obj.get("oAuth") is not None else None,
            "user": DescopeUser.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "audience": obj.get("audience")
        })
        return _obj


