# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class NativeOCR(BaseModel):
    """
    This is a specific model to encapsulate nativeOCR(previously named WorkflowMapping) data from the LTM(used within the WorkstreamEvent.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    ocr_text: StrictStr = Field(default=..., alias="ocrText", description="The OCR text extracted.")
    ocr_text_hash: StrictStr = Field(default=..., alias="ocrTextHash", description="The hash of the OCR text.")
    app_title: StrictStr = Field(default=..., alias="appTitle", description="The title of the application.")
    window_title: StrictStr = Field(default=..., alias="windowTitle", description="The title of the window.")
    browser_url: Optional[StrictStr] = Field(default=None, alias="browserUrl", description="The URL of the browser.")
    is_merged: StrictBool = Field(default=..., alias="isMerged", description="Indicates whether the workflow mapping is merged.")
    is_cached: StrictBool = Field(default=..., alias="isCached", description="Indicates whether the workflow mapping is cached.")
    embedding_model_unique_name: Optional[StrictStr] = Field(default=None, alias="embeddingModelUniqueName", description="Optional unique name for the embedding model.")
    __properties = ["schema", "ocrText", "ocrTextHash", "appTitle", "windowTitle", "browserUrl", "isMerged", "isCached", "embeddingModelUniqueName"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NativeOCR:
        """Create an instance of NativeOCR from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NativeOCR:
        """Create an instance of NativeOCR from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NativeOCR.parse_obj(obj)

        _obj = NativeOCR.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "ocr_text": obj.get("ocrText"),
            "ocr_text_hash": obj.get("ocrTextHash"),
            "app_title": obj.get("appTitle"),
            "window_title": obj.get("windowTitle"),
            "browser_url": obj.get("browserUrl"),
            "is_merged": obj.get("isMerged"),
            "is_cached": obj.get("isCached"),
            "embedding_model_unique_name": obj.get("embeddingModelUniqueName")
        })
        return _obj


