# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp
from pieces._vendor.pieces_os_client.models.ollama_deployment_status_enum import OllamaDeploymentStatusEnum

class OllamaDeployment(BaseModel):
    """
    A deployment will be used in 4 cases: 1. used to describe an installation in progress 2. used to describe an update in progress 3. used to say what deployment will be needed to upgrade to. 4. used to say what the current version of ollama is present on the machine.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    id: Optional[StrictStr] = None
    status: Optional[OllamaDeploymentStatusEnum] = None
    updated: Optional[GroupedTimestamp] = None
    percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Optionally if the update is in progress you will recieve a download percent(from 0-100).")
    version: StrictStr = Field(...)
    user_managed: Optional[StrictBool] = Field(default=None, alias="userManaged", description="Optionally set, specifically in the case where an update is required, and a user need to take manual action.")
    __properties = ["schema", "id", "status", "updated", "percentage", "version", "userManaged"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OllamaDeployment:
        """Create an instance of OllamaDeployment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of updated
        if self.updated:
            _dict['updated'] = self.updated.to_dict()
        # set to None if percentage (nullable) is None
        # and __fields_set__ contains the field
        if self.percentage is None and "percentage" in self.__fields_set__:
            _dict['percentage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OllamaDeployment:
        """Create an instance of OllamaDeployment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OllamaDeployment.parse_obj(obj)

        _obj = OllamaDeployment.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "id": obj.get("id"),
            "status": obj.get("status"),
            "updated": GroupedTimestamp.from_dict(obj.get("updated")) if obj.get("updated") is not None else None,
            "percentage": obj.get("percentage"),
            "version": obj.get("version"),
            "user_managed": obj.get("userManaged")
        })
        return _obj


