# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.os_device_gpu_hardware_capabilities_information import OSDeviceGPUHardwareCapabilitiesInformation

class OSDeviceGPUHardwareInformation(BaseModel):
    """
    This will let us know specific hardware information related to the GPU.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    name: Optional[StrictStr] = None
    memory: Optional[Union[StrictFloat, StrictInt]] = None
    shared_memory: Optional[StrictBool] = None
    capabilities: Optional[OSDeviceGPUHardwareCapabilitiesInformation] = None
    __properties = ["schema", "name", "memory", "shared_memory", "capabilities"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OSDeviceGPUHardwareInformation:
        """Create an instance of OSDeviceGPUHardwareInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of capabilities
        if self.capabilities:
            _dict['capabilities'] = self.capabilities.to_dict()
        # set to None if shared_memory (nullable) is None
        # and __fields_set__ contains the field
        if self.shared_memory is None and "shared_memory" in self.__fields_set__:
            _dict['shared_memory'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OSDeviceGPUHardwareInformation:
        """Create an instance of OSDeviceGPUHardwareInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OSDeviceGPUHardwareInformation.parse_obj(obj)

        _obj = OSDeviceGPUHardwareInformation.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "name": obj.get("name"),
            "memory": obj.get("memory"),
            "shared_memory": obj.get("shared_memory"),
            "capabilities": OSDeviceGPUHardwareCapabilitiesInformation.from_dict(obj.get("capabilities")) if obj.get("capabilities") is not None else None
        })
        return _obj


