# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, ValidationError, validator
from pieces._vendor.pieces_os_client.models.paddle_checkout_closed_event import PaddleCheckoutClosedEvent
from pieces._vendor.pieces_os_client.models.paddle_checkout_completed_event import PaddleCheckoutCompletedEvent
from pieces._vendor.pieces_os_client.models.paddle_checkout_error_event import PaddleCheckoutErrorEvent
from pieces._vendor.pieces_os_client.models.paddle_checkout_loaded_event import PaddleCheckoutLoadedEvent
from pieces._vendor.pieces_os_client.models.paddle_checkout_updated_event import PaddleCheckoutUpdatedEvent
from pieces._vendor.pieces_os_client.models.paddle_checkout_warning_event import PaddleCheckoutWarningEvent
from typing import Union, Any, List, TYPE_CHECKING
from pydantic.v1 import StrictStr, Field

PADDLECHECKOUTEVENT_ONE_OF_SCHEMAS = ["PaddleCheckoutClosedEvent", "PaddleCheckoutCompletedEvent", "PaddleCheckoutErrorEvent", "PaddleCheckoutLoadedEvent", "PaddleCheckoutUpdatedEvent", "PaddleCheckoutWarningEvent"]

class PaddleCheckoutEvent(BaseModel):
    """
    Top-level wrapper that discriminates on name or type
    """
    # data type: PaddleCheckoutLoadedEvent
    oneof_schema_1_validator: Optional[PaddleCheckoutLoadedEvent] = None
    # data type: PaddleCheckoutClosedEvent
    oneof_schema_2_validator: Optional[PaddleCheckoutClosedEvent] = None
    # data type: PaddleCheckoutUpdatedEvent
    oneof_schema_3_validator: Optional[PaddleCheckoutUpdatedEvent] = None
    # data type: PaddleCheckoutCompletedEvent
    oneof_schema_4_validator: Optional[PaddleCheckoutCompletedEvent] = None
    # data type: PaddleCheckoutWarningEvent
    oneof_schema_5_validator: Optional[PaddleCheckoutWarningEvent] = None
    # data type: PaddleCheckoutErrorEvent
    oneof_schema_6_validator: Optional[PaddleCheckoutErrorEvent] = None
    if TYPE_CHECKING:
        actual_instance: Union[PaddleCheckoutClosedEvent, PaddleCheckoutCompletedEvent, PaddleCheckoutErrorEvent, PaddleCheckoutLoadedEvent, PaddleCheckoutUpdatedEvent, PaddleCheckoutWarningEvent]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(PADDLECHECKOUTEVENT_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = PaddleCheckoutEvent.construct()
        error_messages = []
        match = 0
        # validate data type: PaddleCheckoutLoadedEvent
        if not isinstance(v, PaddleCheckoutLoadedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaddleCheckoutLoadedEvent`")
        else:
            match += 1
        # validate data type: PaddleCheckoutClosedEvent
        if not isinstance(v, PaddleCheckoutClosedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaddleCheckoutClosedEvent`")
        else:
            match += 1
        # validate data type: PaddleCheckoutUpdatedEvent
        if not isinstance(v, PaddleCheckoutUpdatedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaddleCheckoutUpdatedEvent`")
        else:
            match += 1
        # validate data type: PaddleCheckoutCompletedEvent
        if not isinstance(v, PaddleCheckoutCompletedEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaddleCheckoutCompletedEvent`")
        else:
            match += 1
        # validate data type: PaddleCheckoutWarningEvent
        if not isinstance(v, PaddleCheckoutWarningEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaddleCheckoutWarningEvent`")
        else:
            match += 1
        # validate data type: PaddleCheckoutErrorEvent
        if not isinstance(v, PaddleCheckoutErrorEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaddleCheckoutErrorEvent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in PaddleCheckoutEvent with oneOf schemas: PaddleCheckoutClosedEvent, PaddleCheckoutCompletedEvent, PaddleCheckoutErrorEvent, PaddleCheckoutLoadedEvent, PaddleCheckoutUpdatedEvent, PaddleCheckoutWarningEvent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in PaddleCheckoutEvent with oneOf schemas: PaddleCheckoutClosedEvent, PaddleCheckoutCompletedEvent, PaddleCheckoutErrorEvent, PaddleCheckoutLoadedEvent, PaddleCheckoutUpdatedEvent, PaddleCheckoutWarningEvent. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> PaddleCheckoutEvent:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> PaddleCheckoutEvent:
        """Returns the object represented by the json string"""
        instance = PaddleCheckoutEvent.construct()
        error_messages = []
        match = 0

        # deserialize data into PaddleCheckoutLoadedEvent
        try:
            instance.actual_instance = PaddleCheckoutLoadedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaddleCheckoutClosedEvent
        try:
            instance.actual_instance = PaddleCheckoutClosedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaddleCheckoutUpdatedEvent
        try:
            instance.actual_instance = PaddleCheckoutUpdatedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaddleCheckoutCompletedEvent
        try:
            instance.actual_instance = PaddleCheckoutCompletedEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaddleCheckoutWarningEvent
        try:
            instance.actual_instance = PaddleCheckoutWarningEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaddleCheckoutErrorEvent
        try:
            instance.actual_instance = PaddleCheckoutErrorEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PaddleCheckoutEvent with oneOf schemas: PaddleCheckoutClosedEvent, PaddleCheckoutCompletedEvent, PaddleCheckoutErrorEvent, PaddleCheckoutLoadedEvent, PaddleCheckoutUpdatedEvent, PaddleCheckoutWarningEvent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PaddleCheckoutEvent with oneOf schemas: PaddleCheckoutClosedEvent, PaddleCheckoutCompletedEvent, PaddleCheckoutErrorEvent, PaddleCheckoutLoadedEvent, PaddleCheckoutUpdatedEvent, PaddleCheckoutWarningEvent. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


