# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp
from pieces._vendor.pieces_os_client.models.referenced_model import ReferencedModel

class PersonModel(BaseModel):
    """
    This is a PersonSpecific Model. and will let us know for all the assets that get attached to the person if, this person was attached via a model or just attached automatically.  explanation here are the reason why a Person was attached to an asset.  # noqa: E501
    """
    asset: Optional[ReferencedAsset] = None
    model: Optional[ReferencedModel] = None
    deleted: Optional[GroupedTimestamp] = None
    explanation: Optional[ReferencedAnnotation] = None
    __properties = ["asset", "model", "deleted", "explanation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PersonModel:
        """Create an instance of PersonModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of model
        if self.model:
            _dict['model'] = self.model.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of deleted
        if self.deleted:
            _dict['deleted'] = self.deleted.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of explanation
        if self.explanation:
            _dict['explanation'] = self.explanation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PersonModel:
        """Create an instance of PersonModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PersonModel.parse_obj(obj)

        _obj = PersonModel.parse_obj({
            "asset": ReferencedAsset.from_dict(obj.get("asset")) if obj.get("asset") is not None else None,
            "model": ReferencedModel.from_dict(obj.get("model")) if obj.get("model") is not None else None,
            "deleted": GroupedTimestamp.from_dict(obj.get("deleted")) if obj.get("deleted") is not None else None,
            "explanation": ReferencedAnnotation.from_dict(obj.get("explanation")) if obj.get("explanation") is not None else None
        })
        return _obj

from pieces._vendor.pieces_os_client.models.referenced_annotation import ReferencedAnnotation
from pieces._vendor.pieces_os_client.models.referenced_asset import ReferencedAsset
PersonModel.update_forward_refs()

