# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.filter_operation_type_enum import FilterOperationTypeEnum

class SearchEngines(BaseModel):
    """
    This is a model for plural Engine. This means that you can run multiple searches, this follow similar behavior to the Asset Filtering.where you can create you own complex operations: IE search a query in FTS, and filter all that have the create from here to here.  note: each Engine will only represent 1 search operation, however you many pass in operations to create further nesting. IE  Engine: [FTS + w/ operations: [created filter, updated filer, ncs Search] w/ a type of OR:::: This can be as nested as you want however will just increase the time till it returns results.]  note: type: default behavior for the type is an AND operation.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    iterable: conlist(SearchEngine) = Field(...)
    type: Optional[FilterOperationTypeEnum] = None
    __properties = ["schema", "iterable", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchEngines:
        """Create an instance of SearchEngines from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in iterable (list)
        _items = []
        if self.iterable:
            for _item in self.iterable:
                if _item:
                    _items.append(_item.to_dict())
            _dict['iterable'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchEngines:
        """Create an instance of SearchEngines from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchEngines.parse_obj(obj)

        _obj = SearchEngines.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "iterable": [SearchEngine.from_dict(_item) for _item in obj.get("iterable")] if obj.get("iterable") is not None else None,
            "type": obj.get("type")
        })
        return _obj

from pieces._vendor.pieces_os_client.models.search_engine import SearchEngine
SearchEngines.update_forward_refs()

