# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.seed_type_enum import SeedTypeEnum
from pieces._vendor.pieces_os_client.models.seeded_anchor import SeededAnchor
from pieces._vendor.pieces_os_client.models.seeded_asset import SeededAsset
from pieces._vendor.pieces_os_client.models.seeded_person import SeededPerson
from pieces._vendor.pieces_os_client.models.seeded_website import SeededWebsite

class Seed(BaseModel):
    """
    A seed Model used to wrap a format or asset  Note: we will expand this now to support additional paramerters.  Note: however if create an asset, only pass in the asset, not passing in an asset in this case will cause the endpoint to fail.  TODO: for a breaking change update the type enum here to add support for the additional materials or remove it entirely.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    asset: Optional[SeededAsset] = None
    person: Optional[SeededPerson] = None
    anchor: Optional[SeededAnchor] = None
    website: Optional[SeededWebsite] = None
    type: Optional[SeedTypeEnum] = None
    __properties = ["schema", "asset", "person", "anchor", "website", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Seed:
        """Create an instance of Seed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of person
        if self.person:
            _dict['person'] = self.person.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of anchor
        if self.anchor:
            _dict['anchor'] = self.anchor.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of website
        if self.website:
            _dict['website'] = self.website.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Seed:
        """Create an instance of Seed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Seed.parse_obj(obj)

        _obj = Seed.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "asset": SeededAsset.from_dict(obj.get("asset")) if obj.get("asset") is not None else None,
            "person": SeededPerson.from_dict(obj.get("person")) if obj.get("person") is not None else None,
            "anchor": SeededAnchor.from_dict(obj.get("anchor")) if obj.get("anchor") is not None else None,
            "website": SeededWebsite.from_dict(obj.get("website")) if obj.get("website") is not None else None,
            "type": obj.get("type")
        })
        return _obj


