# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, conlist
from pieces._vendor.pieces_os_client.models.anchor_type_enum import AnchorTypeEnum
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.platform_enum import PlatformEnum

class SeededAnchor(BaseModel):
    """
    SeededAnchor
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    type: AnchorTypeEnum = Field(...)
    watch: Optional[StrictBool] = None
    fullpath: StrictStr = Field(...)
    asset: Optional[StrictStr] = Field(default=None, description="You may associate a SeededAnchor with an asset")
    platform: Optional[PlatformEnum] = None
    name: Optional[StrictStr] = None
    annotations: Optional[conlist(SeededAnnotation)] = None
    conversation: Optional[StrictStr] = None
    persons: Optional[FlattenedPersons] = None
    __properties = ["schema", "type", "watch", "fullpath", "asset", "platform", "name", "annotations", "conversation", "persons"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeededAnchor:
        """Create an instance of SeededAnchor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in annotations (list)
        _items = []
        if self.annotations:
            for _item in self.annotations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['annotations'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of persons
        if self.persons:
            _dict['persons'] = self.persons.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeededAnchor:
        """Create an instance of SeededAnchor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeededAnchor.parse_obj(obj)

        _obj = SeededAnchor.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "type": obj.get("type"),
            "watch": obj.get("watch"),
            "fullpath": obj.get("fullpath"),
            "asset": obj.get("asset"),
            "platform": obj.get("platform"),
            "name": obj.get("name"),
            "annotations": [SeededAnnotation.from_dict(_item) for _item in obj.get("annotations")] if obj.get("annotations") is not None else None,
            "conversation": obj.get("conversation"),
            "persons": FlattenedPersons.from_dict(obj.get("persons")) if obj.get("persons") is not None else None
        })
        return _obj

from pieces._vendor.pieces_os_client.models.flattened_persons import FlattenedPersons
from pieces._vendor.pieces_os_client.models.seeded_annotation import SeededAnnotation
SeededAnchor.update_forward_refs()

