# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.workstream_pattern_engine_source import WorkstreamPatternEngineSource
from pieces._vendor.pieces_os_client.models.workstream_pattern_engine_source_supported_accessibility import WorkstreamPatternEngineSourceSupportedAccessibility

class SeededWorkstreamPatternEngineSource(BaseModel):
    """
    TODO  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    raw: WorkstreamPatternEngineSource = Field(...)
    filter: Optional[StrictBool] = Field(default=None, description="This will determine if we want to filter this specific source")
    readable: StrictStr = Field(default=..., description="This is the name of the source(defualt original data) this is NOT used for matching just for readability")
    accessibility: Optional[WorkstreamPatternEngineSourceSupportedAccessibility] = None
    __properties = ["schema", "raw", "filter", "readable", "accessibility"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeededWorkstreamPatternEngineSource:
        """Create an instance of SeededWorkstreamPatternEngineSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of raw
        if self.raw:
            _dict['raw'] = self.raw.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of accessibility
        if self.accessibility:
            _dict['accessibility'] = self.accessibility.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeededWorkstreamPatternEngineSource:
        """Create an instance of SeededWorkstreamPatternEngineSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeededWorkstreamPatternEngineSource.parse_obj(obj)

        _obj = SeededWorkstreamPatternEngineSource.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "raw": WorkstreamPatternEngineSource.from_dict(obj.get("raw")) if obj.get("raw") is not None else None,
            "filter": obj.get("filter"),
            "readable": obj.get("readable"),
            "accessibility": WorkstreamPatternEngineSourceSupportedAccessibility.from_dict(obj.get("accessibility")) if obj.get("accessibility") is not None else None
        })
        return _obj


