# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt
from pieces._vendor.pieces_os_client.models.workstream_pattern_engine_status import WorkstreamPatternEngineStatus

class TrackedSummaryTotals(BaseModel):
    """
    This is the counts of things that users can add.  # noqa: E501
    """
    assets: StrictInt = Field(...)
    tags: StrictInt = Field(...)
    websites: StrictInt = Field(...)
    persons: StrictInt = Field(...)
    sensitives: StrictInt = Field(...)
    shares: StrictInt = Field(...)
    copilot_sends: StrictInt = Field(...)
    copilot_receives: StrictInt = Field(...)
    copilot_sessions: StrictInt = Field(...)
    copilot_conversations: StrictInt = Field(...)
    productivity_score: StrictInt = Field(...)
    searches: StrictInt = Field(...)
    references: StrictInt = Field(...)
    reuses: StrictInt = Field(...)
    anchor_files: StrictInt = Field(...)
    anchor_folders: StrictInt = Field(...)
    isr_reports: StrictInt = Field(...)
    requests: Optional[StrictInt] = None
    workstream_events: Optional[StrictInt] = None
    workstream_summaries: Optional[StrictInt] = None
    workstream_pattern_engine_sources: Optional[StrictInt] = None
    workstream_pattern_engine_status: Optional[WorkstreamPatternEngineStatus] = None
    __properties = ["assets", "tags", "websites", "persons", "sensitives", "shares", "copilot_sends", "copilot_receives", "copilot_sessions", "copilot_conversations", "productivity_score", "searches", "references", "reuses", "anchor_files", "anchor_folders", "isr_reports", "requests", "workstream_events", "workstream_summaries", "workstream_pattern_engine_sources", "workstream_pattern_engine_status"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TrackedSummaryTotals:
        """Create an instance of TrackedSummaryTotals from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of workstream_pattern_engine_status
        if self.workstream_pattern_engine_status:
            _dict['workstream_pattern_engine_status'] = self.workstream_pattern_engine_status.to_dict()
        # set to None if requests (nullable) is None
        # and __fields_set__ contains the field
        if self.requests is None and "requests" in self.__fields_set__:
            _dict['requests'] = None

        # set to None if workstream_events (nullable) is None
        # and __fields_set__ contains the field
        if self.workstream_events is None and "workstream_events" in self.__fields_set__:
            _dict['workstream_events'] = None

        # set to None if workstream_summaries (nullable) is None
        # and __fields_set__ contains the field
        if self.workstream_summaries is None and "workstream_summaries" in self.__fields_set__:
            _dict['workstream_summaries'] = None

        # set to None if workstream_pattern_engine_sources (nullable) is None
        # and __fields_set__ contains the field
        if self.workstream_pattern_engine_sources is None and "workstream_pattern_engine_sources" in self.__fields_set__:
            _dict['workstream_pattern_engine_sources'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TrackedSummaryTotals:
        """Create an instance of TrackedSummaryTotals from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TrackedSummaryTotals.parse_obj(obj)

        _obj = TrackedSummaryTotals.parse_obj({
            "assets": obj.get("assets"),
            "tags": obj.get("tags"),
            "websites": obj.get("websites"),
            "persons": obj.get("persons"),
            "sensitives": obj.get("sensitives"),
            "shares": obj.get("shares"),
            "copilot_sends": obj.get("copilot_sends"),
            "copilot_receives": obj.get("copilot_receives"),
            "copilot_sessions": obj.get("copilot_sessions"),
            "copilot_conversations": obj.get("copilot_conversations"),
            "productivity_score": obj.get("productivity_score"),
            "searches": obj.get("searches"),
            "references": obj.get("references"),
            "reuses": obj.get("reuses"),
            "anchor_files": obj.get("anchor_files"),
            "anchor_folders": obj.get("anchor_folders"),
            "isr_reports": obj.get("isr_reports"),
            "requests": obj.get("requests"),
            "workstream_events": obj.get("workstream_events"),
            "workstream_summaries": obj.get("workstream_summaries"),
            "workstream_pattern_engine_sources": obj.get("workstream_pattern_engine_sources"),
            "workstream_pattern_engine_status": WorkstreamPatternEngineStatus.from_dict(obj.get("workstream_pattern_engine_status")) if obj.get("workstream_pattern_engine_status") is not None else None
        })
        return _obj


