# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class WorkstreamEventTrigger(BaseModel):
    """
    This is the specific event that represent the Shadow Activity ie the copy/paste ...xyz  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    check_in: Optional[StrictBool] = Field(default=None, description="this is a sort of check-in event(ie when ever your application is in the forground on there is an interaction)")
    copy_field: Optional[StrictBool] = Field(default=None, alias="copy")
    paste: Optional[StrictBool] = None
    file_open: Optional[StrictBool] = None
    file_close: Optional[StrictBool] = None
    tab_switch: Optional[StrictBool] = None
    tab_close: Optional[StrictBool] = None
    tab_open: Optional[StrictBool] = None
    tab_enter: Optional[StrictBool] = None
    tab_leave: Optional[StrictBool] = None
    url_changed: Optional[StrictBool] = None
    application_enter: Optional[StrictBool] = None
    application_leave: Optional[StrictBool] = None
    application_switch: Optional[StrictBool] = None
    native_screenshot: Optional[StrictBool] = None
    __properties = ["schema", "check_in", "copy", "paste", "file_open", "file_close", "tab_switch", "tab_close", "tab_open", "tab_enter", "tab_leave", "url_changed", "application_enter", "application_leave", "application_switch", "native_screenshot"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkstreamEventTrigger:
        """Create an instance of WorkstreamEventTrigger from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkstreamEventTrigger:
        """Create an instance of WorkstreamEventTrigger from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkstreamEventTrigger.parse_obj(obj)

        _obj = WorkstreamEventTrigger.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "check_in": obj.get("check_in"),
            "copy": obj.get("copy"),
            "paste": obj.get("paste"),
            "file_open": obj.get("file_open"),
            "file_close": obj.get("file_close"),
            "tab_switch": obj.get("tab_switch"),
            "tab_close": obj.get("tab_close"),
            "tab_open": obj.get("tab_open"),
            "tab_enter": obj.get("tab_enter"),
            "tab_leave": obj.get("tab_leave"),
            "url_changed": obj.get("url_changed"),
            "application_enter": obj.get("application_enter"),
            "application_leave": obj.get("application_leave"),
            "application_switch": obj.get("application_switch"),
            "native_screenshot": obj.get("native_screenshot")
        })
        return _obj


