# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.workstream_suggestion_type import WorkstreamSuggestionType

class WorkstreamSuggestions(BaseModel):
    """
    This is a list of the materials used in the workstream suggestions.  The feed will return a list of individual material that will be required to be fetched and re-referenced.(the materials that is.)  Considering if we want to have all the materaials just being referenced( ie ReferencedWebsite/ReferencedWorkstreamSummary/...xyz) && rebuilt  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    iterable: conlist(WorkstreamSuggestion) = Field(...)
    types: Optional[conlist(WorkstreamSuggestionType)] = Field(default=None, description="This is iterable <WorkstreamSuggestionType>[] that gives the type of each of the items in the iterable. I.E. types[0] is the suggestion type of the item at iterable[0].")
    __properties = ["schema", "iterable", "types"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkstreamSuggestions:
        """Create an instance of WorkstreamSuggestions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in iterable (list)
        _items = []
        if self.iterable:
            for _item in self.iterable:
                if _item:
                    _items.append(_item.to_dict())
            _dict['iterable'] = _items
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in types (list)
        _items = []
        if self.types:
            for _item in self.types:
                if _item:
                    _items.append(_item.to_dict())
            _dict['types'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkstreamSuggestions:
        """Create an instance of WorkstreamSuggestions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkstreamSuggestions.parse_obj(obj)

        _obj = WorkstreamSuggestions.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "iterable": [WorkstreamSuggestion.from_dict(_item) for _item in obj.get("iterable")] if obj.get("iterable") is not None else None,
            "types": [WorkstreamSuggestionType.from_dict(_item) for _item in obj.get("types")] if obj.get("types") is not None else None
        })
        return _obj

from pieces._vendor.pieces_os_client.models.workstream_suggestion import WorkstreamSuggestion
WorkstreamSuggestions.update_forward_refs()

