# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, constr
from luminesce.models.aggregate_function import AggregateFunction

class Aggregation(BaseModel):
    """
    How to aggregate over a field  # noqa: E501
    """
    type: AggregateFunction = Field(...)
    alias: Optional[constr(strict=True, max_length=256, min_length=0)] = Field(None, description="Alias, if any, for the Aggregate expression when selected")
    __properties = ["type", "alias"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Aggregation:
        """Create an instance of Aggregation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if alias (nullable) is None
        # and __fields_set__ contains the field
        if self.alias is None and "alias" in self.__fields_set__:
            _dict['alias'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Aggregation:
        """Create an instance of Aggregation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Aggregation.parse_obj(obj)

        _obj = Aggregation.parse_obj({
            "type": obj.get("type"),
            "alias": obj.get("alias")
        })
        return _obj
