# commander
Client application to send commands to Spacebee apps.

## Telecommands
In the 'Telecommands' folder, when adding a new telecommand, make sure to define these attributes in its constructor:

        *   name[string] Name of the telecommand
        *   help[string] Description and usage for the telecommand
        *   help_input[string] Description for the input arguments
        *   operation[16 bits] Unique identifier for a given telemetry or telecommand
        *   area_version[16 bits] Protocol version
        *   num_inputs[int] Number of input arguments for this command

And define the following functions:

*   ```
    def loadInputArguments(self,arg):
        "Load input arguments into the body formatted in bytes and calculate the body length."
    arg is a string.
    Raise ValueError to prevent invalid inputs.
    Need to define:
    1.  body_length
    2.  body
*   ```
    def parseOutputArguments(self,response):
    "Parse the output argument, where the response is a byte sequence, and return a dictionary."
    return dictionary
    ```

# License
This software, including all prior releases, is licensed under the [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)](https://creativecommons.org/licenses/by-nc-sa/4.0/). You are free to:
- Share: Copy and redistribute the material in any medium or format.
- Adapt: Remix, transform, and build upon the material.

Under the following terms:
- Attribution: You must give appropriate credit to the original authors, provide a link to the license, and indicate if changes were made.
- NonCommercial: You may not use the material for commercial purposes.
- ShareAlike: If you remix, transform, or build upon the material, you must distribute your contributions under the same license.
- No additional restrictions: You may not apply legal terms or technological measures that restrict others from doing anything the license permits.

See the [LICENSE](./LICENSE) file for the full license text.

**Note**: Any releases or commits made prior to the inclusion of the `LICENSE` file are also governed by CC BY-NC-SA 4.0. Please do not use unlicensed versions of this software.

# Contributions
This project is maintained by a small team and does not accept external contributions at this time. Issues and pull requests have been disabled to reflect this policy.

# Future Licensing
The maintainers reserve the right to relicense future versions of this software under different terms (e.g., a permissive open-source license like MIT). All existing versions and releases remain under CC BY-NC-SA 4.0 unless otherwise stated.
