//protoc --go_out jina-go-proto --go_opt=paths=source_relative --go_opt=Mjina.proto=jina-go-proto=jraft/jina-go-proto --go-grpc_out jina-go-proto --go-grpc_opt=paths=source_relative --experimental_allow_proto3_optional jina.proto

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v4.23.4
// source: jina.proto

package jina_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	docarray_go_proto "jraft/docarray-go-proto"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StatusProto_StatusCode int32

const (
	StatusProto_SUCCESS StatusProto_StatusCode = 0 // success
	StatusProto_ERROR   StatusProto_StatusCode = 1 // error
)

// Enum value maps for StatusProto_StatusCode.
var (
	StatusProto_StatusCode_name = map[int32]string{
		0: "SUCCESS",
		1: "ERROR",
	}
	StatusProto_StatusCode_value = map[string]int32{
		"SUCCESS": 0,
		"ERROR":   1,
	}
)

func (x StatusProto_StatusCode) Enum() *StatusProto_StatusCode {
	p := new(StatusProto_StatusCode)
	*p = x
	return p
}

func (x StatusProto_StatusCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatusProto_StatusCode) Descriptor() protoreflect.EnumDescriptor {
	return file_jina_proto_enumTypes[0].Descriptor()
}

func (StatusProto_StatusCode) Type() protoreflect.EnumType {
	return &file_jina_proto_enumTypes[0]
}

func (x StatusProto_StatusCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatusProto_StatusCode.Descriptor instead.
func (StatusProto_StatusCode) EnumDescriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{4, 0}
}

type SnapshotStatusProto_Status int32

const (
	SnapshotStatusProto_STATE_UNSPECIFIED SnapshotStatusProto_Status = 0
	SnapshotStatusProto_QUEUED            SnapshotStatusProto_Status = 1 // Snapshot Job is admitted (validated and persisted) and waiting for resources.
	SnapshotStatusProto_SCHEDULED         SnapshotStatusProto_Status = 2 // Snapshot Job is scheduled to run as soon as resource allocation is ready.
	SnapshotStatusProto_RUNNING           SnapshotStatusProto_Status = 3 // Resource allocation has been successful. Snapshot Job is RUNNING.
	SnapshotStatusProto_SUCCEEDED         SnapshotStatusProto_Status = 4 // Snapshot Job has finished successfully.
	SnapshotStatusProto_FAILED            SnapshotStatusProto_Status = 5 // Snapshot Job has failed.
	SnapshotStatusProto_NOT_FOUND         SnapshotStatusProto_Status = 6 // If the specific snapshot id is unknown or not found
)

// Enum value maps for SnapshotStatusProto_Status.
var (
	SnapshotStatusProto_Status_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "QUEUED",
		2: "SCHEDULED",
		3: "RUNNING",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "NOT_FOUND",
	}
	SnapshotStatusProto_Status_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"QUEUED":            1,
		"SCHEDULED":         2,
		"RUNNING":           3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"NOT_FOUND":         6,
	}
)

func (x SnapshotStatusProto_Status) Enum() *SnapshotStatusProto_Status {
	p := new(SnapshotStatusProto_Status)
	*p = x
	return p
}

func (x SnapshotStatusProto_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SnapshotStatusProto_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_jina_proto_enumTypes[1].Descriptor()
}

func (SnapshotStatusProto_Status) Type() protoreflect.EnumType {
	return &file_jina_proto_enumTypes[1]
}

func (x SnapshotStatusProto_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SnapshotStatusProto_Status.Descriptor instead.
func (SnapshotStatusProto_Status) EnumDescriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{12, 0}
}

type RestoreSnapshotStatusProto_Status int32

const (
	RestoreSnapshotStatusProto_STATE_UNSPECIFIED RestoreSnapshotStatusProto_Status = 0
	RestoreSnapshotStatusProto_RUNNING           RestoreSnapshotStatusProto_Status = 1 // Resource allocation has been successful. Restore Job is RUNNING.
	RestoreSnapshotStatusProto_SUCCEEDED         RestoreSnapshotStatusProto_Status = 2 // Resource Job has finished successfully.
	RestoreSnapshotStatusProto_FAILED            RestoreSnapshotStatusProto_Status = 3 // Resource Job has failed.
	RestoreSnapshotStatusProto_NOT_FOUND         RestoreSnapshotStatusProto_Status = 6 // If the specific restore id is unknown or not found
)

// Enum value maps for RestoreSnapshotStatusProto_Status.
var (
	RestoreSnapshotStatusProto_Status_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "FAILED",
		6: "NOT_FOUND",
	}
	RestoreSnapshotStatusProto_Status_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
		"NOT_FOUND":         6,
	}
)

func (x RestoreSnapshotStatusProto_Status) Enum() *RestoreSnapshotStatusProto_Status {
	p := new(RestoreSnapshotStatusProto_Status)
	*p = x
	return p
}

func (x RestoreSnapshotStatusProto_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreSnapshotStatusProto_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_jina_proto_enumTypes[2].Descriptor()
}

func (RestoreSnapshotStatusProto_Status) Type() protoreflect.EnumType {
	return &file_jina_proto_enumTypes[2]
}

func (x RestoreSnapshotStatusProto_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreSnapshotStatusProto_Status.Descriptor instead.
func (RestoreSnapshotStatusProto_Status) EnumDescriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{13, 0}
}

// *
// Represents a the route paths of this message as perceived by the Gateway
// start_time is set when the Gateway sends a message to a Pod
// end_time is set when the Gateway receives a message from a Pod
// thus end_time - start_time includes Executor computation, runtime overhead, serialization and network
type RouteProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Executor  string                 `protobuf:"bytes,1,opt,name=executor,proto3" json:"executor,omitempty"`                    // the name of the BasePod
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"` // time when the Gateway starts sending to the Pod
	EndTime   *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`       // time when the Gateway received it from the Pod
	Status    *StatusProto           `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`                        // the status of the execution
}

func (x *RouteProto) Reset() {
	*x = RouteProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteProto) ProtoMessage() {}

func (x *RouteProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteProto.ProtoReflect.Descriptor instead.
func (*RouteProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{0}
}

func (x *RouteProto) GetExecutor() string {
	if x != nil {
		return x.Executor
	}
	return ""
}

func (x *RouteProto) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *RouteProto) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *RouteProto) GetStatus() *StatusProto {
	if x != nil {
		return x.Status
	}
	return nil
}

type JinaInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Jina map[string]string `protobuf:"bytes,1,rep,name=jina,proto3" json:"jina,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // information about the system running and package version information including jina
	Envs map[string]string `protobuf:"bytes,2,rep,name=envs,proto3" json:"envs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // the environment variable setting
}

func (x *JinaInfoProto) Reset() {
	*x = JinaInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JinaInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JinaInfoProto) ProtoMessage() {}

func (x *JinaInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JinaInfoProto.ProtoReflect.Descriptor instead.
func (*JinaInfoProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{1}
}

func (x *JinaInfoProto) GetJina() map[string]string {
	if x != nil {
		return x.Jina
	}
	return nil
}

func (x *JinaInfoProto) GetEnvs() map[string]string {
	if x != nil {
		return x.Envs
	}
	return nil
}

// *
// Represents a Header.
// - The header's content will be defined by the user request.
// - It will be copied to the envelope.header
// - In-flow operations will modify the envelope.header
// - While returning, copy envelope.header back to request.header
type HeaderProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RequestId      string       `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`                      // the unique ID of this request. Multiple requests with the same ID will be gathered
	Status         *StatusProto `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`                                             // status info
	ExecEndpoint   *string      `protobuf:"bytes,3,opt,name=exec_endpoint,json=execEndpoint,proto3,oneof" json:"exec_endpoint,omitempty"`       // the endpoint specified by `@requests(on='/abc')`
	TargetExecutor *string      `protobuf:"bytes,4,opt,name=target_executor,json=targetExecutor,proto3,oneof" json:"target_executor,omitempty"` // if set, the request is targeted to certain executor, regex strings
	Timeout        *uint32      `protobuf:"varint,5,opt,name=timeout,proto3,oneof" json:"timeout,omitempty"`                                    // epoch time in seconds after which the request should be dropped
}

func (x *HeaderProto) Reset() {
	*x = HeaderProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderProto) ProtoMessage() {}

func (x *HeaderProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderProto.ProtoReflect.Descriptor instead.
func (*HeaderProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{2}
}

func (x *HeaderProto) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *HeaderProto) GetStatus() *StatusProto {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *HeaderProto) GetExecEndpoint() string {
	if x != nil && x.ExecEndpoint != nil {
		return *x.ExecEndpoint
	}
	return ""
}

func (x *HeaderProto) GetTargetExecutor() string {
	if x != nil && x.TargetExecutor != nil {
		return *x.TargetExecutor
	}
	return ""
}

func (x *HeaderProto) GetTimeout() uint32 {
	if x != nil && x.Timeout != nil {
		return *x.Timeout
	}
	return 0
}

// *
// Represents the set of Endpoints exposed by an Executor
type EndpointsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// list of endpoints exposed by an Executor
	Endpoints      []string `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	WriteEndpoints []string `protobuf:"bytes,2,rep,name=write_endpoints,json=writeEndpoints,proto3" json:"write_endpoints,omitempty"`
	// Dictionary containing input and output schema per endpoint
	Schemas *structpb.Struct `protobuf:"bytes,3,opt,name=schemas,proto3" json:"schemas,omitempty"` // extra kwargs that will be used in executor
}

func (x *EndpointsProto) Reset() {
	*x = EndpointsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndpointsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointsProto) ProtoMessage() {}

func (x *EndpointsProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointsProto.ProtoReflect.Descriptor instead.
func (*EndpointsProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{3}
}

func (x *EndpointsProto) GetEndpoints() []string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *EndpointsProto) GetWriteEndpoints() []string {
	if x != nil {
		return x.WriteEndpoints
	}
	return nil
}

func (x *EndpointsProto) GetSchemas() *structpb.Struct {
	if x != nil {
		return x.Schemas
	}
	return nil
}

// *
// Represents a Status
type StatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// status code
	Code StatusProto_StatusCode `protobuf:"varint,1,opt,name=code,proto3,enum=jina.StatusProto_StatusCode" json:"code,omitempty"`
	// error description of the very first exception
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// the details of the error
	Exception *StatusProto_ExceptionProto `protobuf:"bytes,3,opt,name=exception,proto3" json:"exception,omitempty"`
}

func (x *StatusProto) Reset() {
	*x = StatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusProto) ProtoMessage() {}

func (x *StatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusProto.ProtoReflect.Descriptor instead.
func (*StatusProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{4}
}

func (x *StatusProto) GetCode() StatusProto_StatusCode {
	if x != nil {
		return x.Code
	}
	return StatusProto_SUCCESS
}

func (x *StatusProto) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *StatusProto) GetException() *StatusProto_ExceptionProto {
	if x != nil {
		return x.Exception
	}
	return nil
}

// *
// Represents an entity (like an ExecutorRuntime)
type RelatedEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id      string  `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`                                 // unique id of the entity, like the name of a pod
	Address string  `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`                       // address of the entity, could be an IP address, domain name etc, does not include port
	Port    uint32  `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`                            // port this entity is listening on
	ShardId *uint32 `protobuf:"varint,4,opt,name=shard_id,json=shardId,proto3,oneof" json:"shard_id,omitempty"` // the id of the shard it belongs to, if it is a shard
}

func (x *RelatedEntity) Reset() {
	*x = RelatedEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedEntity) ProtoMessage() {}

func (x *RelatedEntity) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedEntity.ProtoReflect.Descriptor instead.
func (*RelatedEntity) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{5}
}

func (x *RelatedEntity) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *RelatedEntity) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *RelatedEntity) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *RelatedEntity) GetShardId() uint32 {
	if x != nil && x.ShardId != nil {
		return *x.ShardId
	}
	return 0
}

// *
// Represents a DataRequest
type DataRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *HeaderProto                       `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`         // header contains meta info defined by the user
	Parameters *structpb.Struct                   `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"` // extra kwargs that will be used in executor
	Routes     []*RouteProto                      `protobuf:"bytes,3,rep,name=routes,proto3" json:"routes,omitempty"`         // status info on every routes
	Data       *DataRequestProto_DataContentProto `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`             // container for docs and groundtruths
}

func (x *DataRequestProto) Reset() {
	*x = DataRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRequestProto) ProtoMessage() {}

func (x *DataRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRequestProto.ProtoReflect.Descriptor instead.
func (*DataRequestProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{6}
}

func (x *DataRequestProto) GetHeader() *HeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DataRequestProto) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *DataRequestProto) GetRoutes() []*RouteProto {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *DataRequestProto) GetData() *DataRequestProto_DataContentProto {
	if x != nil {
		return x.Data
	}
	return nil
}

// *
// Represents a Single Document DataRequest
type SingleDocumentRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *HeaderProto                `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`         // header contains meta info defined by the user
	Parameters *structpb.Struct            `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"` // extra kwargs that will be used in executor
	Routes     []*RouteProto               `protobuf:"bytes,3,rep,name=routes,proto3" json:"routes,omitempty"`         // status info on every routes
	Document   *docarray_go_proto.DocProto `protobuf:"bytes,4,opt,name=document,proto3" json:"document,omitempty"`     // the document in this request
}

func (x *SingleDocumentRequestProto) Reset() {
	*x = SingleDocumentRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SingleDocumentRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleDocumentRequestProto) ProtoMessage() {}

func (x *SingleDocumentRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleDocumentRequestProto.ProtoReflect.Descriptor instead.
func (*SingleDocumentRequestProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{7}
}

func (x *SingleDocumentRequestProto) GetHeader() *HeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SingleDocumentRequestProto) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *SingleDocumentRequestProto) GetRoutes() []*RouteProto {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *SingleDocumentRequestProto) GetDocument() *docarray_go_proto.DocProto {
	if x != nil {
		return x.Document
	}
	return nil
}

type DataRequestProtoWoData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *HeaderProto     `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`         // header contains meta info defined by the user
	Parameters *structpb.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"` // extra kwargs that will be used in executor
	Routes     []*RouteProto    `protobuf:"bytes,3,rep,name=routes,proto3" json:"routes,omitempty"`         // status info on every routes
}

func (x *DataRequestProtoWoData) Reset() {
	*x = DataRequestProtoWoData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRequestProtoWoData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRequestProtoWoData) ProtoMessage() {}

func (x *DataRequestProtoWoData) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRequestProtoWoData.ProtoReflect.Descriptor instead.
func (*DataRequestProtoWoData) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{8}
}

func (x *DataRequestProtoWoData) GetHeader() *HeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DataRequestProtoWoData) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *DataRequestProtoWoData) GetRoutes() []*RouteProto {
	if x != nil {
		return x.Routes
	}
	return nil
}

// *
// Represents a list of data requests
// This should be replaced by streaming
type DataRequestListProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Requests []*DataRequestProto `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"` // requests in this list
}

func (x *DataRequestListProto) Reset() {
	*x = DataRequestListProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRequestListProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRequestListProto) ProtoMessage() {}

func (x *DataRequestListProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRequestListProto.ProtoReflect.Descriptor instead.
func (*DataRequestListProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{9}
}

func (x *DataRequestListProto) GetRequests() []*DataRequestProto {
	if x != nil {
		return x.Requests
	}
	return nil
}

// *
// An ID representation for the Snapshot Job
type SnapshotId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *SnapshotId) Reset() {
	*x = SnapshotId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotId) ProtoMessage() {}

func (x *SnapshotId) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotId.ProtoReflect.Descriptor instead.
func (*SnapshotId) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{10}
}

func (x *SnapshotId) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// *
// An ID representation for the Restore Job
type RestoreId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *RestoreId) Reset() {
	*x = RestoreId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreId) ProtoMessage() {}

func (x *RestoreId) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreId.ProtoReflect.Descriptor instead.
func (*RestoreId) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{11}
}

func (x *RestoreId) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// *
// Represents the status of a Snapshot.
type SnapshotStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *SnapshotId `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // An ID for the Snapshot Job.
	// status code
	Status SnapshotStatusProto_Status `protobuf:"varint,2,opt,name=status,proto3,enum=jina.SnapshotStatusProto_Status" json:"status,omitempty"`
	// snapshot file
	SnapshotFile string `protobuf:"bytes,3,opt,name=snapshot_file,json=snapshotFile,proto3" json:"snapshot_file,omitempty"`
}

func (x *SnapshotStatusProto) Reset() {
	*x = SnapshotStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotStatusProto) ProtoMessage() {}

func (x *SnapshotStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotStatusProto.ProtoReflect.Descriptor instead.
func (*SnapshotStatusProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{12}
}

func (x *SnapshotStatusProto) GetId() *SnapshotId {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *SnapshotStatusProto) GetStatus() SnapshotStatusProto_Status {
	if x != nil {
		return x.Status
	}
	return SnapshotStatusProto_STATE_UNSPECIFIED
}

func (x *SnapshotStatusProto) GetSnapshotFile() string {
	if x != nil {
		return x.SnapshotFile
	}
	return ""
}

// *
// Represents the status of a Restore.
type RestoreSnapshotStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *RestoreId `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // An ID for the Restore Job.
	// status code
	Status RestoreSnapshotStatusProto_Status `protobuf:"varint,2,opt,name=status,proto3,enum=jina.RestoreSnapshotStatusProto_Status" json:"status,omitempty"`
}

func (x *RestoreSnapshotStatusProto) Reset() {
	*x = RestoreSnapshotStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreSnapshotStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreSnapshotStatusProto) ProtoMessage() {}

func (x *RestoreSnapshotStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreSnapshotStatusProto.ProtoReflect.Descriptor instead.
func (*RestoreSnapshotStatusProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{13}
}

func (x *RestoreSnapshotStatusProto) GetId() *RestoreId {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *RestoreSnapshotStatusProto) GetStatus() RestoreSnapshotStatusProto_Status {
	if x != nil {
		return x.Status
	}
	return RestoreSnapshotStatusProto_STATE_UNSPECIFIED
}

// *
// Commands to restore an Executor from a snapshot file
type RestoreSnapshotCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// snapshot file
	SnapshotFile string `protobuf:"bytes,1,opt,name=snapshot_file,json=snapshotFile,proto3" json:"snapshot_file,omitempty"`
}

func (x *RestoreSnapshotCommand) Reset() {
	*x = RestoreSnapshotCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreSnapshotCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreSnapshotCommand) ProtoMessage() {}

func (x *RestoreSnapshotCommand) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreSnapshotCommand.ProtoReflect.Descriptor instead.
func (*RestoreSnapshotCommand) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{14}
}

func (x *RestoreSnapshotCommand) GetSnapshotFile() string {
	if x != nil {
		return x.SnapshotFile
	}
	return ""
}

type StatusProto_ExceptionProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the class name of the exception
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// the list of arguments given to the exception constructor.
	Args []string `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	// the exception traceback stacks
	Stacks []string `protobuf:"bytes,3,rep,name=stacks,proto3" json:"stacks,omitempty"`
	// the name of the executor bind to that Executor (if applicable)
	Executor string `protobuf:"bytes,4,opt,name=executor,proto3" json:"executor,omitempty"`
}

func (x *StatusProto_ExceptionProto) Reset() {
	*x = StatusProto_ExceptionProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusProto_ExceptionProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusProto_ExceptionProto) ProtoMessage() {}

func (x *StatusProto_ExceptionProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusProto_ExceptionProto.ProtoReflect.Descriptor instead.
func (*StatusProto_ExceptionProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{4, 0}
}

func (x *StatusProto_ExceptionProto) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StatusProto_ExceptionProto) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *StatusProto_ExceptionProto) GetStacks() []string {
	if x != nil {
		return x.Stacks
	}
	return nil
}

func (x *StatusProto_ExceptionProto) GetExecutor() string {
	if x != nil {
		return x.Executor
	}
	return ""
}

type DataRequestProto_DataContentProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Documents:
	//
	//	*DataRequestProto_DataContentProto_Docs
	//	*DataRequestProto_DataContentProto_DocsBytes
	Documents isDataRequestProto_DataContentProto_Documents `protobuf_oneof:"documents"`
}

func (x *DataRequestProto_DataContentProto) Reset() {
	*x = DataRequestProto_DataContentProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_jina_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRequestProto_DataContentProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRequestProto_DataContentProto) ProtoMessage() {}

func (x *DataRequestProto_DataContentProto) ProtoReflect() protoreflect.Message {
	mi := &file_jina_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRequestProto_DataContentProto.ProtoReflect.Descriptor instead.
func (*DataRequestProto_DataContentProto) Descriptor() ([]byte, []int) {
	return file_jina_proto_rawDescGZIP(), []int{6, 0}
}

func (m *DataRequestProto_DataContentProto) GetDocuments() isDataRequestProto_DataContentProto_Documents {
	if m != nil {
		return m.Documents
	}
	return nil
}

func (x *DataRequestProto_DataContentProto) GetDocs() *docarray_go_proto.DocListProto {
	if x, ok := x.GetDocuments().(*DataRequestProto_DataContentProto_Docs); ok {
		return x.Docs
	}
	return nil
}

func (x *DataRequestProto_DataContentProto) GetDocsBytes() []byte {
	if x, ok := x.GetDocuments().(*DataRequestProto_DataContentProto_DocsBytes); ok {
		return x.DocsBytes
	}
	return nil
}

type isDataRequestProto_DataContentProto_Documents interface {
	isDataRequestProto_DataContentProto_Documents()
}

type DataRequestProto_DataContentProto_Docs struct {
	Docs *docarray_go_proto.DocListProto `protobuf:"bytes,1,opt,name=docs,proto3,oneof"` // the docs in this request
}

type DataRequestProto_DataContentProto_DocsBytes struct {
	DocsBytes []byte `protobuf:"bytes,2,opt,name=docs_bytes,json=docsBytes,proto3,oneof"` // the docs in this request as bytes
}

func (*DataRequestProto_DataContentProto_Docs) isDataRequestProto_DataContentProto_Documents() {}

func (*DataRequestProto_DataContentProto_DocsBytes) isDataRequestProto_DataContentProto_Documents() {}

var File_jina_proto protoreflect.FileDescriptor

var file_jina_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x04, 0x6a, 0x69,
	0x6e, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0e,
	0x64, 0x6f, 0x63, 0x61, 0x72, 0x72, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5,
	0x01, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a,
	0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6a, 0x69,
	0x6e, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xe7, 0x01, 0x0a, 0x0d, 0x4a, 0x69, 0x6e, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x31, 0x0a, 0x04, 0x6a, 0x69, 0x6e, 0x61,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x4a, 0x69,
	0x6e, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4a, 0x69, 0x6e, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6a, 0x69, 0x6e, 0x61, 0x12, 0x31, 0x0a, 0x04, 0x65,
	0x6e, 0x76, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6a, 0x69, 0x6e, 0x61,
	0x2e, 0x4a, 0x69, 0x6e, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45,
	0x6e, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x1a, 0x37,
	0x0a, 0x09, 0x4a, 0x69, 0x6e, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x45, 0x6e, 0x76, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x80, 0x02, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x29, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x78,
	0x65, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52,
	0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0d, 0x48, 0x02, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x88, 0x01,
	0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x22, 0x8a, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x31, 0x0a,
	0x07, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73,
	0x22, 0xb5, 0x02, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x30, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c,
	0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x09, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x78, 0x63, 0x65, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x65, 0x78, 0x63, 0x65, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x6c, 0x0a, 0x0e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x22, 0x24, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x01, 0x22, 0x7a, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x07, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x5f, 0x69, 0x64, 0x22, 0xcd, 0x02, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6a, 0x69, 0x6e, 0x61,
	0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x28, 0x0a,
	0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x1a, 0x6e, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2c, 0x0a, 0x04, 0x64, 0x6f, 0x63, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x64, 0x6f, 0x63, 0x61, 0x72, 0x72, 0x61,
	0x79, 0x2e, 0x44, 0x6f, 0x63, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x00,
	0x52, 0x04, 0x64, 0x6f, 0x63, 0x73, 0x12, 0x1f, 0x0a, 0x0a, 0x64, 0x6f, 0x63, 0x73, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09, 0x64, 0x6f,
	0x63, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x1a, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x29, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x37,
	0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x28, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x2e, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x64, 0x6f, 0x63, 0x61, 0x72, 0x72, 0x61, 0x79, 0x2e, 0x44,
	0x6f, 0x63, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0xa6, 0x01, 0x0a, 0x16, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x57, 0x6f, 0x44, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6a,
	0x69, 0x6e, 0x61, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x28, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x10, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x22, 0x4a, 0x0a, 0x14, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x32, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x22, 0x0a, 0x0a, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x21, 0x0a, 0x09, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x89, 0x02,
	0x0a, 0x13, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x49, 0x64, 0x52, 0x02, 0x69, 0x64, 0x12, 0x38, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x22, 0x71, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55, 0x45, 0x55, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f,
	0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x06, 0x22, 0xd6, 0x01, 0x0a, 0x1a, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x49, 0x64, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3f, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x6a, 0x69, 0x6e, 0x61,
	0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x56, 0x0a, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x10, 0x06, 0x22, 0x3d, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x32, 0x5a, 0x0a, 0x12, 0x4a, 0x69, 0x6e, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x50, 0x43, 0x12, 0x44, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x00, 0x32, 0x63, 0x0a,
	0x18, 0x4a, 0x69, 0x6e, 0x61, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x50, 0x43, 0x12, 0x47, 0x0a, 0x13, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x16, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x00, 0x32, 0x74, 0x0a, 0x1c, 0x4a, 0x69, 0x6e, 0x61, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x50, 0x43, 0x12, 0x54, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x6f, 0x63,
	0x12, 0x20, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x00, 0x30, 0x01, 0x32, 0x47, 0x0a, 0x07, 0x4a, 0x69, 0x6e, 0x61,
	0x52, 0x50, 0x43, 0x12, 0x3c, 0x0a, 0x04, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x16, 0x2e, 0x6a, 0x69,
	0x6e, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x00, 0x28, 0x01, 0x30,
	0x01, 0x32, 0x60, 0x0a, 0x18, 0x4a, 0x69, 0x6e, 0x61, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x50, 0x43, 0x12, 0x44, 0x0a,
	0x12, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x14, 0x2e, 0x6a, 0x69,
	0x6e, 0x61, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x00, 0x32, 0x4e, 0x0a, 0x14, 0x4a, 0x69, 0x6e, 0x61, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x44, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x52, 0x50, 0x43, 0x12, 0x36, 0x0a, 0x07, 0x64,
	0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x11,
	0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x00, 0x32, 0x47, 0x0a, 0x0b, 0x4a, 0x69, 0x6e, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x50, 0x43, 0x12, 0x38, 0x0a, 0x07, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x13, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x4a, 0x69, 0x6e,
	0x61, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x00, 0x32, 0x57, 0x0a, 0x14,
	0x4a, 0x69, 0x6e, 0x61, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x12, 0x3f, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x19, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x00, 0x32, 0x60, 0x0a, 0x1c, 0x4a, 0x69, 0x6e, 0x61, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x10, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x49, 0x64, 0x1a, 0x19, 0x2e, 0x6a, 0x69, 0x6e,
	0x61, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x00, 0x32, 0x62, 0x0a, 0x13, 0x4a, 0x69, 0x6e, 0x61, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x4b,
	0x0a, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x1c, 0x2e, 0x6a, 0x69, 0x6e, 0x61,
	0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x1a, 0x20, 0x2e, 0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x00, 0x32, 0x64, 0x0a, 0x1b, 0x4a,
	0x69, 0x6e, 0x61, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x45, 0x0a, 0x0e, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0f, 0x2e, 0x6a,
	0x69, 0x6e, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x1a, 0x20, 0x2e,
	0x6a, 0x69, 0x6e, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x00, 0x42, 0x15, 0x5a, 0x13, 0x6a, 0x72, 0x61, 0x66, 0x74, 0x2f, 0x6a, 0x69, 0x6e, 0x61, 0x2d,
	0x67, 0x6f, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_jina_proto_rawDescOnce sync.Once
	file_jina_proto_rawDescData = file_jina_proto_rawDesc
)

func file_jina_proto_rawDescGZIP() []byte {
	file_jina_proto_rawDescOnce.Do(func() {
		file_jina_proto_rawDescData = protoimpl.X.CompressGZIP(file_jina_proto_rawDescData)
	})
	return file_jina_proto_rawDescData
}

var file_jina_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_jina_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_jina_proto_goTypes = []interface{}{
	(StatusProto_StatusCode)(0),               // 0: jina.StatusProto.StatusCode
	(SnapshotStatusProto_Status)(0),           // 1: jina.SnapshotStatusProto.Status
	(RestoreSnapshotStatusProto_Status)(0),    // 2: jina.RestoreSnapshotStatusProto.Status
	(*RouteProto)(nil),                        // 3: jina.RouteProto
	(*JinaInfoProto)(nil),                     // 4: jina.JinaInfoProto
	(*HeaderProto)(nil),                       // 5: jina.HeaderProto
	(*EndpointsProto)(nil),                    // 6: jina.EndpointsProto
	(*StatusProto)(nil),                       // 7: jina.StatusProto
	(*RelatedEntity)(nil),                     // 8: jina.RelatedEntity
	(*DataRequestProto)(nil),                  // 9: jina.DataRequestProto
	(*SingleDocumentRequestProto)(nil),        // 10: jina.SingleDocumentRequestProto
	(*DataRequestProtoWoData)(nil),            // 11: jina.DataRequestProtoWoData
	(*DataRequestListProto)(nil),              // 12: jina.DataRequestListProto
	(*SnapshotId)(nil),                        // 13: jina.SnapshotId
	(*RestoreId)(nil),                         // 14: jina.RestoreId
	(*SnapshotStatusProto)(nil),               // 15: jina.SnapshotStatusProto
	(*RestoreSnapshotStatusProto)(nil),        // 16: jina.RestoreSnapshotStatusProto
	(*RestoreSnapshotCommand)(nil),            // 17: jina.RestoreSnapshotCommand
	nil,                                       // 18: jina.JinaInfoProto.JinaEntry
	nil,                                       // 19: jina.JinaInfoProto.EnvsEntry
	(*StatusProto_ExceptionProto)(nil),        // 20: jina.StatusProto.ExceptionProto
	(*DataRequestProto_DataContentProto)(nil), // 21: jina.DataRequestProto.DataContentProto
	(*timestamppb.Timestamp)(nil),             // 22: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                   // 23: google.protobuf.Struct
	(*docarray_go_proto.DocProto)(nil),        // 24: docarray.DocProto
	(*docarray_go_proto.DocListProto)(nil),    // 25: docarray.DocListProto
	(*emptypb.Empty)(nil),                     // 26: google.protobuf.Empty
}
var file_jina_proto_depIdxs = []int32{
	22, // 0: jina.RouteProto.start_time:type_name -> google.protobuf.Timestamp
	22, // 1: jina.RouteProto.end_time:type_name -> google.protobuf.Timestamp
	7,  // 2: jina.RouteProto.status:type_name -> jina.StatusProto
	18, // 3: jina.JinaInfoProto.jina:type_name -> jina.JinaInfoProto.JinaEntry
	19, // 4: jina.JinaInfoProto.envs:type_name -> jina.JinaInfoProto.EnvsEntry
	7,  // 5: jina.HeaderProto.status:type_name -> jina.StatusProto
	23, // 6: jina.EndpointsProto.schemas:type_name -> google.protobuf.Struct
	0,  // 7: jina.StatusProto.code:type_name -> jina.StatusProto.StatusCode
	20, // 8: jina.StatusProto.exception:type_name -> jina.StatusProto.ExceptionProto
	5,  // 9: jina.DataRequestProto.header:type_name -> jina.HeaderProto
	23, // 10: jina.DataRequestProto.parameters:type_name -> google.protobuf.Struct
	3,  // 11: jina.DataRequestProto.routes:type_name -> jina.RouteProto
	21, // 12: jina.DataRequestProto.data:type_name -> jina.DataRequestProto.DataContentProto
	5,  // 13: jina.SingleDocumentRequestProto.header:type_name -> jina.HeaderProto
	23, // 14: jina.SingleDocumentRequestProto.parameters:type_name -> google.protobuf.Struct
	3,  // 15: jina.SingleDocumentRequestProto.routes:type_name -> jina.RouteProto
	24, // 16: jina.SingleDocumentRequestProto.document:type_name -> docarray.DocProto
	5,  // 17: jina.DataRequestProtoWoData.header:type_name -> jina.HeaderProto
	23, // 18: jina.DataRequestProtoWoData.parameters:type_name -> google.protobuf.Struct
	3,  // 19: jina.DataRequestProtoWoData.routes:type_name -> jina.RouteProto
	9,  // 20: jina.DataRequestListProto.requests:type_name -> jina.DataRequestProto
	13, // 21: jina.SnapshotStatusProto.id:type_name -> jina.SnapshotId
	1,  // 22: jina.SnapshotStatusProto.status:type_name -> jina.SnapshotStatusProto.Status
	14, // 23: jina.RestoreSnapshotStatusProto.id:type_name -> jina.RestoreId
	2,  // 24: jina.RestoreSnapshotStatusProto.status:type_name -> jina.RestoreSnapshotStatusProto.Status
	25, // 25: jina.DataRequestProto.DataContentProto.docs:type_name -> docarray.DocListProto
	12, // 26: jina.JinaDataRequestRPC.process_data:input_type -> jina.DataRequestListProto
	9,  // 27: jina.JinaSingleDataRequestRPC.process_single_data:input_type -> jina.DataRequestProto
	10, // 28: jina.JinaSingleDocumentRequestRPC.stream_doc:input_type -> jina.SingleDocumentRequestProto
	9,  // 29: jina.JinaRPC.Call:input_type -> jina.DataRequestProto
	26, // 30: jina.JinaDiscoverEndpointsRPC.endpoint_discovery:input_type -> google.protobuf.Empty
	26, // 31: jina.JinaGatewayDryRunRPC.dry_run:input_type -> google.protobuf.Empty
	26, // 32: jina.JinaInfoRPC._status:input_type -> google.protobuf.Empty
	26, // 33: jina.JinaExecutorSnapshot.snapshot:input_type -> google.protobuf.Empty
	13, // 34: jina.JinaExecutorSnapshotProgress.snapshot_status:input_type -> jina.SnapshotId
	17, // 35: jina.JinaExecutorRestore.restore:input_type -> jina.RestoreSnapshotCommand
	14, // 36: jina.JinaExecutorRestoreProgress.restore_status:input_type -> jina.RestoreId
	9,  // 37: jina.JinaDataRequestRPC.process_data:output_type -> jina.DataRequestProto
	9,  // 38: jina.JinaSingleDataRequestRPC.process_single_data:output_type -> jina.DataRequestProto
	10, // 39: jina.JinaSingleDocumentRequestRPC.stream_doc:output_type -> jina.SingleDocumentRequestProto
	9,  // 40: jina.JinaRPC.Call:output_type -> jina.DataRequestProto
	6,  // 41: jina.JinaDiscoverEndpointsRPC.endpoint_discovery:output_type -> jina.EndpointsProto
	7,  // 42: jina.JinaGatewayDryRunRPC.dry_run:output_type -> jina.StatusProto
	4,  // 43: jina.JinaInfoRPC._status:output_type -> jina.JinaInfoProto
	15, // 44: jina.JinaExecutorSnapshot.snapshot:output_type -> jina.SnapshotStatusProto
	15, // 45: jina.JinaExecutorSnapshotProgress.snapshot_status:output_type -> jina.SnapshotStatusProto
	16, // 46: jina.JinaExecutorRestore.restore:output_type -> jina.RestoreSnapshotStatusProto
	16, // 47: jina.JinaExecutorRestoreProgress.restore_status:output_type -> jina.RestoreSnapshotStatusProto
	37, // [37:48] is the sub-list for method output_type
	26, // [26:37] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_jina_proto_init() }
func file_jina_proto_init() {
	if File_jina_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_jina_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JinaInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeaderProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndpointsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SingleDocumentRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRequestProtoWoData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRequestListProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreSnapshotStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreSnapshotCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusProto_ExceptionProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_jina_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataRequestProto_DataContentProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_jina_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_jina_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_jina_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*DataRequestProto_DataContentProto_Docs)(nil),
		(*DataRequestProto_DataContentProto_DocsBytes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_jina_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   11,
		},
		GoTypes:           file_jina_proto_goTypes,
		DependencyIndexes: file_jina_proto_depIdxs,
		EnumInfos:         file_jina_proto_enumTypes,
		MessageInfos:      file_jina_proto_msgTypes,
	}.Build()
	File_jina_proto = out.File
	file_jina_proto_rawDesc = nil
	file_jina_proto_goTypes = nil
	file_jina_proto_depIdxs = nil
}
