import unittest
from hashlib import md5

import requests
from approvaltests import verify_as_json

from tira.rest_api_client import Client
from tira.tira_redirects import mirror_url, redirects


def md5_of_first_kilobyte_of_http_resource(url):
    # if not url.startswith('https://files.webis.de'):
    #    raise ValueError(f'URL {url} is not from webis.de respectively zenodo')
    print(url, flush=True)
    return md5(requests.get(url, headers={"Range": "bytes=0-1024"}).content).hexdigest()


RUN_IDS = {
    "ir-benchmarks": {
        "tira-ir-starter": {
            "Index (tira-ir-starter-pyterrier)": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2023-01-07-22-09-56",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2023-01-07-22-09-56",
                "antique-test-20230107-training": "2023-01-07-13-40-04",
                "vaswani-20230107-training": "2023-01-07-19-01-50",
                "cranfield-20230107-training": "2023-01-07-13-39-11",
                "medline-2004-trec-genomics-2004-20230107-training": "2023-01-07-19-37-49",
                "medline-2017-trec-pm-2017-20230211-training": "2023-02-11-20-52-47",
                "cord19-fulltext-trec-covid-20230107-training": "2023-01-08-15-18-20",
                "nfcorpus-test-20230107-training": "2023-02-09-15-46-37",
                "argsme-touche-2020-task-1-20230209-training": "2023-02-09-17-50-22",
                "argsme-touche-2021-task-1-20230209-training": "2023-02-09-17-50-22",
                "medline-2017-trec-pm-2018-20230211-training": "2023-02-11-15-15-35",
                "medline-2004-trec-genomics-2005-20230107-training": "2023-02-09-22-14-32",
                "trec-tip-of-the-tongue-dev-20230607-training": "2023-11-10-23-23-59",
                "longeval-short-july-20230513-training": "2023-11-10-23-22-59",
                "longeval-heldout-20230513-training": "2023-11-10-23-21-55",
                "longeval-long-september-20230513-training": "2023-11-10-21-09-17",
                "longeval-train-20230513-training": "2023-11-11-06-49-15",
            }
        },
        "seanmacavaney": {
            "DocT5Query": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-19-20-04-59",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-19-20-04-59",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-19-19-58-58",
                "antique-test-20230107-training": "2024-03-19-18-06-23",
                "vaswani-20230107-training": "2024-03-19-19-32-44",
                "cranfield-20230107-training": "2024-03-19-17-50-12",
                "nfcorpus-test-20230107-training": "2024-03-19-19-51-27",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-19-19-48-04",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-19-17-52-36",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-19-17-59-19",
                "longeval-short-july-20230513-training": "2024-03-19-19-57-39",
                "longeval-heldout-20230513-training": "2024-03-19-19-49-22",
                "longeval-long-september-20230513-training": "2024-03-19-19-52-58",
                "longeval-train-20230513-training": "2024-03-19-19-46-01",
            },
            "corpus-graph": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-21-12-27-29",
                "antique-test-20230107-training": "2024-03-21-15-00-49",
                "longeval-short-july-20230513-training": "2024-03-21-12-45-07",
                "longeval-heldout-20230513-training": "2024-03-21-12-39-51",
                "longeval-long-september-20230513-training": "2024-03-21-12-40-32",
                "longeval-train-20230513-training": "2024-03-21-12-46-50",
            },
        },
        "marcel-gohsen": {
            "query-interpretation": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-02-24-22-34-40",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-02-24-22-38-34",
                "antique-test-20230107-training": "2024-02-22-23-06-50",
                "vaswani-20230107-training": "2024-02-28-15-30-25",
                "nfcorpus-test-20230107-training": "2024-02-28-15-31-40",
                "medline-2017-trec-pm-2017-20230211-training": "2024-02-24-22-31-42",
                "cord19-fulltext-trec-covid-20230107-training": "2024-02-23-04-47-37",
                "medline-2017-trec-pm-2018-20230211-training": "2024-02-24-22-32-52",
                "argsme-touche-2020-task-1-20230209-training": "2024-02-22-23-21-20",
                "argsme-touche-2021-task-1-20230209-training": "2024-02-22-23-22-30",
                "longeval-short-july-20230513-training": "2024-02-23-07-15-45",
                "longeval-heldout-20230513-training": "2024-02-23-07-14-14",
                "longeval-long-september-20230513-training": "2024-02-23-07-15-04",
                "longeval-train-20230513-training": "2024-02-23-07-19-23",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-02-22-23-07-41",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-02-22-23-29-37",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-02-22-23-31-22",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-02-22-23-32-55",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-02-23-04-25-20",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-02-23-04-26-17",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-02-23-04-27-35",
                "clueweb12-trec-web-2013-20230107-training": "2024-02-23-04-29-23",
                "clueweb12-trec-web-2014-20230107-training": "2024-02-23-04-31-19",
                "gov-trec-web-2002-20230209-training": "2024-02-23-05-05-06",
                "gov-trec-web-2003-20230209-training": "2024-02-23-05-08-10",
                "gov-trec-web-2004-20230209-training": "2024-02-23-05-09-53",
                "gov2-trec-tb-2004-20230209-training": "2024-02-23-05-11-24",
                "gov2-trec-tb-2005-20230209-training": "2024-02-23-05-13-20",
                "gov2-trec-tb-2006-20230209-training": "2024-02-23-05-15-32",
                "wapo-v2-trec-core-2018-20230107-training": "2024-02-24-22-42-50",
                "disks45-nocr-trec8-20230209-training": "2024-02-23-04-59-49",
                "disks45-nocr-trec7-20230209-training": "2024-02-23-04-53-54",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-02-22-23-05-54",
            },
            "entity-linking": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-02-22-05-34-17",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-02-22-05-39-34",
                "antique-test-20230107-training": "2024-02-21-16-29-52",
                "vaswani-20230107-training": "2024-02-22-05-59-53",
                "cranfield-20230107-training": "2024-02-21-22-39-20",
                "nfcorpus-test-20230107-training": "2024-02-22-05-52-56",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-02-22-05-21-04",
                "medline-2017-trec-pm-2017-20230211-training": "2024-02-22-05-28-20",
                "cord19-fulltext-trec-covid-20230107-training": "2024-02-21-22-38-29",
                "medline-2017-trec-pm-2018-20230211-training": "2024-02-22-05-31-55",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-02-22-05-24-31",
                "argsme-touche-2020-task-1-20230209-training": "2024-02-21-20-33-45",
                "argsme-touche-2021-task-1-20230209-training": "2024-02-21-20-34-46",
                "longeval-short-july-20230513-training": "2024-02-22-05-03-49",
                "longeval-heldout-20230513-training": "2024-02-22-04-59-59",
                "longeval-long-september-20230513-training": "2024-02-22-05-02-53",
                "longeval-train-20230513-training": "2024-02-22-05-05-35",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-02-21-20-42-58",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-02-21-20-49-58",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-02-21-22-23-42",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-02-21-22-25-05",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-02-21-22-26-58",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-02-21-22-28-07",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-02-21-22-30-48",
                "clueweb12-trec-web-2013-20230107-training": "2024-02-21-22-32-07",
                "clueweb12-trec-web-2014-20230107-training": "2024-02-21-22-36-37",
                "gov-trec-web-2002-20230209-training": "2024-02-21-22-54-51",
                "gov-trec-web-2003-20230209-training": "2024-02-21-23-16-48",
                "gov-trec-web-2004-20230209-training": "2024-02-21-23-18-01",
                "gov2-trec-tb-2004-20230209-training": "2024-02-21-23-18-59",
                "gov2-trec-tb-2005-20230209-training": "2024-02-21-23-19-48",
                "gov2-trec-tb-2006-20230209-training": "2024-02-21-23-21-01",
                "wapo-v2-trec-core-2018-20230107-training": "2024-02-22-06-00-47",
                "disks45-nocr-trec8-20230209-training": "2024-02-21-22-46-17",
                "disks45-nocr-trec7-20230209-training": "2024-02-21-22-45-10",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-02-21-15-01-26",
            },
        },
        "qpptk": {
            "all-predictors": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-02-27-21-30-47",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-02-27-21-31-54",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-02-27-21-36-40",
                "antique-test-20230107-training": "2024-02-27-20-06-32",
                "vaswani-20230107-training": "2024-02-27-21-38-47",
                "cranfield-20230107-training": "2024-02-27-20-20-33",
                "nfcorpus-test-20230107-training": "2024-02-27-21-34-23",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-02-27-21-21-07",
                "medline-2017-trec-pm-2017-20230211-training": "2024-02-27-21-27-05",
                "cord19-fulltext-trec-covid-20230107-training": "2024-02-27-20-18-28",
                "medline-2017-trec-pm-2018-20230211-training": "2024-02-27-21-28-47",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-02-27-21-26-22",
                "argsme-touche-2020-task-1-20230209-training": "2024-02-27-20-09-14",
                "argsme-touche-2021-task-1-20230209-training": "2024-02-27-20-10-51",
                "longeval-short-july-20230513-training": "2024-02-27-21-15-17",
                "longeval-heldout-20230513-training": "2024-02-27-20-56-41",
                "longeval-long-september-20230513-training": "2024-02-27-21-10-42",
                "longeval-train-20230513-training": "2024-02-27-21-19-19",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-02-27-20-13-20",
                "gov-trec-web-2002-20230209-training": "2024-02-27-20-26-06",
                "gov-trec-web-2003-20230209-training": "2024-02-27-20-27-09",
                "gov-trec-web-2004-20230209-training": "2024-02-27-20-29-21",
                "gov2-trec-tb-2004-20230209-training": "2024-02-27-20-30-58",
                "gov2-trec-tb-2005-20230209-training": "2024-02-27-20-33-27",
                "gov2-trec-tb-2006-20230209-training": "2024-02-27-20-37-51",
                "wapo-v2-trec-core-2018-20230107-training": "2024-02-27-21-40-17",
                "disks45-nocr-trec8-20230209-training": "2024-02-27-20-24-50",
                "disks45-nocr-trec7-20230209-training": "2024-02-27-20-23-24",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-02-27-20-22-13",
            }
        },
        "salamander": {
            "classify-comparative-queries": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-02-25-16-58-54",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-02-25-20-36-41",
                "antique-test-20230107-training": "2024-02-25-15-17-55",
                "vaswani-20230107-training": "2024-02-25-20-40-09",
                "cranfield-20230107-training": "2024-02-25-15-45-40",
                "nfcorpus-test-20230107-training": "2024-02-25-20-37-46",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-02-25-16-09-36",
                "medline-2017-trec-pm-2017-20230211-training": "2024-02-25-16-12-21",
                "cord19-fulltext-trec-covid-20230107-training": "2024-02-25-15-44-30",
                "medline-2017-trec-pm-2018-20230211-training": "2024-02-25-16-57-26",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-02-25-16-11-16",
                "argsme-touche-2020-task-1-20230209-training": "2024-02-25-15-19-08",
                "argsme-touche-2021-task-1-20230209-training": "2024-02-25-15-20-13",
                "longeval-short-july-20230513-training": "2024-02-25-16-04-17",
                "longeval-heldout-20230513-training": "2024-02-25-16-01-03",
                "longeval-long-september-20230513-training": "2024-02-25-16-03-12",
                "longeval-train-20230513-training": "2024-02-25-16-06-29",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-02-25-15-21-18",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-02-25-15-24-17",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-02-25-15-25-22",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-02-25-15-26-28",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-02-25-15-27-38",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-02-25-15-28-44",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-02-25-15-29-50",
                "clueweb12-trec-web-2013-20230107-training": "2024-02-25-15-30-55",
                "clueweb12-trec-web-2014-20230107-training": "2024-02-25-15-32-03",
                "gov-trec-web-2002-20230209-training": "2024-02-25-15-51-54",
                "gov-trec-web-2003-20230209-training": "2024-02-25-15-53-06",
                "gov-trec-web-2004-20230209-training": "2024-02-25-15-54-30",
                "gov2-trec-tb-2004-20230209-training": "2024-02-25-15-55-44",
                "gov2-trec-tb-2005-20230209-training": "2024-02-25-15-58-17",
                "gov2-trec-tb-2006-20230209-training": "2024-02-25-15-59-47",
                "wapo-v2-trec-core-2018-20230107-training": "2024-02-25-20-41-24",
                "disks45-nocr-trec8-20230209-training": "2024-02-25-15-51-07",
                "disks45-nocr-trec7-20230209-training": "2024-02-25-15-49-58",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-02-25-15-48-48",
            }
        },
        "ows": {
            "query-segmentation-hyb-a": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-02-25-07-57-14",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-02-25-07-58-43",
                "antique-test-20230107-training": "2024-02-25-06-14-01",
                "vaswani-20230107-training": "2024-02-25-09-10-19",
                "nfcorpus-test-20230107-training": "2024-02-25-09-31-46",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-02-25-06-54-36",
                "medline-2017-trec-pm-2017-20230211-training": "2024-02-25-06-58-31",
                "cord19-fulltext-trec-covid-20230107-training": "2024-02-25-00-17-52",
                "medline-2017-trec-pm-2018-20230211-training": "2024-02-25-08-00-37",
                "argsme-touche-2020-task-1-20230209-training": "2024-02-25-06-15-29",
                "argsme-touche-2021-task-1-20230209-training": "2024-02-24-23-35-21",
                "longeval-short-july-20230513-training": "2024-02-25-08-11-42",
                "longeval-heldout-20230513-training": "2024-02-25-08-09-09",
                "longeval-long-september-20230513-training": "2024-02-25-08-10-24",
                "longeval-train-20230513-training": "2024-02-25-08-12-47",
                "clueweb09-en-trec-web-2009-20230107-training": "2023-11-02-13-08-25",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-02-24-23-38-34",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-02-24-23-43-13",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-02-24-23-44-25",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-02-24-23-45-36",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-02-24-23-46-38",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-02-24-23-53-25",
                "clueweb12-trec-web-2013-20230107-training": "2024-02-24-23-55-48",
                "clueweb12-trec-web-2014-20230107-training": "2024-02-25-00-16-12",
                "gov-trec-web-2002-20230209-training": "2024-02-25-06-18-07",
                "gov-trec-web-2003-20230209-training": "2024-02-25-00-35-06",
                "gov-trec-web-2004-20230209-training": "2024-02-25-00-36-45",
                "gov2-trec-tb-2004-20230209-training": "2024-02-25-00-38-02",
                "gov2-trec-tb-2005-20230209-training": "2024-02-25-00-40-11",
                "gov2-trec-tb-2006-20230209-training": "2024-02-25-00-41-47",
                "wapo-v2-trec-core-2018-20230107-training": "2024-02-25-06-52-49",
                "disks45-nocr-trec8-20230209-training": "2024-02-25-00-25-21",
                "disks45-nocr-trec7-20230209-training": "2024-02-25-00-19-33",
                "disks45-nocr-trec-robust-2004-20230209-training": "2023-11-02-13-07-52",
            }
        },
        "dossier": {
            "pre-retrieval-query-intent": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-02-26-19-33-36",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-02-26-19-35-37",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-02-26-19-40-46",
                "antique-test-20230107-training": "2024-02-26-17-12-41",
                "vaswani-20230107-training": "2024-02-26-19-42-46",
                "cranfield-20230107-training": "2024-02-26-17-44-46",
                "nfcorpus-test-20230107-training": "2024-02-26-19-37-52",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-02-26-19-28-40",
                "medline-2017-trec-pm-2017-20230211-training": "2024-02-26-19-31-16",
                "cord19-fulltext-trec-covid-20230107-training": "2024-02-26-17-43-08",
                "medline-2017-trec-pm-2018-20230211-training": "2024-02-26-19-32-28",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-02-26-19-30-06",
                "argsme-touche-2020-task-1-20230209-training": "2024-02-26-17-15-36",
                "argsme-touche-2021-task-1-20230209-training": "2024-02-26-17-17-33",
                "longeval-short-july-20230513-training": "2024-02-26-19-25-39",
                "longeval-heldout-20230513-training": "2024-02-26-19-22-37",
                "longeval-long-september-20230513-training": "2024-02-26-19-24-16",
                "longeval-train-20230513-training": "2024-02-26-19-27-33",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-02-26-17-18-45",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-02-26-17-20-45",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-02-26-17-24-55",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-02-26-17-29-51",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-02-26-17-30-59",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-02-26-17-32-36",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-02-26-17-36-05",
                "clueweb12-trec-web-2013-20230107-training": "2024-02-26-17-37-38",
                "clueweb12-trec-web-2014-20230107-training": "2024-02-26-17-40-20",
                "gov-trec-web-2002-20230209-training": "2024-02-26-17-51-12",
                "gov-trec-web-2003-20230209-training": "2024-02-26-17-53-35",
                "gov-trec-web-2004-20230209-training": "2024-02-26-17-56-43",
                "gov2-trec-tb-2004-20230209-training": "2024-02-26-19-13-24",
                "gov2-trec-tb-2005-20230209-training": "2024-02-26-19-14-39",
                "gov2-trec-tb-2006-20230209-training": "2024-02-26-19-15-59",
                "wapo-v2-trec-core-2018-20230107-training": "2024-02-26-19-44-28",
                "disks45-nocr-trec8-20230209-training": "2024-02-26-17-49-59",
                "disks45-nocr-trec7-20230209-training": "2024-02-26-17-47-43",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-02-26-17-46-48",
            }
        },
        "tu-dresden-03": {
            "qe-gpt3.5-sq-zs": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-10-23-21-00",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-10-23-24-23",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-10-23-53-03",
                "antique-test-20230107-training": "2024-03-10-22-10-01",
                "vaswani-20230107-training": "2024-03-10-23-31-54",
                "cranfield-20230107-training": "2024-03-10-22-35-20",
                "nfcorpus-test-20230107-training": "2024-03-10-23-28-11",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-10-23-07-10",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-10-23-13-46",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-10-22-31-58",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-10-23-17-22",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-10-23-10-24",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-10-22-13-28",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-10-22-17-02",
                "longeval-short-july-20230513-training": "2024-03-10-23-46-07",
                "longeval-heldout-20230513-training": "2024-03-10-23-38-30",
                "longeval-long-september-20230513-training": "2024-03-10-23-42-12",
                "longeval-train-20230513-training": "2024-03-10-23-49-34",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-10-21-45-42",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-10-21-49-07",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-10-21-52-44",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-10-21-56-30",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-10-22-20-43",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-10-22-24-26",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-10-22-28-13",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-10-22-00-00",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-10-22-03-19",
                "gov-trec-web-2002-20230209-training": "2024-03-10-22-45-29",
                "gov-trec-web-2003-20230209-training": "2024-03-10-22-49-06",
                "gov-trec-web-2004-20230209-training": "2024-03-10-22-52-40",
                "gov2-trec-tb-2004-20230209-training": "2024-03-10-22-56-22",
                "gov2-trec-tb-2005-20230209-training": "2024-03-10-22-59-53",
                "gov2-trec-tb-2006-20230209-training": "2024-03-10-23-03-34",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-10-23-35-07",
                "disks45-nocr-trec8-20230209-training": "2024-03-10-22-42-10",
                "disks45-nocr-trec7-20230209-training": "2024-03-10-22-38-46",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-10-22-06-48",
            },
            "qe-llama-sq-zs": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-11-11-24-14",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-11-11-28-01",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-11-12-56-13",
                "antique-test-20230107-training": "2024-03-11-10-12-20",
                "vaswani-20230107-training": "2024-03-11-12-33-41",
                "cranfield-20230107-training": "2024-03-11-10-37-42",
                "nfcorpus-test-20230107-training": "2024-03-11-11-31-37",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-11-11-09-58",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-11-11-17-03",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-11-10-34-13",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-11-11-20-41",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-11-11-13-15",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-11-10-15-56",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-11-10-19-55",
                "longeval-short-july-20230513-training": "2024-03-11-12-48-27",
                "longeval-heldout-20230513-training": "2024-03-11-12-41-01",
                "longeval-long-september-20230513-training": "2024-03-11-12-44-42",
                "longeval-train-20230513-training": "2024-03-11-12-52-26",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-11-09-48-10",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-11-09-51-37",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-11-09-55-00",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-11-09-58-17",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-11-10-23-31",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-11-10-27-09",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-11-10-30-45",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-11-10-01-45",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-11-10-05-13",
                "gov-trec-web-2002-20230209-training": "2024-03-11-10-48-40",
                "gov-trec-web-2003-20230209-training": "2024-03-11-10-52-24",
                "gov-trec-web-2004-20230209-training": "2024-03-11-10-56-10",
                "gov2-trec-tb-2004-20230209-training": "2024-03-11-10-59-35",
                "gov2-trec-tb-2005-20230209-training": "2024-03-11-11-03-01",
                "gov2-trec-tb-2006-20230209-training": "2024-03-11-11-06-26",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-11-12-37-19",
                "disks45-nocr-trec8-20230209-training": "2024-03-11-10-45-12",
                "disks45-nocr-trec7-20230209-training": "2024-03-11-10-41-34",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-11-10-08-47",
            },
            "qe-llama-sq-fs": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-11-09-12-36",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-11-09-16-25",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-11-09-44-45",
                "antique-test-20230107-training": "2024-03-11-08-01-16",
                "vaswani-20230107-training": "2024-03-11-09-23-25",
                "cranfield-20230107-training": "2024-03-11-08-26-26",
                "nfcorpus-test-20230107-training": "2024-03-11-09-20-02",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-11-08-58-33",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-11-09-05-18",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-11-08-22-58",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-11-09-08-56",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-11-09-01-54",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-11-08-05-00",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-11-08-08-49",
                "longeval-short-july-20230513-training": "2024-03-11-09-37-33",
                "longeval-heldout-20230513-training": "2024-03-11-09-30-01",
                "longeval-long-september-20230513-training": "2024-03-11-09-34-00",
                "longeval-train-20230513-training": "2024-03-11-09-41-08",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-11-07-35-54",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-11-07-39-18",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-11-07-43-07",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-11-07-46-27",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-11-08-12-28",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-11-08-16-20",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-11-08-19-45",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-11-07-50-22",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-11-07-54-08",
                "gov-trec-web-2002-20230209-training": "2024-03-11-08-36-41",
                "gov-trec-web-2003-20230209-training": "2024-03-11-08-40-26",
                "gov-trec-web-2004-20230209-training": "2024-03-11-08-44-20",
                "gov2-trec-tb-2004-20230209-training": "2024-03-11-08-48-05",
                "gov2-trec-tb-2005-20230209-training": "2024-03-11-08-51-47",
                "gov2-trec-tb-2006-20230209-training": "2024-03-11-08-55-01",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-11-09-26-47",
                "disks45-nocr-trec8-20230209-training": "2024-03-11-08-33-25",
                "disks45-nocr-trec7-20230209-training": "2024-03-11-08-30-00",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-11-07-57-21",
            },
            "qe-llama-cot": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-11-06-44-59",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-11-06-48-35",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-11-07-32-21",
                "antique-test-20230107-training": "2024-03-11-05-02-44",
                "vaswani-20230107-training": "2024-03-11-06-56-01",
                "cranfield-20230107-training": "2024-03-11-05-58-31",
                "nfcorpus-test-20230107-training": "2024-03-11-06-52-23",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-11-06-30-51",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-11-06-37-54",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-11-05-54-54",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-11-06-41-21",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-11-06-34-42",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-11-05-06-08",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-11-05-09-23",
                "longeval-short-july-20230513-training": "2024-03-11-07-24-45",
                "longeval-heldout-20230513-training": "2024-03-11-07-18-03",
                "longeval-long-september-20230513-training": "2024-03-11-07-21-27",
                "longeval-train-20230513-training": "2024-03-11-07-28-35",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-11-04-38-08",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-11-04-41-35",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-11-04-44-59",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-11-04-48-37",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-11-05-12-59",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-11-05-48-01",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-11-05-51-18",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-11-04-52-19",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-11-04-55-40",
                "gov-trec-web-2002-20230209-training": "2024-03-11-06-09-07",
                "gov-trec-web-2003-20230209-training": "2024-03-11-06-12-49",
                "gov-trec-web-2004-20230209-training": "2024-03-11-06-16-30",
                "gov2-trec-tb-2004-20230209-training": "2024-03-11-06-20-18",
                "gov2-trec-tb-2005-20230209-training": "2024-03-11-06-23-56",
                "gov2-trec-tb-2006-20230209-training": "2024-03-11-06-27-22",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-11-06-59-20",
                "disks45-nocr-trec8-20230209-training": "2024-03-11-06-05-33",
                "disks45-nocr-trec7-20230209-training": "2024-03-11-06-02-12",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-11-04-59-00",
            },
            "qe-flan-ul2-sq-zs": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-12-13-22-06",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-12-13-24-02",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-12-13-45-36",
                "antique-test-20230107-training": "2024-03-12-11-42-21",
                "vaswani-20230107-training": "2024-03-12-13-32-08",
                "cranfield-20230107-training": "2024-03-12-12-47-07",
                "nfcorpus-test-20230107-training": "2024-03-12-13-25-53",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-12-13-09-45",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-12-13-13-39",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-12-12-44-56",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-12-13-15-57",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-12-13-11-55",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-12-11-44-07",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-12-11-46-01",
                "longeval-short-july-20230513-training": "2024-03-12-13-41-03",
                "longeval-heldout-20230513-training": "2024-03-12-13-36-26",
                "longeval-long-september-20230513-training": "2024-03-12-13-38-45",
                "longeval-train-20230513-training": "2024-03-12-13-43-24",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-12-11-23-47",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-12-11-25-47",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-12-11-27-50",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-12-11-30-10",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-12-11-48-17",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-12-12-40-51",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-12-12-43-11",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-12-11-31-55",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-12-11-34-12",
                "gov-trec-web-2002-20230209-training": "2024-03-12-12-57-09",
                "gov-trec-web-2003-20230209-training": "2024-03-12-12-59-04",
                "gov-trec-web-2004-20230209-training": "2024-03-12-13-01-12",
                "gov2-trec-tb-2004-20230209-training": "2024-03-12-13-03-24",
                "gov2-trec-tb-2005-20230209-training": "2024-03-12-13-05-30",
                "gov2-trec-tb-2006-20230209-training": "2024-03-12-13-07-43",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-12-13-34-24",
                "disks45-nocr-trec8-20230209-training": "2024-03-12-12-55-11",
                "disks45-nocr-trec7-20230209-training": "2024-03-12-12-49-05",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-12-11-36-08",
            },
            "qe-flan-ul2-sq-fs": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-12-11-02-51",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-12-11-04-38",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-12-11-21-42",
                "antique-test-20230107-training": "2024-03-12-10-02-37",
                "vaswani-20230107-training": "2024-03-12-11-08-58",
                "cranfield-20230107-training": "2024-03-12-10-30-49",
                "nfcorpus-test-20230107-training": "2024-03-12-11-06-57",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-12-10-50-07",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-12-10-58-26",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-12-10-28-22",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-12-11-00-24",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-12-10-52-16",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-12-10-06-10",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-12-10-09-37",
                "longeval-short-july-20230513-training": "2024-03-12-11-17-17",
                "longeval-heldout-20230513-training": "2024-03-12-11-13-18",
                "longeval-long-september-20230513-training": "2024-03-12-11-15-27",
                "longeval-train-20230513-training": "2024-03-12-11-19-15",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-12-07-17-33",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-12-07-21-00",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-12-07-25-45",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-12-07-29-27",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-12-10-13-17",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-12-10-16-50",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-12-10-26-15",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-12-07-33-04",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-12-07-46-07",
                "gov-trec-web-2002-20230209-training": "2024-03-12-10-37-15",
                "gov-trec-web-2003-20230209-training": "2024-03-12-10-39-25",
                "gov-trec-web-2004-20230209-training": "2024-03-12-10-41-33",
                "gov2-trec-tb-2004-20230209-training": "2024-03-12-10-43-44",
                "gov2-trec-tb-2005-20230209-training": "2024-03-12-10-45-46",
                "gov2-trec-tb-2006-20230209-training": "2024-03-12-10-47-58",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-12-11-11-20",
                "disks45-nocr-trec8-20230209-training": "2024-03-12-10-35-20",
                "disks45-nocr-trec7-20230209-training": "2024-03-12-10-32-58",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-12-08-07-04",
            },
            "qe-flan-ul2-cot": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-12-06-37-28",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-12-06-42-04",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-12-07-13-34",
                "antique-test-20230107-training": "2024-03-12-05-24-20",
                "vaswani-20230107-training": "2024-03-12-06-49-24",
                "cranfield-20230107-training": "2024-03-12-05-49-13",
                "nfcorpus-test-20230107-training": "2024-03-12-06-45-38",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-12-06-23-45",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-12-06-30-44",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-12-05-45-38",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-12-06-34-03",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-12-06-27-14",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-12-05-28-04",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-12-05-31-40",
                "longeval-short-july-20230513-training": "2024-03-12-07-04-50",
                "longeval-heldout-20230513-training": "2024-03-12-06-57-04",
                "longeval-long-september-20230513-training": "2024-03-12-07-01-01",
                "longeval-train-20230513-training": "2024-03-12-07-08-41",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-12-04-59-29",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-12-05-03-01",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-12-05-06-29",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-12-05-09-47",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-12-05-35-03",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-12-05-38-40",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-12-05-42-03",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-12-05-13-21",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-12-05-16-59",
                "gov-trec-web-2002-20230209-training": "2024-03-12-06-00-17",
                "gov-trec-web-2003-20230209-training": "2024-03-12-06-05-21",
                "gov-trec-web-2004-20230209-training": "2024-03-18-20-10-36",
                "gov2-trec-tb-2004-20230209-training": "2024-03-12-06-12-33",
                "gov2-trec-tb-2005-20230209-training": "2024-03-12-06-16-24",
                "gov2-trec-tb-2006-20230209-training": "2024-03-12-06-20-20",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-12-06-53-10",
                "disks45-nocr-trec8-20230209-training": "2024-03-12-05-56-41",
                "disks45-nocr-trec7-20230209-training": "2024-03-12-05-52-57",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-12-05-20-39",
            },
            "qe-gpt3.5-cot": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-10-18-45-51",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-10-18-49-22",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-10-19-17-06",
                "antique-test-20230107-training": "2024-03-10-17-31-31",
                "vaswani-20230107-training": "2024-03-10-18-56-33",
                "cranfield-20230107-training": "2024-03-10-17-42-13",
                "nfcorpus-test-20230107-training": "2024-03-10-18-53-00",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-10-18-32-29",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-10-18-39-13",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-10-17-40-32",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-10-18-42-37",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-10-18-35-54",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-10-17-32-46",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-10-17-34-14",
                "longeval-short-july-20230513-training": "2024-03-10-19-10-03",
                "longeval-heldout-20230513-training": "2024-03-10-19-03-22",
                "longeval-long-september-20230513-training": "2024-03-10-19-06-51",
                "longeval-train-20230513-training": "2024-03-10-19-13-34",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-10-17-20-21",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-10-17-22-14",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-10-17-23-46",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-10-17-25-13",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-10-17-35-41",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-10-17-37-10",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-10-17-38-57",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-10-17-26-54",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-10-17-28-24",
                "gov-trec-web-2002-20230209-training": "2024-03-10-18-11-34",
                "gov-trec-web-2003-20230209-training": "2024-03-10-18-15-02",
                "gov-trec-web-2004-20230209-training": "2024-03-10-18-18-27",
                "gov2-trec-tb-2004-20230209-training": "2024-03-10-18-21-41",
                "gov2-trec-tb-2005-20230209-training": "2024-03-10-18-25-14",
                "gov2-trec-tb-2006-20230209-training": "2024-03-10-18-28-55",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-10-19-00-01",
                "disks45-nocr-trec8-20230209-training": "2024-03-10-18-10-11",
                "disks45-nocr-trec7-20230209-training": "2024-03-10-17-43-32",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-10-17-30-14",
            },
            "qe-gpt3.5-sq-fs": {
                "msmarco-passage-trec-dl-2019-judged-20230107-training": "2024-03-10-21-11-31",
                "msmarco-passage-trec-dl-2020-judged-20230107-training": "2024-03-10-21-14-53",
                "trec-tip-of-the-tongue-dev-20230607-training": "2024-03-10-21-42-29",
                "antique-test-20230107-training": "2024-03-10-20-00-03",
                "vaswani-20230107-training": "2024-03-10-21-21-33",
                "cranfield-20230107-training": "2024-03-10-20-24-07",
                "nfcorpus-test-20230107-training": "2024-03-10-21-18-21",
                "medline-2004-trec-genomics-2004-20230107-training": "2024-03-10-20-57-14",
                "medline-2017-trec-pm-2017-20230211-training": "2024-03-10-21-04-20",
                "cord19-fulltext-trec-covid-20230107-training": "2024-03-10-20-20-39",
                "medline-2017-trec-pm-2018-20230211-training": "2024-03-10-21-08-00",
                "medline-2004-trec-genomics-2005-20230107-training": "2024-03-10-21-00-38",
                "argsme-touche-2020-task-1-20230209-training": "2024-03-10-20-03-26",
                "argsme-touche-2021-task-1-20230209-training": "2024-03-10-20-06-52",
                "longeval-short-july-20230513-training": "2024-03-10-21-35-45",
                "longeval-heldout-20230513-training": "2024-03-10-21-28-33",
                "longeval-long-september-20230513-training": "2024-03-10-21-32-14",
                "longeval-train-20230513-training": "2024-03-10-21-39-04",
                "clueweb09-en-trec-web-2009-20230107-training": "2024-03-10-19-36-04",
                "clueweb09-en-trec-web-2010-20230107-training": "2024-03-10-19-39-29",
                "clueweb09-en-trec-web-2011-20230107-training": "2024-03-10-19-42-56",
                "clueweb09-en-trec-web-2012-20230107-training": "2024-03-10-19-46-08",
                "clueweb12-touche-2020-task-2-20230209-training": "2024-03-10-20-10-08",
                "clueweb12-touche-2021-task-2-20230209-training": "2024-03-10-20-13-30",
                "clueweb12-trec-misinfo-2019-20240214-training": "2024-03-10-20-17-02",
                "clueweb12-trec-web-2013-20230107-training": "2024-03-10-19-49-33",
                "clueweb12-trec-web-2014-20230107-training": "2024-03-10-19-53-03",
                "gov-trec-web-2002-20230209-training": "2024-03-10-20-36-15",
                "gov-trec-web-2003-20230209-training": "2024-03-10-20-39-59",
                "gov-trec-web-2004-20230209-training": "2024-03-10-20-43-27",
                "gov2-trec-tb-2004-20230209-training": "2024-03-10-20-46-40",
                "gov2-trec-tb-2005-20230209-training": "2024-03-10-20-49-59",
                "gov2-trec-tb-2006-20230209-training": "2024-03-10-20-53-41",
                "wapo-v2-trec-core-2018-20230107-training": "2024-03-10-21-24-53",
                "disks45-nocr-trec8-20230209-training": "2024-03-10-20-32-47",
                "disks45-nocr-trec7-20230209-training": "2024-03-10-20-29-11",
                "disks45-nocr-trec-robust-2004-20230209-training": "2024-03-10-19-56-39",
            },
        },
    }
}


class TestRedirects(unittest.TestCase):
    """
    def test_approve_all_redirects(self):
        softwareto_approve = sorted(['ir-benchmarks/tira-ir-starter/Index (tira-ir-starter-pyterrier)'])
        datasets_to_approve = sorted([
            'msmarco-passage-trec-dl-2019-judged-20230107-training',
            'msmarco-passage-trec-dl-2020-judged-20230107-training',
            'antique-test-20230107-training', 'vaswani-20230107-training',
            'cranfield-20230107-training', 'medline-2004-trec-genomics-2004-20230107-training',
            'medline-2017-trec-pm-2017-20230211-training', 'cord19-fulltext-trec-covid-20230107-training',
            'nfcorpus-test-20230107-training', 'argsme-touche-2020-task-1-20230209-training',
            'argsme-touche-2021-task-1-20230209-training', 'medline-2017-trec-pm-2018-20230211-training',
            'medline-2004-trec-genomics-2005-20230107-training', 'trec-tip-of-the-tongue-dev-20230607-training',
            'longeval-short-july-20230513-training', 'longeval-heldout-20230513-training',
            'longeval-long-september-20230513-training', 'longeval-train-20230513-training'
        ])
        tira = Client()

        ret = {}
        for software in softwareto_approve:
            ret[software] = {}
            for dataset in datasets_to_approve:
                task, team, system = software.split('/')
                filename = f"{RUN_IDS[task][team][system][dataset]}.zip"
                run_url = f'https://www.tira.io/task/{task}/user/{team}/dataset/{dataset}/download/{filename}'
                ret[software][dataset] = {
                    'redirect_url': redirects(software, dataset),
                    'run_execution': tira.get_run_execution_or_none(software, dataset),
                    'run_url': run_url,
                    'redirected_run_url': redirects(url=run_url),
                    'md5_of_first_kilobyte': md5_of_first_kilobyte_of_http_resource(redirects(url=run_url)['url'])
                }

        verify_as_json(ret)
    """

    def test_redirects_in_incubator(self):
        return
        softwareto_approve = sorted(
            [
                "ir-benchmarks/salamander/classify-comparative-queries",
                "ir-benchmarks/qpptk/all-predictors",
                "ir-benchmarks/ows/query-segmentation-hyb-a",
                "ir-benchmarks/dossier/pre-retrieval-query-intent",
                "ir-benchmarks/tu-dresden-03/qe-gpt3.5-sq-zs",
                "ir-benchmarks/tu-dresden-03/qe-gpt3.5-cot",
                "ir-benchmarks/tu-dresden-03/qe-gpt3.5-sq-fs",
                "ir-benchmarks/tu-dresden-03/qe-llama-sq-zs",
                "ir-benchmarks/tu-dresden-03/qe-llama-sq-fs",
                "ir-benchmarks/tu-dresden-03/qe-llama-cot",
                "ir-benchmarks/tu-dresden-03/qe-flan-ul2-sq-zs",
                "ir-benchmarks/tu-dresden-03/qe-flan-ul2-sq-fs",
                "ir-benchmarks/tu-dresden-03/qe-flan-ul2-cot",
                "ir-benchmarks/seanmacavaney/DocT5Query",
                "ir-benchmarks/seanmacavaney/corpus-graph",
                "ir-benchmarks/marcel-gohsen/entity-linking",
                "ir-benchmarks/marcel-gohsen/query-interpretation",
                # 'workshop-on-open-web-search/tu-dresden-01/genre-mlp',
                # 'workshop-on-open-web-search/tu-dresden-04/textstat-document-features',
                # 'workshop-on-open-web-search/tu-dresden-04/spacy-document-features',
                # 'ir-benchmarks/tira-ir-starter/BM25 Re-Rank (tira-ir-starter-pyterrier)',
                # 'ir-benchmarks/tira-ir-starter/LGD Re-Rank (tira-ir-starter-pyterrier)',
                # 'ir-benchmarks/tira-ir-starter/PL2 Re-Rank (tira-ir-starter-pyterrier)',
                # 'ir-benchmarks/tira-ir-starter/Hiemstra_LM Re-Rank (tira-ir-starter-pyterrier)',
                # 'ir-benchmarks/tira-ir-starter/DirichletLM Re-Rank (tira-ir-starter-pyterrier)',
                # 'SBERT multi-qa-MiniLM-L6-dot-v1 (tira-ir-starter-beir)',
                # 'ColBERT Re-Rank (tira-ir-starter-pyterrier)',
                # 'ANCE Base Cosine (tira-ir-starter-beir)',
                # 'MonoT5 Base (tira-ir-starter-gygaggle)',
                # 'SBERT multi-qa-mpnet-base-cos-v1 (tira-ir-starter-beir)',
            ]
        )
        datasets_to_approve = sorted(
            [
                "msmarco-passage-trec-dl-2019-judged-20230107-training",
                "msmarco-passage-trec-dl-2020-judged-20230107-training",
                "antique-test-20230107-training",
                "vaswani-20230107-training",
                "cranfield-20230107-training",
                "medline-2004-trec-genomics-2004-20230107-training",
                "medline-2017-trec-pm-2017-20230211-training",
                "cord19-fulltext-trec-covid-20230107-training",
                "nfcorpus-test-20230107-training",
                "argsme-touche-2020-task-1-20230209-training",
                "argsme-touche-2021-task-1-20230209-training",
                "medline-2017-trec-pm-2018-20230211-training",
                "medline-2004-trec-genomics-2005-20230107-training",
                "trec-tip-of-the-tongue-dev-20230607-training",
                "longeval-short-july-20230513-training",
                "longeval-heldout-20230513-training",
                "longeval-long-september-20230513-training",
                "longeval-train-20230513-training",
            ]
        )
        tira = Client()

        ret = {}
        for software in softwareto_approve:
            ret[software] = {}
            for dataset in datasets_to_approve:
                task, team, system = software.split("/")
                if dataset not in RUN_IDS[task][team][system]:
                    continue

                filename = f"{RUN_IDS[task][team][system][dataset]}.zip"
                run_url = f"https://www.tira.io/task/{task}/user/{team}/dataset/{dataset}/download/{filename}"
                redirected_run_url = redirects(url=run_url)["urls"][0]
                # if not redirected_run_url.startswith('https://files.'):
                #    continue

                ret[software][dataset] = {
                    "redirect_url": redirects(software, dataset),
                    "run_execution": tira.get_run_execution_or_none(software, dataset),
                    "run_url": run_url,
                    "redirected_run_url": redirected_run_url,
                    "md5_of_first_kilobyte": md5_of_first_kilobyte_of_http_resource(redirects(url=run_url)["urls"][0]),
                }

        verify_as_json(ret)

    def test_mirrors_for_zenodo(self):
        softwareto_approve = sorted(["ir-benchmarks/tira-ir-starter/Index (tira-ir-starter-pyterrier)"])
        datasets_to_approve = sorted(
            [
                "msmarco-passage-trec-dl-2019-judged-20230107-training",
                "msmarco-passage-trec-dl-2020-judged-20230107-training",
                "antique-test-20230107-training",
                "vaswani-20230107-training",
                "cranfield-20230107-training",
                "medline-2004-trec-genomics-2004-20230107-training",
                "medline-2017-trec-pm-2017-20230211-training",
                "cord19-fulltext-trec-covid-20230107-training",
                "nfcorpus-test-20230107-training",
                "argsme-touche-2020-task-1-20230209-training",
                "argsme-touche-2021-task-1-20230209-training",
                "medline-2017-trec-pm-2018-20230211-training",
                "medline-2004-trec-genomics-2005-20230107-training",
                "trec-tip-of-the-tongue-dev-20230607-training",
                "longeval-short-july-20230513-training",
                "longeval-heldout-20230513-training",
                "longeval-long-september-20230513-training",
                "longeval-train-20230513-training",
            ]
        )

        ret = {}
        for software in softwareto_approve:
            for dataset in datasets_to_approve:
                task, team, system = software.split("/")
                filename = f"{RUN_IDS[task][team][system][dataset]}.zip"
                run_url = f"https://www.tira.io/task/{task}/user/{team}/dataset/{dataset}/download/{filename}"
                run_url = redirects(url=run_url)["urls"][0]
                ret[run_url] = mirror_url(run_url)

        verify_as_json(ret)
