# k8s-utils

A collection of Kubernetes command-line utilities built with Python and Typer.

## Installation

This project uses [uv](https://github.com/astral-sh/uv) for package management.

```bash
# Install dependencies
uv sync

# Run commands
uv run k8stools <command> [args]
```

Alternatively, install the package to use it without the `uv run` prefix:

```bash
uv pip install -e .
k8stools <command> [args]
```

## Commands

### podcount

Count non-daemonset pods per node in the current Kubernetes context.

```bash
# Use current context
uv run k8stools podcount

# Specify a different context
uv run k8stools podcount --context my-context
```

This command:
- Retrieves all pods and nodes in the cluster
- Excludes pods managed by DaemonSets
- Displays a table showing pod count per node
- Shows total non-DaemonSet pod count

**Example output:**

```
Fetching pods...
Fetching nodes...

3
 Node                 Pod Count 
!G)
 node-1                      12 
 node-2                       8 
 node-3                      15 
                     4           

Total non-DaemonSet pods: 35
```

## Development

The project structure:

```
k8s-utils/
   k8s_utils/
      __init__.py
      main.py              # CLI entry point
      commands/
          __init__.py
          podcount.py      # podcount command implementation
   pyproject.toml
   README.md
```

To add a new command:

1. Create a new file in `k8s_utils/commands/` (e.g., `mycommand.py`)
2. Implement your command as a function with Typer annotations
3. Import and register it in `k8s_utils/main.py`:

```python
from k8s_utils.commands import mycommand

app.command(name="mycommand")(mycommand.mycommand)
```

## Requirements

- Python 3.13+
- Access to a Kubernetes cluster with a valid kubeconfig
- uv package manager
