# System Architecture Visualization

## High-Level Flow

```
┌─────────────────────────────────────────────────────────────────────┐
│                         USER INPUT                                  │
├─────────────────────────────────────────────────────────────────────┤
│  1. Data Source:    CSV, NetCDF, GeoJSON, DataFrame, API, etc.     │
│  2. Description:    "Show temperature trends over time"             │
│  3. Context:        {"domain": "oceanography", "purpose": "..."}    │
└────────────────────────────┬────────────────────────────────────────┘
                             │
                             ▼
┌─────────────────────────────────────────────────────────────────────┐
│                    PREPROCESSING LAYER                              │
├─────────────────────────────────────────────────────────────────────┤
│                                                                     │
│  ┌──────────────────────────────────────────────────────────┐      │
│  │  Step 1: Format Detection & Extraction                   │      │
│  ├──────────────────────────────────────────────────────────┤      │
│  │                                                           │      │
│  │  ┌─────────────┐  ┌─────────────┐  ┌─────────────┐      │      │
│  │  │ DataFrame   │  │   NetCDF    │  │  GeoJSON    │      │      │
│  │  │ Extractor   │  │  Extractor  │  │  Extractor  │ ...  │      │
│  │  └──────┬──────┘  └──────┬──────┘  └──────┬──────┘      │      │
│  │         │                │                │              │      │
│  │         └────────────────┼────────────────┘              │      │
│  │                          ▼                                │      │
│  │              ┌─────────────────────────┐                 │      │
│  │              │  Format-Specific Parse  │                 │      │
│  │              │  - Read structure       │                 │      │
│  │              │  - Extract columns      │                 │      │
│  │              │  - Detect dimensions    │                 │      │
│  │              └───────────┬─────────────┘                 │      │
│  └──────────────────────────┼─────────────────────────────────┘      │
│                             ▼                                       │
│  ┌──────────────────────────────────────────────────────────┐      │
│  │  Step 2: Statistical Analysis                            │      │
│  ├──────────────────────────────────────────────────────────┤      │
│  │                                                           │      │
│  │  For each column:                                         │      │
│  │  ┌─────────────────────────────────────────────┐         │      │
│  │  │ • Compute statistics (min/max/mean/std)     │         │      │
│  │  │ • Count missing values                      │         │      │
│  │  │ • Detect cardinality                        │         │      │
│  │  │ • Identify temporal patterns                │         │      │
│  │  │ • Recognize geospatial coordinates          │         │      │
│  │  └─────────────────────────────────────────────┘         │      │
│  │                          ▼                                │      │
│  │              ┌─────────────────────────┐                 │      │
│  │              │   Base DataProfile      │                 │      │
│  │              │   (Structural Info)     │                 │      │
│  │              └───────────┬─────────────┘                 │      │
│  └──────────────────────────┼─────────────────────────────────┘      │
│                             ▼                                       │
│  ┌──────────────────────────────────────────────────────────┐      │
│  │  Step 3: LLM Augmentation (Optional)                     │      │
│  ├──────────────────────────────────────────────────────────┤      │
│  │                                                           │      │
│  │  Input: Base profile + User context                      │      │
│  │         ┌─────────────────────────────┐                  │      │
│  │         │ • Column types & statistics │                  │      │
│  │         │ • Sample records            │                  │      │
│  │         │ • User domain/purpose       │                  │      │
│  │         └────────────┬────────────────┘                  │      │
│  │                      ▼                                    │      │
│  │         ┌────────────────────────────┐                   │      │
│  │         │   Claude API (Sonnet 4)    │                   │      │
│  │         │                            │                   │      │
│  │         │  Analyze → Infer → Suggest │                   │      │
│  │         └────────────┬───────────────┘                   │      │
│  │                      ▼                                    │      │
│  │  Output: Augmented profile                               │      │
│  │         ┌─────────────────────────────┐                  │      │
│  │         │ • Inferred domain           │                  │      │
│  │         │ • Dataset purpose           │                  │      │
│  │         │ • Column meanings           │                  │      │
│  │         │ • Key insights              │                  │      │
│  │         │ • Visualization suggestions │                  │      │
│  │         │ • Quality issues            │                  │      │
│  │         └────────────┬────────────────┘                  │      │
│  └──────────────────────┼─────────────────────────────────────┘      │
│                         ▼                                           │
│              ┌─────────────────────────┐                           │
│              │   Complete DataProfile   │                           │
│              │  (Ready for Widget Gen) │                           │
│              └───────────┬─────────────┘                           │
└──────────────────────────┼─────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────────────┐
│                   PROFILE RENDERING                                 │
├─────────────────────────────────────────────────────────────────────┤
│                                                                     │
│  Profile → Markdown → Token-optimized context for next stage       │
│                                                                     │
│  Example Output:                                                    │
│  ┌───────────────────────────────────────────────────────┐         │
│  │ # Dataset Profile: NetCDF                             │         │
│  │                                                        │         │
│  │ Domain: Oceanography                                  │         │
│  │ Purpose: Track sea surface temperature for coral      │         │
│  │          bleaching monitoring                         │         │
│  │                                                        │         │
│  │ ## Fields                                              │         │
│  │ - sst (numeric): Sea Surface Temperature              │         │
│  │   Range: [18.5°C, 32.1°C]                            │         │
│  │   Temporal: Daily, 2021-2023                         │         │
│  │   Spatial: 50×100 grid (tropical band)               │         │
│  │                                                        │         │
│  │ ## Suggested Visualizations                           │         │
│  │ - Heatmap with time slider                           │         │
│  │ - Temperature anomaly map                            │         │
│  │ - Time series at key locations                       │         │
│  └───────────────────────────────────────────────────────┘         │
│                             ▼                                       │
└─────────────────────────────────────────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────────┐
│                   WIDGET GENERATION                                 │
├─────────────────────────────────────────────────────────────────────┤
│                                                                     │
│  Input: User description + Rich profile + Data                     │
│                                                                     │
│  ┌──────────────────────────────────────────────────────────┐      │
│  │  Enhanced Prompt Construction                            │      │
│  ├──────────────────────────────────────────────────────────┤      │
│  │                                                           │      │
│  │  "Create interactive ocean temp monitoring dashboard.    │      │
│  │                                                           │      │
│  │  Domain: Oceanography                                    │      │
│  │  Data: NetCDF, 50×100×1096 (lat×lon×time)               │      │
│  │  Variables: SST, bleaching_alert, climatology            │      │
│  │  Temporal: Daily 2021-2023                               │      │
│  │                                                           │      │
│  │  Key insights:                                            │      │
│  │  - Seasonal cycle detected (±2°C amplitude)             │      │
│  │  - Warming trend +0.06°C/year                           │      │
│  │  - El Niño signal in 2023                               │      │
│  │                                                           │      │
│  │  Suggested approach:                                      │      │
│  │  - Geographic heatmap (lat/lon)                          │      │
│  │  - Time slider for temporal exploration                  │      │
│  │  - Highlight bleaching threshold exceedances            │      │
│  │  - Show climatology baseline                            │"      │
│  │                                                           │      │
│  └──────────────────────────┬───────────────────────────────┘      │
│                             ▼                                       │
│                  ┌──────────────────────┐                          │
│                  │   Claude API         │                          │
│                  │   (Code Generation)  │                          │
│                  └──────────┬───────────┘                          │
│                             ▼                                       │
│  ┌──────────────────────────────────────────────────────────┐      │
│  │  Generated JavaScript Widget (Anywidget AFM)             │      │
│  ├──────────────────────────────────────────────────────────┤      │
│  │                                                           │      │
│  │  import * as d3 from "https://esm.sh/d3@7";             │      │
│  │                                                           │      │
│  │  function render({ model, el }) {                        │      │
│  │    const data = model.get("data");                       │      │
│  │                                                           │      │
│  │    // Create heatmap                                     │      │
│  │    const svg = d3.select(el).append("svg");              │      │
│  │                                                           │      │
│  │    // Add time slider                                    │      │
│  │    const slider = createTimeSlider(...);                 │      │
│  │                                                           │      │
│  │    // Render temperature heatmap                         │      │
│  │    updateHeatmap(data, currentTime);                     │      │
│  │                                                           │      │
│  │    // Highlight bleaching events                         │      │
│  │    markBleachingAreas(...);                              │      │
│  │  }                                                        │      │
│  │                                                           │      │
│  │  export default { render };                              │      │
│  │                                                           │      │
│  └──────────────────────────┬───────────────────────────────┘      │
└─────────────────────────────┼─────────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────────┐
│                        OUTPUT                                       │
├─────────────────────────────────────────────────────────────────────┤
│                                                                     │
│  ┌────────────────────────────────────────────────────┐            │
│  │          Interactive Widget (Anywidget)            │            │
│  │  ┌──────────────────────────────────────────────┐  │            │
│  │  │                                              │  │            │
│  │  │   🗺️  Ocean Temperature Heatmap              │  │            │
│  │  │                                              │  │            │
│  │  │   [============================] Time        │  │            │
│  │  │    2021                      2023            │  │            │
│  │  │                                              │  │            │
│  │  │   ⚠️ Bleaching events highlighted in red    │  │            │
│  │  │   📊 Climatology baseline overlay           │  │            │
│  │  │   🔍 Click any point for details            │  │            │
│  │  │                                              │  │            │
│  │  └──────────────────────────────────────────────┘  │            │
│  │                                                     │            │
│  │  ✅ Domain-aware: Oceanography-specific features   │            │
│  │  ✅ Context-rich: Shows insights from profile      │            │
│  │  ✅ Interactive: Temporal + spatial exploration    │            │
│  └────────────────────────────────────────────────────┘            │
│                                                                     │
└─────────────────────────────────────────────────────────────────────┘
```

## Data Flow Detail

```
User Data
   │
   ├─> CSV ──────────┐
   │                 │
   ├─> NetCDF ───────┤
   │                 │
   ├─> GeoJSON ──────┤──> Extractor Selection
   │                 │     (can_handle check)
   ├─> API JSON ─────┤
   │                 │
   └─> DataFrame ────┘
                      │
                      ▼
              ┌──────────────┐
              │  Extraction  │
              └──────┬───────┘
                     │
        ┌────────────┼────────────┐
        ▼            ▼            ▼
   Structure    Statistics    Patterns
   (shape,      (min/max,     (timeseries,
    columns)     mean/std)     geospatial)
        │            │            │
        └────────────┼────────────┘
                     ▼
              DataProfile (Base)
                     │
              ┌──────┴──────┐
              │             │
              ▼             ▼
         Save Cache    LLM Augment
        (optional)      (optional)
                            │
                            ▼
              ┌──────────────────────┐
              │  Domain Inference    │
              │  Column Meanings     │
              │  Key Insights        │
              │  Viz Suggestions     │
              └──────┬───────────────┘
                     ▼
              DataProfile (Complete)
                     │
              ┌──────┴──────┐
              │             │
              ▼             ▼
        to_markdown()  to_dict()
              │             │
              ▼             ▼
        LLM Context    Cache/Export
              │
              ▼
        Widget Generator
              │
              ▼
        JavaScript Code
              │
              ▼
        Anywidget Render
```

## Component Interaction

```
┌────────────────────────────────────────────────────────────┐
│                      User Code                             │
│                                                            │
│  widget = create("plot temp", "data.nc",                  │
│                  context={"domain": "ocean"})             │
│                                                            │
└─────────┬──────────────────────────────────────────────────┘
          │
          ▼
┌─────────────────────────────────────────────────────────────┐
│                  Core API (core.py)                         │
│  ┌──────────────────────────────────────────────────────┐   │
│  │ • Parse arguments                                    │   │
│  │ • Detect file vs DataFrame                          │   │
│  │ • Route to preprocessor if needed                   │   │
│  └──────────────────┬───────────────────────────────────┘   │
└────────────────────┼─────────────────────────────────────────┘
                     │
        ┌────────────┴────────────┐
        │                         │
        ▼                         ▼
┌─────────────────┐      ┌──────────────────┐
│  Preprocessor   │      │  Direct to       │
│  (complex data) │      │  Widget (simple) │
└────────┬────────┘      └────────┬─────────┘
         │                        │
         ▼                        │
┌─────────────────┐               │
│   Extractors    │               │
│ ┌─────────────┐ │               │
│ │ DataFrame   │ │               │
│ │ NetCDF      │ │               │
│ │ GeoJSON     │ │               │
│ │ CSV         │ │               │
│ │ API         │ │               │
│ └─────┬───────┘ │               │
└───────┼─────────┘               │
        │                         │
        ▼                         │
┌──────────────────┐              │
│  DataProfile     │              │
│  - Structure     │              │
│  - Statistics    │              │
│  - Insights      │              │
└────────┬─────────┘              │
         │                        │
         ▼                        │
┌──────────────────┐              │
│  LLM Augmenter   │              │
│  (Claude API)    │              │
└────────┬─────────┘              │
         │                        │
         └────────────┬───────────┘
                      │
                      ▼
             ┌────────────────────┐
             │  Widget Generator  │
             │  (Claude API)      │
             └─────────┬──────────┘
                       │
                       ▼
             ┌────────────────────┐
             │  JavaScript Code   │
             └─────────┬──────────┘
                       │
                       ▼
             ┌────────────────────┐
             │  Anywidget Wrapper │
             └─────────┬──────────┘
                       │
                       ▼
             ┌────────────────────┐
             │  Rendered Widget   │
             │  (In Notebook)     │
             └────────────────────┘
```

## Token Flow (LLM Context)

```
Stage 1: Profile Extraction
────────────────────────────
Input Tokens:  ~0 (no LLM)
Output:        DataProfile (Python object)

Stage 2: Profile Augmentation
──────────────────────────────
Input Tokens:  ~1,000
  - Profile structure: 400 tokens
  - Column details: 400 tokens  
  - Sample data: 200 tokens
Output Tokens: ~500
  - Domain: 50 tokens
  - Insights: 200 tokens
  - Viz suggestions: 150 tokens
  - Column meanings: 100 tokens

Stage 3: Widget Generation
───────────────────────────
Input Tokens:  ~2,000
  - Augmented profile: 1,000 tokens
  - User description: 100 tokens
  - Widget spec: 500 tokens
  - Examples: 400 tokens
Output Tokens: ~1,500
  - JavaScript code: 1,200 tokens
  - Comments: 300 tokens

Total: ~3,000 input + ~2,000 output = ~5,000 tokens per widget
Cost: ~$0.02 per widget (Sonnet 4.5 pricing)
```

## Cache Strategy

```
┌─────────────────────────────────────────────────────────┐
│                    Cache Layers                         │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  Layer 1: Profile Extraction Cache                      │
│  ┌───────────────────────────────────────────────┐     │
│  │ Key: hash(file_path + modification_time)      │     │
│  │ Value: Base DataProfile (no LLM)              │     │
│  │ TTL: Until file changes                       │     │
│  │ Hit Rate: ~80% for repeated analysis          │     │
│  └───────────────────────────────────────────────┘     │
│                                                         │
│  Layer 2: Augmented Profile Cache                      │
│  ┌───────────────────────────────────────────────┐     │
│  │ Key: hash(base_profile + context)             │     │
│  │ Value: Augmented DataProfile                  │     │
│  │ TTL: 24 hours (insights may evolve)           │     │
│  │ Savings: ~$0.01 per cache hit                 │     │
│  └───────────────────────────────────────────────┘     │
│                                                         │
│  Layer 3: Widget Code Cache                            │
│  ┌───────────────────────────────────────────────┐     │
│  │ Key: hash(description + profile + data_hash)  │     │
│  │ Value: Generated JavaScript code              │     │
│  │ TTL: 1 hour (allow experimentation)           │     │
│  │ Savings: ~$0.015 per cache hit                │     │
│  └───────────────────────────────────────────────┘     │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

This architecture enables:
- ✅ **Separation of concerns**: Each layer has clear responsibility
- ✅ **Extensibility**: Add extractors without touching core
- ✅ **Testability**: Each component independently testable
- ✅ **Performance**: Caching at multiple levels
- ✅ **Cost efficiency**: Token optimization throughout