#!/usr/bin/env python3
"""
Test script for the React Grab component selection feature
"""

import pandas as pd
from vibe_widget import VibeWidget
import time

# Create sample data
df = pd.DataFrame({
    'x': [1, 2, 3, 4, 5],
    'y': [10, 20, 15, 25, 30],
    'category': ['A', 'B', 'A', 'B', 'A']
})

# Create a widget with a brushable scatterplot
widget = VibeWidget(
    "Create a brushable scatterplot with x and y axes, colored by category",
    df,
    api_key=None  # Add your API key here
)

print(f"Widget ID: {widget.widget_id}")
print("\nInstructions:")
print("1. Click the white/black floating menu dot in the top right")
print("2. Select '🎯 Grab Component'")
print("3. Hover over the widget - inspector only works within widget bounds")
print("4. Click on any element in the visualization")
print("5. The element will be highlighted with an orange border and labeled")
print("6. The component reference will be copied to clipboard")
print("\nCheck browser console for debug information")
print("\nAfter selecting a component, try these commands:")
print("  widget.grabbed_component  # View last grabbed component data")
print("  widget.selected_components  # View all selected components")
print("  widget.get_component()  # Get last grabbed component")
print("  widget.get_component_state()  # Get component state")
print("  widget.get_component_reference()  # Get reference string")
print("  widget.clear_selections()  # Clear all selections")

# Display the widget (in Jupyter notebook)
# widget