from enum import StrEnum
from typing import TypeVar
from nexo.types.string import ListOfStrs


class Granularity(StrEnum):
    STANDARD = "standard"
    FULL = "full"

    @classmethod
    def choices(cls) -> ListOfStrs:
        return [e.value for e in cls]


class IdentifierType(StrEnum):
    ID = "id"
    UUID = "uuid"

    @classmethod
    def choices(cls) -> ListOfStrs:
        return [e.value for e in cls]

    @property
    def column(self) -> str:
        return self.value


class CheckupStatus(StrEnum):
    DRAFT = "draft"
    ONGOING = "ongoing"
    REVIEWED = "reviewed"
    APPROVED = "approved"

    @classmethod
    def choices(cls) -> ListOfStrs:
        return [e.value for e in cls]


OptCheckupStatus = CheckupStatus | None
OptCheckupStatusT = TypeVar("OptCheckupStatusT", bound=OptCheckupStatus)
ListOfCheckupStatuses = list[CheckupStatus]
OptListOfCheckupStatuses = ListOfCheckupStatuses | None
OptListOfCheckupStatusesT = TypeVar(
    "OptListOfCheckupStatusesT", bound=OptListOfCheckupStatuses
)
