# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAlarmsResult',
    'AwaitableGetAlarmsResult',
    'get_alarms',
    'get_alarms_output',
]

@pulumi.output_type
class GetAlarmsResult:
    """
    A collection of values returned by getAlarms.
    """
    def __init__(__self__, alarms=None, id=None, instance_id=None, type=None):
        if alarms and not isinstance(alarms, list):
            raise TypeError("Expected argument 'alarms' to be a list")
        pulumi.set(__self__, "alarms", alarms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, int):
            raise TypeError("Expected argument 'instance_id' to be a int")
        pulumi.set(__self__, "instance_id", instance_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def alarms(self) -> Sequence['outputs.GetAlarmsAlarmResult']:
        """
        List of alarms (see below for nested schema)
        """
        return pulumi.get(self, "alarms")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.int:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the alarm.
        """
        return pulumi.get(self, "type")


class AwaitableGetAlarmsResult(GetAlarmsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmsResult(
            alarms=self.alarms,
            id=self.id,
            instance_id=self.instance_id,
            type=self.type)


def get_alarms(instance_id: Optional[_builtins.int] = None,
               type: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmsResult:
    """
    Use this data source to retrieve a list of default or created alarms.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    queue_alarms = cloudamqp.get_alarms(instance_id=instance["id"],
        type="queue")
    ```

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

    ## Alarm Types

    `cpu, memory, disk, queue, connection, flow, consumer, netsplit, server_unreachable, notice`


    :param _builtins.int instance_id: The CloudAMQP instance identifier.
    :param _builtins.str type: The alarm type to filter for. Supported
           alarm types.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudamqp:index/getAlarms:getAlarms', __args__, opts=opts, typ=GetAlarmsResult).value

    return AwaitableGetAlarmsResult(
        alarms=pulumi.get(__ret__, 'alarms'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        type=pulumi.get(__ret__, 'type'))
def get_alarms_output(instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                      type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlarmsResult]:
    """
    Use this data source to retrieve a list of default or created alarms.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudamqp as cloudamqp

    queue_alarms = cloudamqp.get_alarms(instance_id=instance["id"],
        type="queue")
    ```

    ## Dependency

    This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

    ## Alarm Types

    `cpu, memory, disk, queue, connection, flow, consumer, netsplit, server_unreachable, notice`


    :param _builtins.int instance_id: The CloudAMQP instance identifier.
    :param _builtins.str type: The alarm type to filter for. Supported
           alarm types.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudamqp:index/getAlarms:getAlarms', __args__, opts=opts, typ=GetAlarmsResult)
    return __ret__.apply(lambda __response__: GetAlarmsResult(
        alarms=pulumi.get(__response__, 'alarms'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        type=pulumi.get(__response__, 'type')))
