# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from increase import Increase, AsyncIncrease
from tests.utils import assert_matches_type
from increase.types import OAuthApplication
from increase._utils import parse_datetime
from increase.pagination import SyncPage, AsyncPage

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestOAuthApplications:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_retrieve(self, client: Increase) -> None:
        oauth_application = client.oauth_applications.retrieve(
            "application_gj9ufmpgh5i56k4vyriy",
        )
        assert_matches_type(OAuthApplication, oauth_application, path=["response"])

    @parametrize
    def test_raw_response_retrieve(self, client: Increase) -> None:
        response = client.oauth_applications.with_raw_response.retrieve(
            "application_gj9ufmpgh5i56k4vyriy",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        oauth_application = response.parse()
        assert_matches_type(OAuthApplication, oauth_application, path=["response"])

    @parametrize
    def test_streaming_response_retrieve(self, client: Increase) -> None:
        with client.oauth_applications.with_streaming_response.retrieve(
            "application_gj9ufmpgh5i56k4vyriy",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            oauth_application = response.parse()
            assert_matches_type(OAuthApplication, oauth_application, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_retrieve(self, client: Increase) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `oauth_application_id` but received ''"):
            client.oauth_applications.with_raw_response.retrieve(
                "",
            )

    @parametrize
    def test_method_list(self, client: Increase) -> None:
        oauth_application = client.oauth_applications.list()
        assert_matches_type(SyncPage[OAuthApplication], oauth_application, path=["response"])

    @parametrize
    def test_method_list_with_all_params(self, client: Increase) -> None:
        oauth_application = client.oauth_applications.list(
            created_at={
                "after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "before": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_before": parse_datetime("2019-12-27T18:11:19.117Z"),
            },
            cursor="cursor",
            limit=1,
            status={"in": ["active"]},
        )
        assert_matches_type(SyncPage[OAuthApplication], oauth_application, path=["response"])

    @parametrize
    def test_raw_response_list(self, client: Increase) -> None:
        response = client.oauth_applications.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        oauth_application = response.parse()
        assert_matches_type(SyncPage[OAuthApplication], oauth_application, path=["response"])

    @parametrize
    def test_streaming_response_list(self, client: Increase) -> None:
        with client.oauth_applications.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            oauth_application = response.parse()
            assert_matches_type(SyncPage[OAuthApplication], oauth_application, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncOAuthApplications:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @parametrize
    async def test_method_retrieve(self, async_client: AsyncIncrease) -> None:
        oauth_application = await async_client.oauth_applications.retrieve(
            "application_gj9ufmpgh5i56k4vyriy",
        )
        assert_matches_type(OAuthApplication, oauth_application, path=["response"])

    @parametrize
    async def test_raw_response_retrieve(self, async_client: AsyncIncrease) -> None:
        response = await async_client.oauth_applications.with_raw_response.retrieve(
            "application_gj9ufmpgh5i56k4vyriy",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        oauth_application = await response.parse()
        assert_matches_type(OAuthApplication, oauth_application, path=["response"])

    @parametrize
    async def test_streaming_response_retrieve(self, async_client: AsyncIncrease) -> None:
        async with async_client.oauth_applications.with_streaming_response.retrieve(
            "application_gj9ufmpgh5i56k4vyriy",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            oauth_application = await response.parse()
            assert_matches_type(OAuthApplication, oauth_application, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_retrieve(self, async_client: AsyncIncrease) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `oauth_application_id` but received ''"):
            await async_client.oauth_applications.with_raw_response.retrieve(
                "",
            )

    @parametrize
    async def test_method_list(self, async_client: AsyncIncrease) -> None:
        oauth_application = await async_client.oauth_applications.list()
        assert_matches_type(AsyncPage[OAuthApplication], oauth_application, path=["response"])

    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncIncrease) -> None:
        oauth_application = await async_client.oauth_applications.list(
            created_at={
                "after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "before": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_before": parse_datetime("2019-12-27T18:11:19.117Z"),
            },
            cursor="cursor",
            limit=1,
            status={"in": ["active"]},
        )
        assert_matches_type(AsyncPage[OAuthApplication], oauth_application, path=["response"])

    @parametrize
    async def test_raw_response_list(self, async_client: AsyncIncrease) -> None:
        response = await async_client.oauth_applications.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        oauth_application = await response.parse()
        assert_matches_type(AsyncPage[OAuthApplication], oauth_application, path=["response"])

    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncIncrease) -> None:
        async with async_client.oauth_applications.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            oauth_application = await response.parse()
            assert_matches_type(AsyncPage[OAuthApplication], oauth_application, path=["response"])

        assert cast(Any, response.is_closed) is True
