# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BudgetPolicyArgs', 'BudgetPolicy']

@pulumi.input_type
class BudgetPolicyArgs:
    def __init__(__self__, *,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BudgetPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]] custom_tags: A list of tags defined by the customer. At most 20 entries are allowed per policy.
        :param pulumi.Input[str] policy_name: The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]]]:
        """
        A list of tags defined by the customer. At most 20 entries are allowed per policy.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


@pulumi.input_type
class _BudgetPolicyState:
    def __init__(__self__, *,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BudgetPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]] custom_tags: A list of tags defined by the customer. At most 20 entries are allowed per policy.
        :param pulumi.Input[str] policy_id: ID of the budget policy
        :param pulumi.Input[str] policy_name: The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]]]:
        """
        A list of tags defined by the customer. At most 20 entries are allowed per policy.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPolicyCustomTagArgs']]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the budget policy
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


class BudgetPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetPolicyCustomTagArgs', 'BudgetPolicyCustomTagArgsDict']]]]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Administrators can use budget policies to ensure that the correct tags appear automatically on serverless resources without depending on users to attach tags manually, allowing for customized cost reporting and chargebacks. Budget policies consist of tags that are applied to any serverless compute activity incurred by a user assigned to the policy. The tags are logged in your billing records, allowing you to attribute serverless usage to specific budgets.

        > This resource can only be used with an account-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.BudgetPolicy("this",
            policy_name="my-budget-policy",
            custom_tags=[{
                "key": "mykey",
                "value": "myvalue",
            }])
        ```

        ## Access Control

        * AccessControlRuleSet can control which groups or individual users can manage or use the given budget policy.

        ## Import

        This resource can be imported by ID.

        ```sh
        $ pulumi import databricks:index/budgetPolicy:BudgetPolicy this policy_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BudgetPolicyCustomTagArgs', 'BudgetPolicyCustomTagArgsDict']]]] custom_tags: A list of tags defined by the customer. At most 20 entries are allowed per policy.
        :param pulumi.Input[str] policy_name: The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BudgetPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Administrators can use budget policies to ensure that the correct tags appear automatically on serverless resources without depending on users to attach tags manually, allowing for customized cost reporting and chargebacks. Budget policies consist of tags that are applied to any serverless compute activity incurred by a user assigned to the policy. The tags are logged in your billing records, allowing you to attribute serverless usage to specific budgets.

        > This resource can only be used with an account-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.BudgetPolicy("this",
            policy_name="my-budget-policy",
            custom_tags=[{
                "key": "mykey",
                "value": "myvalue",
            }])
        ```

        ## Access Control

        * AccessControlRuleSet can control which groups or individual users can manage or use the given budget policy.

        ## Import

        This resource can be imported by ID.

        ```sh
        $ pulumi import databricks:index/budgetPolicy:BudgetPolicy this policy_id
        ```

        :param str resource_name: The name of the resource.
        :param BudgetPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BudgetPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetPolicyCustomTagArgs', 'BudgetPolicyCustomTagArgsDict']]]]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BudgetPolicyArgs.__new__(BudgetPolicyArgs)

            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["policy_name"] = policy_name
            __props__.__dict__["policy_id"] = None
        super(BudgetPolicy, __self__).__init__(
            'databricks:index/budgetPolicy:BudgetPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetPolicyCustomTagArgs', 'BudgetPolicyCustomTagArgsDict']]]]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            policy_name: Optional[pulumi.Input[str]] = None) -> 'BudgetPolicy':
        """
        Get an existing BudgetPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BudgetPolicyCustomTagArgs', 'BudgetPolicyCustomTagArgsDict']]]] custom_tags: A list of tags defined by the customer. At most 20 entries are allowed per policy.
        :param pulumi.Input[str] policy_id: ID of the budget policy
        :param pulumi.Input[str] policy_name: The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BudgetPolicyState.__new__(_BudgetPolicyState)

        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["policy_name"] = policy_name
        return BudgetPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Sequence['outputs.BudgetPolicyCustomTag']]]:
        """
        A list of tags defined by the customer. At most 20 entries are allowed per policy.
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        ID of the budget policy
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the policy. Must be unique among active policies. Can contain only characters from the ISO 8859-1 (latin1) set.
        """
        return pulumi.get(self, "policy_name")

