# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    """
    A collection of values returned by getApp.
    """
    def __init__(__self__, app=None, id=None, name=None):
        if app and not isinstance(app, dict):
            raise TypeError("Expected argument 'app' to be a dict")
        pulumi.set(__self__, "app", app)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def app(self) -> 'outputs.GetAppAppResult':
        """
        attribute
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the serving endpoint to grant permission on.
        """
        return pulumi.get(self, "name")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            app=self.app,
            id=self.id,
            name=self.name)


def get_app(name: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    > This feature is in [Public Preview](https://docs.databricks.com/release-notes/release-types.html).

    [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html) run directly on a customer’s Databricks instance, integrate with their data, use and extend Databricks services, and enable users to interact through single sign-on. This resource creates the application but does not handle app deployment, which should be handled separately as part of your CI/CD pipeline.

    This data source allows you to fetch information about a Databricks App.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_app(name="my-custom-app")
    ```

    ## Related Resources

    The following resources are used in the same context:

    * App to manage [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html).
    * SqlEndpoint to manage Databricks SQL [Endpoints](https://docs.databricks.com/sql/admin/sql-endpoints.html).
    * ModelServing to serve this model on a Databricks serving endpoint.
    * Secret to manage [secrets](https://docs.databricks.com/security/secrets/index.html#secrets-user-guide) in Databricks workspace.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code.


    :param str name: The name of the app.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getApp:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        app=pulumi.get(__ret__, 'app'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_app_output(name: Optional[pulumi.Input[str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppResult]:
    """
    > This feature is in [Public Preview](https://docs.databricks.com/release-notes/release-types.html).

    [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html) run directly on a customer’s Databricks instance, integrate with their data, use and extend Databricks services, and enable users to interact through single sign-on. This resource creates the application but does not handle app deployment, which should be handled separately as part of your CI/CD pipeline.

    This data source allows you to fetch information about a Databricks App.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_app(name="my-custom-app")
    ```

    ## Related Resources

    The following resources are used in the same context:

    * App to manage [Databricks Apps](https://docs.databricks.com/en/dev-tools/databricks-apps/index.html).
    * SqlEndpoint to manage Databricks SQL [Endpoints](https://docs.databricks.com/sql/admin/sql-endpoints.html).
    * ModelServing to serve this model on a Databricks serving endpoint.
    * Secret to manage [secrets](https://docs.databricks.com/security/secrets/index.html#secrets-user-guide) in Databricks workspace.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code.


    :param str name: The name of the app.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getApp:getApp', __args__, opts=opts, typ=GetAppResult)
    return __ret__.apply(lambda __response__: GetAppResult(
        app=pulumi.get(__response__, 'app'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
