# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAwsBucketPolicyResult',
    'AwaitableGetAwsBucketPolicyResult',
    'get_aws_bucket_policy',
    'get_aws_bucket_policy_output',
]

@pulumi.output_type
class GetAwsBucketPolicyResult:
    """
    A collection of values returned by getAwsBucketPolicy.
    """
    def __init__(__self__, aws_partition=None, bucket=None, databricks_account_id=None, databricks_e2_account_id=None, full_access_role=None, id=None, json=None):
        if aws_partition and not isinstance(aws_partition, str):
            raise TypeError("Expected argument 'aws_partition' to be a str")
        pulumi.set(__self__, "aws_partition", aws_partition)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if databricks_account_id and not isinstance(databricks_account_id, str):
            raise TypeError("Expected argument 'databricks_account_id' to be a str")
        pulumi.set(__self__, "databricks_account_id", databricks_account_id)
        if databricks_e2_account_id and not isinstance(databricks_e2_account_id, str):
            raise TypeError("Expected argument 'databricks_e2_account_id' to be a str")
        pulumi.set(__self__, "databricks_e2_account_id", databricks_e2_account_id)
        if full_access_role and not isinstance(full_access_role, str):
            raise TypeError("Expected argument 'full_access_role' to be a str")
        pulumi.set(__self__, "full_access_role", full_access_role)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)

    @property
    @pulumi.getter(name="awsPartition")
    def aws_partition(self) -> Optional[str]:
        return pulumi.get(self, "aws_partition")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databricksAccountId")
    @_utilities.deprecated("""databricks_account_id will be will be removed in the next major release.""")
    def databricks_account_id(self) -> Optional[str]:
        return pulumi.get(self, "databricks_account_id")

    @property
    @pulumi.getter(name="databricksE2AccountId")
    def databricks_e2_account_id(self) -> Optional[str]:
        return pulumi.get(self, "databricks_e2_account_id")

    @property
    @pulumi.getter(name="fullAccessRole")
    def full_access_role(self) -> Optional[str]:
        return pulumi.get(self, "full_access_role")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        (Read-only) AWS IAM Policy JSON document to grant Databricks full access to bucket.
        """
        return pulumi.get(self, "json")


class AwaitableGetAwsBucketPolicyResult(GetAwsBucketPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsBucketPolicyResult(
            aws_partition=self.aws_partition,
            bucket=self.bucket,
            databricks_account_id=self.databricks_account_id,
            databricks_e2_account_id=self.databricks_e2_account_id,
            full_access_role=self.full_access_role,
            id=self.id,
            json=self.json)


def get_aws_bucket_policy(aws_partition: Optional[str] = None,
                          bucket: Optional[str] = None,
                          databricks_account_id: Optional[str] = None,
                          databricks_e2_account_id: Optional[str] = None,
                          full_access_role: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsBucketPolicyResult:
    """
    This datasource configures a simple access policy for AWS S3 buckets, so that Databricks can access data in it.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this_bucket_v2 = aws.s3.BucketV2("this",
        bucket="<unique_bucket_name>",
        force_destroy=True)
    this = databricks.get_aws_bucket_policy_output(bucket=this_bucket_v2.bucket)
    this_bucket_policy = aws.s3.BucketPolicy("this",
        bucket=this_bucket_v2.id,
        policy=this.json)
    ```

    Bucket policy with full access:


    :param str aws_partition: AWS partition. The options are `aws` or `aws-us-gov`. Defaults to `aws`
    :param str bucket: AWS S3 Bucket name for which to generate the policy document.
    :param str databricks_e2_account_id: Your Databricks account ID. Used to generate  restrictive IAM policies that will increase the security of your root bucket
    :param str full_access_role: Data access role that can have full access for this bucket
    """
    __args__ = dict()
    __args__['awsPartition'] = aws_partition
    __args__['bucket'] = bucket
    __args__['databricksAccountId'] = databricks_account_id
    __args__['databricksE2AccountId'] = databricks_e2_account_id
    __args__['fullAccessRole'] = full_access_role
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getAwsBucketPolicy:getAwsBucketPolicy', __args__, opts=opts, typ=GetAwsBucketPolicyResult).value

    return AwaitableGetAwsBucketPolicyResult(
        aws_partition=pulumi.get(__ret__, 'aws_partition'),
        bucket=pulumi.get(__ret__, 'bucket'),
        databricks_account_id=pulumi.get(__ret__, 'databricks_account_id'),
        databricks_e2_account_id=pulumi.get(__ret__, 'databricks_e2_account_id'),
        full_access_role=pulumi.get(__ret__, 'full_access_role'),
        id=pulumi.get(__ret__, 'id'),
        json=pulumi.get(__ret__, 'json'))
def get_aws_bucket_policy_output(aws_partition: Optional[pulumi.Input[Optional[str]]] = None,
                                 bucket: Optional[pulumi.Input[str]] = None,
                                 databricks_account_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 databricks_e2_account_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 full_access_role: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsBucketPolicyResult]:
    """
    This datasource configures a simple access policy for AWS S3 buckets, so that Databricks can access data in it.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this_bucket_v2 = aws.s3.BucketV2("this",
        bucket="<unique_bucket_name>",
        force_destroy=True)
    this = databricks.get_aws_bucket_policy_output(bucket=this_bucket_v2.bucket)
    this_bucket_policy = aws.s3.BucketPolicy("this",
        bucket=this_bucket_v2.id,
        policy=this.json)
    ```

    Bucket policy with full access:


    :param str aws_partition: AWS partition. The options are `aws` or `aws-us-gov`. Defaults to `aws`
    :param str bucket: AWS S3 Bucket name for which to generate the policy document.
    :param str databricks_e2_account_id: Your Databricks account ID. Used to generate  restrictive IAM policies that will increase the security of your root bucket
    :param str full_access_role: Data access role that can have full access for this bucket
    """
    __args__ = dict()
    __args__['awsPartition'] = aws_partition
    __args__['bucket'] = bucket
    __args__['databricksAccountId'] = databricks_account_id
    __args__['databricksE2AccountId'] = databricks_e2_account_id
    __args__['fullAccessRole'] = full_access_role
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getAwsBucketPolicy:getAwsBucketPolicy', __args__, opts=opts, typ=GetAwsBucketPolicyResult)
    return __ret__.apply(lambda __response__: GetAwsBucketPolicyResult(
        aws_partition=pulumi.get(__response__, 'aws_partition'),
        bucket=pulumi.get(__response__, 'bucket'),
        databricks_account_id=pulumi.get(__response__, 'databricks_account_id'),
        databricks_e2_account_id=pulumi.get(__response__, 'databricks_e2_account_id'),
        full_access_role=pulumi.get(__response__, 'full_access_role'),
        id=pulumi.get(__response__, 'id'),
        json=pulumi.get(__response__, 'json')))
