# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMetastoresResult',
    'AwaitableGetMetastoresResult',
    'get_metastores',
    'get_metastores_output',
]

@pulumi.output_type
class GetMetastoresResult:
    """
    A collection of values returned by getMetastores.
    """
    def __init__(__self__, id=None, ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, dict):
            raise TypeError("Expected argument 'ids' to be a dict")
        pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Mapping[str, str]:
        """
        Mapping of name to id of databricks_metastore
        """
        return pulumi.get(self, "ids")


class AwaitableGetMetastoresResult(GetMetastoresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetastoresResult(
            id=self.id,
            ids=self.ids)


def get_metastores(ids: Optional[Mapping[str, str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetastoresResult:
    """
    > **Note** This data source can only be used with an account-level provider!

    Retrieves a mapping of name to id of Metastore objects, that were created by Pulumi or manually, so that special handling could be applied.

    > **Note** `account_id` provider configuration property is required for this resource to work. Data resource will error in case of metastores with duplicate names. This data source is only available for users & service principals with account admin status

    ## Example Usage

    Mapping of name to id of all metastores:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_metastores()
    pulumi.export("allMetastores", all.ids)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Metastore to get information about a single metastore.
    * Metastore to manage Metastores within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param Mapping[str, str] ids: Mapping of name to id of databricks_metastore
    """
    __args__ = dict()
    __args__['ids'] = ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getMetastores:getMetastores', __args__, opts=opts, typ=GetMetastoresResult).value

    return AwaitableGetMetastoresResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))
def get_metastores_output(ids: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMetastoresResult]:
    """
    > **Note** This data source can only be used with an account-level provider!

    Retrieves a mapping of name to id of Metastore objects, that were created by Pulumi or manually, so that special handling could be applied.

    > **Note** `account_id` provider configuration property is required for this resource to work. Data resource will error in case of metastores with duplicate names. This data source is only available for users & service principals with account admin status

    ## Example Usage

    Mapping of name to id of all metastores:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_metastores()
    pulumi.export("allMetastores", all.ids)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Metastore to get information about a single metastore.
    * Metastore to manage Metastores within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param Mapping[str, str] ids: Mapping of name to id of databricks_metastore
    """
    __args__ = dict()
    __args__['ids'] = ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getMetastores:getMetastores', __args__, opts=opts, typ=GetMetastoresResult)
    return __ret__.apply(lambda __response__: GetMetastoresResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids')))
