# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMlflowModelResult',
    'AwaitableGetMlflowModelResult',
    'get_mlflow_model',
    'get_mlflow_model_output',
]

@pulumi.output_type
class GetMlflowModelResult:
    """
    A collection of values returned by getMlflowModel.
    """
    def __init__(__self__, description=None, id=None, latest_versions=None, name=None, permission_level=None, tags=None, user_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_versions and not isinstance(latest_versions, list):
            raise TypeError("Expected argument 'latest_versions' to be a list")
        pulumi.set(__self__, "latest_versions", latest_versions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permission_level and not isinstance(permission_level, str):
            raise TypeError("Expected argument 'permission_level' to be a str")
        pulumi.set(__self__, "permission_level", permission_level)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User-specified description for the object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the object.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestVersions")
    def latest_versions(self) -> Sequence['outputs.GetMlflowModelLatestVersionResult']:
        """
        Array of model versions, each the latest version for its stage.
        """
        return pulumi.get(self, "latest_versions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the model.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="permissionLevel")
    def permission_level(self) -> str:
        """
        Permission level of the requesting user on the object. For what is allowed at each level, see MLflow Model permissions.
        """
        return pulumi.get(self, "permission_level")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetMlflowModelTagResult']:
        """
        Array of tags associated with the model.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The username of the user that created the object.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetMlflowModelResult(GetMlflowModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlflowModelResult(
            description=self.description,
            id=self.id,
            latest_versions=self.latest_versions,
            name=self.name,
            permission_level=self.permission_level,
            tags=self.tags,
            user_id=self.user_id)


def get_mlflow_model(description: Optional[str] = None,
                     latest_versions: Optional[Sequence[Union['GetMlflowModelLatestVersionArgs', 'GetMlflowModelLatestVersionArgsDict']]] = None,
                     name: Optional[str] = None,
                     permission_level: Optional[str] = None,
                     tags: Optional[Sequence[Union['GetMlflowModelTagArgs', 'GetMlflowModelTagArgsDict']]] = None,
                     user_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlflowModelResult:
    """
    > **Note** If you have a fully automated setup with workspaces created by MwsWorkspaces or azurerm_databricks_workspace, please make sure to add depends_on attribute in order to prevent _default auth: cannot configure default credentials_ errors.

    Retrieves the settings of MlflowModel by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this_mlflow_model = databricks.MlflowModel("this",
        name="My MLflow Model",
        description="My MLflow model description",
        tags=[
            {
                "key": "key1",
                "value": "value1",
            },
            {
                "key": "key2",
                "value": "value2",
            },
        ])
    this = databricks.get_mlflow_model(name="My MLflow Model")
    pulumi.export("model", this)
    ```

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_mlflow_model(name="My MLflow Model with multiple versions")
    this_model_serving = databricks.ModelServing("this",
        name="model-serving-endpoint",
        config={
            "served_models": [{
                "name": "model_serving_prod",
                "model_name": this.name,
                "model_version": this.latest_versions[0].version,
                "workload_size": "Small",
                "scale_to_zero_enabled": True,
            }],
        })
    ```


    :param str description: User-specified description for the object.
    :param Sequence[Union['GetMlflowModelLatestVersionArgs', 'GetMlflowModelLatestVersionArgsDict']] latest_versions: Array of model versions, each the latest version for its stage.
    :param str name: Name of the registered model.
    :param str permission_level: Permission level of the requesting user on the object. For what is allowed at each level, see MLflow Model permissions.
    :param Sequence[Union['GetMlflowModelTagArgs', 'GetMlflowModelTagArgsDict']] tags: Array of tags associated with the model.
    :param str user_id: The username of the user that created the object.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['latestVersions'] = latest_versions
    __args__['name'] = name
    __args__['permissionLevel'] = permission_level
    __args__['tags'] = tags
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getMlflowModel:getMlflowModel', __args__, opts=opts, typ=GetMlflowModelResult).value

    return AwaitableGetMlflowModelResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        latest_versions=pulumi.get(__ret__, 'latest_versions'),
        name=pulumi.get(__ret__, 'name'),
        permission_level=pulumi.get(__ret__, 'permission_level'),
        tags=pulumi.get(__ret__, 'tags'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_mlflow_model_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                            latest_versions: Optional[pulumi.Input[Optional[Sequence[Union['GetMlflowModelLatestVersionArgs', 'GetMlflowModelLatestVersionArgsDict']]]]] = None,
                            name: Optional[pulumi.Input[str]] = None,
                            permission_level: Optional[pulumi.Input[Optional[str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Sequence[Union['GetMlflowModelTagArgs', 'GetMlflowModelTagArgsDict']]]]] = None,
                            user_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlflowModelResult]:
    """
    > **Note** If you have a fully automated setup with workspaces created by MwsWorkspaces or azurerm_databricks_workspace, please make sure to add depends_on attribute in order to prevent _default auth: cannot configure default credentials_ errors.

    Retrieves the settings of MlflowModel by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this_mlflow_model = databricks.MlflowModel("this",
        name="My MLflow Model",
        description="My MLflow model description",
        tags=[
            {
                "key": "key1",
                "value": "value1",
            },
            {
                "key": "key2",
                "value": "value2",
            },
        ])
    this = databricks.get_mlflow_model(name="My MLflow Model")
    pulumi.export("model", this)
    ```

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_mlflow_model(name="My MLflow Model with multiple versions")
    this_model_serving = databricks.ModelServing("this",
        name="model-serving-endpoint",
        config={
            "served_models": [{
                "name": "model_serving_prod",
                "model_name": this.name,
                "model_version": this.latest_versions[0].version,
                "workload_size": "Small",
                "scale_to_zero_enabled": True,
            }],
        })
    ```


    :param str description: User-specified description for the object.
    :param Sequence[Union['GetMlflowModelLatestVersionArgs', 'GetMlflowModelLatestVersionArgsDict']] latest_versions: Array of model versions, each the latest version for its stage.
    :param str name: Name of the registered model.
    :param str permission_level: Permission level of the requesting user on the object. For what is allowed at each level, see MLflow Model permissions.
    :param Sequence[Union['GetMlflowModelTagArgs', 'GetMlflowModelTagArgsDict']] tags: Array of tags associated with the model.
    :param str user_id: The username of the user that created the object.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['latestVersions'] = latest_versions
    __args__['name'] = name
    __args__['permissionLevel'] = permission_level
    __args__['tags'] = tags
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getMlflowModel:getMlflowModel', __args__, opts=opts, typ=GetMlflowModelResult)
    return __ret__.apply(lambda __response__: GetMlflowModelResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        latest_versions=pulumi.get(__response__, 'latest_versions'),
        name=pulumi.get(__response__, 'name'),
        permission_level=pulumi.get(__response__, 'permission_level'),
        tags=pulumi.get(__response__, 'tags'),
        user_id=pulumi.get(__response__, 'user_id')))
