# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMwsWorkspacesResult',
    'AwaitableGetMwsWorkspacesResult',
    'get_mws_workspaces',
    'get_mws_workspaces_output',
]

@pulumi.output_type
class GetMwsWorkspacesResult:
    """
    A collection of values returned by getMwsWorkspaces.
    """
    def __init__(__self__, id=None, ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, dict):
            raise TypeError("Expected argument 'ids' to be a dict")
        pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Mapping[str, str]:
        """
        name-to-id map for all of the workspaces in the account
        """
        return pulumi.get(self, "ids")


class AwaitableGetMwsWorkspacesResult(GetMwsWorkspacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMwsWorkspacesResult(
            id=self.id,
            ids=self.ids)


def get_mws_workspaces(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMwsWorkspacesResult:
    """
    > **Note** If you have a fully automated setup with workspaces created by MwsWorkspaces or azurerm_databricks_workspace, please make sure to add depends_on attribute in order to prevent _default auth: cannot configure default credentials_ errors.

    Lists all MwsWorkspaces in Databricks Account.

    > **Note** `account_id` provider configuration property is required for this resource to work.

    ## Example Usage

    Listing all workspaces in

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_mws_workspaces()
    pulumi.export("allMwsWorkspaces", all.ids)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * MwsWorkspaces to manage Databricks Workspaces on AWS and GCP.
    * MetastoreAssignment to assign Metastore to MwsWorkspaces or azurerm_databricks_workspace
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getMwsWorkspaces:getMwsWorkspaces', __args__, opts=opts, typ=GetMwsWorkspacesResult).value

    return AwaitableGetMwsWorkspacesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))
def get_mws_workspaces_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMwsWorkspacesResult]:
    """
    > **Note** If you have a fully automated setup with workspaces created by MwsWorkspaces or azurerm_databricks_workspace, please make sure to add depends_on attribute in order to prevent _default auth: cannot configure default credentials_ errors.

    Lists all MwsWorkspaces in Databricks Account.

    > **Note** `account_id` provider configuration property is required for this resource to work.

    ## Example Usage

    Listing all workspaces in

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_mws_workspaces()
    pulumi.export("allMwsWorkspaces", all.ids)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * MwsWorkspaces to manage Databricks Workspaces on AWS and GCP.
    * MetastoreAssignment to assign Metastore to MwsWorkspaces or azurerm_databricks_workspace
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getMwsWorkspaces:getMwsWorkspaces', __args__, opts=opts, typ=GetMwsWorkspacesResult)
    return __ret__.apply(lambda __response__: GetMwsWorkspacesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids')))
