# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServingEndpointsResult',
    'AwaitableGetServingEndpointsResult',
    'get_serving_endpoints',
    'get_serving_endpoints_output',
]

@pulumi.output_type
class GetServingEndpointsResult:
    """
    A collection of values returned by getServingEndpoints.
    """
    def __init__(__self__, endpoints=None, id=None):
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetServingEndpointsEndpointResult']:
        """
        List of objects describing the serving endpoints. Each object consists of following attributes:
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetServingEndpointsResult(GetServingEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServingEndpointsResult(
            endpoints=self.endpoints,
            id=self.id)


def get_serving_endpoints(endpoints: Optional[Sequence[Union['GetServingEndpointsEndpointArgs', 'GetServingEndpointsEndpointArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServingEndpointsResult:
    """
    > This resource can only be used with a workspace-level provider!

    This resource allows you to get information about [Model Serving](https://docs.databricks.com/machine-learning/model-serving/index.html) endpoints in Databricks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_serving_endpoints()
    ml_serving_usage = []
    for range in [{"value": i} for i in range(0, all_databricks_serving_endpoints.endpoints)]:
        ml_serving_usage.append(databricks.Permissions(f"ml_serving_usage-{range['value']}",
            serving_endpoint_id=range["value"]["id"],
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": auto["displayName"],
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "group_name": eng["displayName"],
                    "permission_level": "CAN_QUERY",
                },
            ]))
    ```

    ## Related Resources

    The following resources are often used in the same context:

    * Permissions can control which groups or individual users can *Manage*, *Query* or *View* individual serving endpoints.


    :param Sequence[Union['GetServingEndpointsEndpointArgs', 'GetServingEndpointsEndpointArgsDict']] endpoints: List of objects describing the serving endpoints. Each object consists of following attributes:
    """
    __args__ = dict()
    __args__['endpoints'] = endpoints
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getServingEndpoints:getServingEndpoints', __args__, opts=opts, typ=GetServingEndpointsResult).value

    return AwaitableGetServingEndpointsResult(
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'))
def get_serving_endpoints_output(endpoints: Optional[pulumi.Input[Optional[Sequence[Union['GetServingEndpointsEndpointArgs', 'GetServingEndpointsEndpointArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServingEndpointsResult]:
    """
    > This resource can only be used with a workspace-level provider!

    This resource allows you to get information about [Model Serving](https://docs.databricks.com/machine-learning/model-serving/index.html) endpoints in Databricks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_serving_endpoints()
    ml_serving_usage = []
    for range in [{"value": i} for i in range(0, all_databricks_serving_endpoints.endpoints)]:
        ml_serving_usage.append(databricks.Permissions(f"ml_serving_usage-{range['value']}",
            serving_endpoint_id=range["value"]["id"],
            access_controls=[
                {
                    "group_name": "users",
                    "permission_level": "CAN_VIEW",
                },
                {
                    "group_name": auto["displayName"],
                    "permission_level": "CAN_MANAGE",
                },
                {
                    "group_name": eng["displayName"],
                    "permission_level": "CAN_QUERY",
                },
            ]))
    ```

    ## Related Resources

    The following resources are often used in the same context:

    * Permissions can control which groups or individual users can *Manage*, *Query* or *View* individual serving endpoints.


    :param Sequence[Union['GetServingEndpointsEndpointArgs', 'GetServingEndpointsEndpointArgsDict']] endpoints: List of objects describing the serving endpoints. Each object consists of following attributes:
    """
    __args__ = dict()
    __args__['endpoints'] = endpoints
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getServingEndpoints:getServingEndpoints', __args__, opts=opts, typ=GetServingEndpointsResult)
    return __ret__.apply(lambda __response__: GetServingEndpointsResult(
        endpoints=pulumi.get(__response__, 'endpoints'),
        id=pulumi.get(__response__, 'id')))
