# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeResult',
    'AwaitableGetVolumeResult',
    'get_volume',
    'get_volume_output',
]

@pulumi.output_type
class GetVolumeResult:
    """
    A collection of values returned by getVolume.
    """
    def __init__(__self__, id=None, name=None, volume_info=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if volume_info and not isinstance(volume_info, dict):
            raise TypeError("Expected argument 'volume_info' to be a dict")
        pulumi.set(__self__, "volume_info", volume_info)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of this Unity Catalog Volume in form of `<catalog>.<schema>.<name>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the volume
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="volumeInfo")
    def volume_info(self) -> 'outputs.GetVolumeVolumeInfoResult':
        """
        `VolumeInfo` object for a Unity Catalog volume. This contains the following attributes:
        """
        return pulumi.get(self, "volume_info")


class AwaitableGetVolumeResult(GetVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeResult(
            id=self.id,
            name=self.name,
            volume_info=self.volume_info)


def get_volume(id: Optional[str] = None,
               name: Optional[str] = None,
               volume_info: Optional[Union['GetVolumeVolumeInfoArgs', 'GetVolumeVolumeInfoArgsDict']] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeResult:
    """
    Retrieves details about Volume that was created by Pulumi or manually.
    A volume can be identified by its three-level (fully qualified) name (in the form of: `catalog_name`.`schema_name`.`volume_name`) as input. This can be retrieved programmatically using get_volumes data source.

    ## Example Usage

    * Retrieve details of all volumes in in a _things_ Schema of a  _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_volumes(catalog_name="sandbox",
        schema_name="things")
    this = {__key: databricks.get_volume(name=__value) for __key, __value in all.ids}
    ```

    * Search for a specific volume by its fully qualified name

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_volume(name="catalog.schema.volume")
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Volume to manage volumes within Unity Catalog.
    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param str id: ID of this Unity Catalog Volume in form of `<catalog>.<schema>.<name>`.
    :param str name: a fully qualified name of databricks_volume: *`catalog`.`schema`.`volume`*
    :param Union['GetVolumeVolumeInfoArgs', 'GetVolumeVolumeInfoArgsDict'] volume_info: `VolumeInfo` object for a Unity Catalog volume. This contains the following attributes:
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['volumeInfo'] = volume_info
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getVolume:getVolume', __args__, opts=opts, typ=GetVolumeResult).value

    return AwaitableGetVolumeResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        volume_info=pulumi.get(__ret__, 'volume_info'))
def get_volume_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[str]] = None,
                      volume_info: Optional[pulumi.Input[Optional[Union['GetVolumeVolumeInfoArgs', 'GetVolumeVolumeInfoArgsDict']]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeResult]:
    """
    Retrieves details about Volume that was created by Pulumi or manually.
    A volume can be identified by its three-level (fully qualified) name (in the form of: `catalog_name`.`schema_name`.`volume_name`) as input. This can be retrieved programmatically using get_volumes data source.

    ## Example Usage

    * Retrieve details of all volumes in in a _things_ Schema of a  _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_volumes(catalog_name="sandbox",
        schema_name="things")
    this = {__key: databricks.get_volume(name=__value) for __key, __value in all.ids}
    ```

    * Search for a specific volume by its fully qualified name

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_volume(name="catalog.schema.volume")
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Volume to manage volumes within Unity Catalog.
    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param str id: ID of this Unity Catalog Volume in form of `<catalog>.<schema>.<name>`.
    :param str name: a fully qualified name of databricks_volume: *`catalog`.`schema`.`volume`*
    :param Union['GetVolumeVolumeInfoArgs', 'GetVolumeVolumeInfoArgsDict'] volume_info: `VolumeInfo` object for a Unity Catalog volume. This contains the following attributes:
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['volumeInfo'] = volume_info
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getVolume:getVolume', __args__, opts=opts, typ=GetVolumeResult)
    return __ret__.apply(lambda __response__: GetVolumeResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        volume_info=pulumi.get(__response__, 'volume_info')))
