# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 budget_policy_id: Optional[pulumi.Input[str]] = None,
                 continuous: Optional[pulumi.Input['JobContinuousArgs']] = None,
                 control_run_state: Optional[pulumi.Input[bool]] = None,
                 dbt_task: Optional[pulumi.Input['JobDbtTaskArgs']] = None,
                 deployment: Optional[pulumi.Input['JobDeploymentArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edit_mode: Optional[pulumi.Input[str]] = None,
                 email_notifications: Optional[pulumi.Input['JobEmailNotificationsArgs']] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['JobEnvironmentArgs']]]] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input['JobGitSourceArgs']] = None,
                 health: Optional[pulumi.Input['JobHealthArgs']] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input['JobNewClusterArgs']] = None,
                 notebook_task: Optional[pulumi.Input['JobNotebookTaskArgs']] = None,
                 notification_settings: Optional[pulumi.Input['JobNotificationSettingsArgs']] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]]] = None,
                 performance_target: Optional[pulumi.Input[str]] = None,
                 pipeline_task: Optional[pulumi.Input['JobPipelineTaskArgs']] = None,
                 python_wheel_task: Optional[pulumi.Input['JobPythonWheelTaskArgs']] = None,
                 queue: Optional[pulumi.Input['JobQueueArgs']] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 run_as: Optional[pulumi.Input['JobRunAsArgs']] = None,
                 run_job_task: Optional[pulumi.Input['JobRunJobTaskArgs']] = None,
                 schedule: Optional[pulumi.Input['JobScheduleArgs']] = None,
                 spark_jar_task: Optional[pulumi.Input['JobSparkJarTaskArgs']] = None,
                 spark_python_task: Optional[pulumi.Input['JobSparkPythonTaskArgs']] = None,
                 spark_submit_task: Optional[pulumi.Input['JobSparkSubmitTaskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 trigger: Optional[pulumi.Input['JobTriggerArgs']] = None,
                 webhook_notifications: Optional[pulumi.Input['JobWebhookNotificationsArgs']] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input[str] budget_policy_id: The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        :param pulumi.Input['JobContinuousArgs'] continuous: Configuration block to configure pause status. See continuous Configuration Block.
        :param pulumi.Input[bool] control_run_state: (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.
               
               When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        :param pulumi.Input[str] description: An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        :param pulumi.Input[str] edit_mode: If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        :param pulumi.Input['JobEmailNotificationsArgs'] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input['JobGitSourceArgs'] git_source: Specifices the a Git repository for task source code. See git_source Configuration Block below.
        :param pulumi.Input['JobHealthArgs'] health: An optional block that specifies the health conditions for the job documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]] libraries: (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input['JobNotificationSettingsArgs'] notification_settings: An optional block controlling the notification settings on the job level documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]] parameters: Specifices job parameter for the job. See parameter Configuration Block
        :param pulumi.Input['JobQueueArgs'] queue: The queue status for the job. See queue Configuration Block below.
        :param pulumi.Input['JobRunAsArgs'] run_as: The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        :param pulumi.Input['JobScheduleArgs'] schedule: An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: An optional map of the tags associated with the job. See tags Configuration Map
        :param pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]] tasks: A list of task specification that the job will execute. See task Configuration Block below.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input['JobTriggerArgs'] trigger: The conditions that triggers the job to start. See trigger Configuration Block below.
        :param pulumi.Input['JobWebhookNotificationsArgs'] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        if always_running is not None:
            warnings.warn("""always_running will be replaced by control_run_state in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""always_running is deprecated: always_running will be replaced by control_run_state in the next major release.""")
        if always_running is not None:
            pulumi.set(__self__, "always_running", always_running)
        if budget_policy_id is not None:
            pulumi.set(__self__, "budget_policy_id", budget_policy_id)
        if continuous is not None:
            pulumi.set(__self__, "continuous", continuous)
        if control_run_state is not None:
            pulumi.set(__self__, "control_run_state", control_run_state)
        if dbt_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""dbt_task is deprecated: should be used inside a task block and not inside a job block""")
        if dbt_task is not None:
            pulumi.set(__self__, "dbt_task", dbt_task)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edit_mode is not None:
            pulumi.set(__self__, "edit_mode", edit_mode)
        if email_notifications is not None:
            pulumi.set(__self__, "email_notifications", email_notifications)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if git_source is not None:
            pulumi.set(__self__, "git_source", git_source)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if job_clusters is not None:
            pulumi.set(__self__, "job_clusters", job_clusters)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)
        if max_retries is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""max_retries is deprecated: should be used inside a task block and not inside a job block""")
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_retry_interval_millis is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""min_retry_interval_millis is deprecated: should be used inside a task block and not inside a job block""")
        if min_retry_interval_millis is not None:
            pulumi.set(__self__, "min_retry_interval_millis", min_retry_interval_millis)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_cluster is not None:
            pulumi.set(__self__, "new_cluster", new_cluster)
        if notebook_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""notebook_task is deprecated: should be used inside a task block and not inside a job block""")
        if notebook_task is not None:
            pulumi.set(__self__, "notebook_task", notebook_task)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if performance_target is not None:
            pulumi.set(__self__, "performance_target", performance_target)
        if pipeline_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""pipeline_task is deprecated: should be used inside a task block and not inside a job block""")
        if pipeline_task is not None:
            pulumi.set(__self__, "pipeline_task", pipeline_task)
        if python_wheel_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""python_wheel_task is deprecated: should be used inside a task block and not inside a job block""")
        if python_wheel_task is not None:
            pulumi.set(__self__, "python_wheel_task", python_wheel_task)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if retry_on_timeout is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""retry_on_timeout is deprecated: should be used inside a task block and not inside a job block""")
        if retry_on_timeout is not None:
            pulumi.set(__self__, "retry_on_timeout", retry_on_timeout)
        if run_as is not None:
            pulumi.set(__self__, "run_as", run_as)
        if run_job_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""run_job_task is deprecated: should be used inside a task block and not inside a job block""")
        if run_job_task is not None:
            pulumi.set(__self__, "run_job_task", run_job_task)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if spark_jar_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""spark_jar_task is deprecated: should be used inside a task block and not inside a job block""")
        if spark_jar_task is not None:
            pulumi.set(__self__, "spark_jar_task", spark_jar_task)
        if spark_python_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""spark_python_task is deprecated: should be used inside a task block and not inside a job block""")
        if spark_python_task is not None:
            pulumi.set(__self__, "spark_python_task", spark_python_task)
        if spark_submit_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""spark_submit_task is deprecated: should be used inside a task block and not inside a job block""")
        if spark_submit_task is not None:
            pulumi.set(__self__, "spark_submit_task", spark_submit_task)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if webhook_notifications is not None:
            pulumi.set(__self__, "webhook_notifications", webhook_notifications)

    @property
    @pulumi.getter(name="alwaysRunning")
    @_utilities.deprecated("""always_running will be replaced by control_run_state in the next major release.""")
    def always_running(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        """
        return pulumi.get(self, "always_running")

    @always_running.setter
    def always_running(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_running", value)

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        """
        return pulumi.get(self, "budget_policy_id")

    @budget_policy_id.setter
    def budget_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "budget_policy_id", value)

    @property
    @pulumi.getter
    def continuous(self) -> Optional[pulumi.Input['JobContinuousArgs']]:
        """
        Configuration block to configure pause status. See continuous Configuration Block.
        """
        return pulumi.get(self, "continuous")

    @continuous.setter
    def continuous(self, value: Optional[pulumi.Input['JobContinuousArgs']]):
        pulumi.set(self, "continuous", value)

    @property
    @pulumi.getter(name="controlRunState")
    def control_run_state(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.

        When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        """
        return pulumi.get(self, "control_run_state")

    @control_run_state.setter
    def control_run_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "control_run_state", value)

    @property
    @pulumi.getter(name="dbtTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def dbt_task(self) -> Optional[pulumi.Input['JobDbtTaskArgs']]:
        return pulumi.get(self, "dbt_task")

    @dbt_task.setter
    def dbt_task(self, value: Optional[pulumi.Input['JobDbtTaskArgs']]):
        pulumi.set(self, "dbt_task", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['JobDeploymentArgs']]:
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['JobDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="editMode")
    def edit_mode(self) -> Optional[pulumi.Input[str]]:
        """
        If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        """
        return pulumi.get(self, "edit_mode")

    @edit_mode.setter
    def edit_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edit_mode", value)

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> Optional[pulumi.Input['JobEmailNotificationsArgs']]:
        """
        (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        """
        return pulumi.get(self, "email_notifications")

    @email_notifications.setter
    def email_notifications(self, value: Optional[pulumi.Input['JobEmailNotificationsArgs']]):
        pulumi.set(self, "email_notifications", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobEnvironmentArgs']]]]:
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_cluster_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="gitSource")
    def git_source(self) -> Optional[pulumi.Input['JobGitSourceArgs']]:
        """
        Specifices the a Git repository for task source code. See git_source Configuration Block below.
        """
        return pulumi.get(self, "git_source")

    @git_source.setter
    def git_source(self, value: Optional[pulumi.Input['JobGitSourceArgs']]):
        pulumi.set(self, "git_source", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input['JobHealthArgs']]:
        """
        An optional block that specifies the health conditions for the job documented below.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input['JobHealthArgs']]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="jobClusters")
    def job_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]:
        """
        A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        """
        return pulumi.get(self, "job_clusters")

    @job_clusters.setter
    def job_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]):
        pulumi.set(self, "job_clusters", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]:
        """
        (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @max_concurrent_runs.setter
    def max_concurrent_runs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_runs", value)

    @property
    @pulumi.getter(name="maxRetries")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="minRetryIntervalMillis")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def min_retry_interval_millis(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        """
        return pulumi.get(self, "min_retry_interval_millis")

    @min_retry_interval_millis.setter
    def min_retry_interval_millis(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_retry_interval_millis", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional name for the job. The default value is Untitled.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newCluster")
    def new_cluster(self) -> Optional[pulumi.Input['JobNewClusterArgs']]:
        return pulumi.get(self, "new_cluster")

    @new_cluster.setter
    def new_cluster(self, value: Optional[pulumi.Input['JobNewClusterArgs']]):
        pulumi.set(self, "new_cluster", value)

    @property
    @pulumi.getter(name="notebookTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def notebook_task(self) -> Optional[pulumi.Input['JobNotebookTaskArgs']]:
        return pulumi.get(self, "notebook_task")

    @notebook_task.setter
    def notebook_task(self, value: Optional[pulumi.Input['JobNotebookTaskArgs']]):
        pulumi.set(self, "notebook_task", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['JobNotificationSettingsArgs']]:
        """
        An optional block controlling the notification settings on the job level documented below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['JobNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]]]:
        """
        Specifices job parameter for the job. See parameter Configuration Block
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="performanceTarget")
    def performance_target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "performance_target")

    @performance_target.setter
    def performance_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_target", value)

    @property
    @pulumi.getter(name="pipelineTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def pipeline_task(self) -> Optional[pulumi.Input['JobPipelineTaskArgs']]:
        return pulumi.get(self, "pipeline_task")

    @pipeline_task.setter
    def pipeline_task(self, value: Optional[pulumi.Input['JobPipelineTaskArgs']]):
        pulumi.set(self, "pipeline_task", value)

    @property
    @pulumi.getter(name="pythonWheelTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def python_wheel_task(self) -> Optional[pulumi.Input['JobPythonWheelTaskArgs']]:
        return pulumi.get(self, "python_wheel_task")

    @python_wheel_task.setter
    def python_wheel_task(self, value: Optional[pulumi.Input['JobPythonWheelTaskArgs']]):
        pulumi.set(self, "python_wheel_task", value)

    @property
    @pulumi.getter
    def queue(self) -> Optional[pulumi.Input['JobQueueArgs']]:
        """
        The queue status for the job. See queue Configuration Block below.
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: Optional[pulumi.Input['JobQueueArgs']]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter(name="retryOnTimeout")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def retry_on_timeout(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "retry_on_timeout")

    @retry_on_timeout.setter
    def retry_on_timeout(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retry_on_timeout", value)

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> Optional[pulumi.Input['JobRunAsArgs']]:
        """
        The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        """
        return pulumi.get(self, "run_as")

    @run_as.setter
    def run_as(self, value: Optional[pulumi.Input['JobRunAsArgs']]):
        pulumi.set(self, "run_as", value)

    @property
    @pulumi.getter(name="runJobTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def run_job_task(self) -> Optional[pulumi.Input['JobRunJobTaskArgs']]:
        return pulumi.get(self, "run_job_task")

    @run_job_task.setter
    def run_job_task(self, value: Optional[pulumi.Input['JobRunJobTaskArgs']]):
        pulumi.set(self, "run_job_task", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['JobScheduleArgs']]:
        """
        An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['JobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sparkJarTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_jar_task(self) -> Optional[pulumi.Input['JobSparkJarTaskArgs']]:
        return pulumi.get(self, "spark_jar_task")

    @spark_jar_task.setter
    def spark_jar_task(self, value: Optional[pulumi.Input['JobSparkJarTaskArgs']]):
        pulumi.set(self, "spark_jar_task", value)

    @property
    @pulumi.getter(name="sparkPythonTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_python_task(self) -> Optional[pulumi.Input['JobSparkPythonTaskArgs']]:
        return pulumi.get(self, "spark_python_task")

    @spark_python_task.setter
    def spark_python_task(self, value: Optional[pulumi.Input['JobSparkPythonTaskArgs']]):
        pulumi.set(self, "spark_python_task", value)

    @property
    @pulumi.getter(name="sparkSubmitTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_submit_task(self) -> Optional[pulumi.Input['JobSparkSubmitTaskArgs']]:
        return pulumi.get(self, "spark_submit_task")

    @spark_submit_task.setter
    def spark_submit_task(self, value: Optional[pulumi.Input['JobSparkSubmitTaskArgs']]):
        pulumi.set(self, "spark_submit_task", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An optional map of the tags associated with the job. See tags Configuration Map
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]:
        """
        A list of task specification that the job will execute. See task Configuration Block below.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]):
        pulumi.set(self, "tasks", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['JobTriggerArgs']]:
        """
        The conditions that triggers the job to start. See trigger Configuration Block below.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['JobTriggerArgs']]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter(name="webhookNotifications")
    def webhook_notifications(self) -> Optional[pulumi.Input['JobWebhookNotificationsArgs']]:
        """
        (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        return pulumi.get(self, "webhook_notifications")

    @webhook_notifications.setter
    def webhook_notifications(self, value: Optional[pulumi.Input['JobWebhookNotificationsArgs']]):
        pulumi.set(self, "webhook_notifications", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 budget_policy_id: Optional[pulumi.Input[str]] = None,
                 continuous: Optional[pulumi.Input['JobContinuousArgs']] = None,
                 control_run_state: Optional[pulumi.Input[bool]] = None,
                 dbt_task: Optional[pulumi.Input['JobDbtTaskArgs']] = None,
                 deployment: Optional[pulumi.Input['JobDeploymentArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edit_mode: Optional[pulumi.Input[str]] = None,
                 email_notifications: Optional[pulumi.Input['JobEmailNotificationsArgs']] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['JobEnvironmentArgs']]]] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input['JobGitSourceArgs']] = None,
                 health: Optional[pulumi.Input['JobHealthArgs']] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input['JobNewClusterArgs']] = None,
                 notebook_task: Optional[pulumi.Input['JobNotebookTaskArgs']] = None,
                 notification_settings: Optional[pulumi.Input['JobNotificationSettingsArgs']] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]]] = None,
                 performance_target: Optional[pulumi.Input[str]] = None,
                 pipeline_task: Optional[pulumi.Input['JobPipelineTaskArgs']] = None,
                 python_wheel_task: Optional[pulumi.Input['JobPythonWheelTaskArgs']] = None,
                 queue: Optional[pulumi.Input['JobQueueArgs']] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 run_as: Optional[pulumi.Input['JobRunAsArgs']] = None,
                 run_job_task: Optional[pulumi.Input['JobRunJobTaskArgs']] = None,
                 schedule: Optional[pulumi.Input['JobScheduleArgs']] = None,
                 spark_jar_task: Optional[pulumi.Input['JobSparkJarTaskArgs']] = None,
                 spark_python_task: Optional[pulumi.Input['JobSparkPythonTaskArgs']] = None,
                 spark_submit_task: Optional[pulumi.Input['JobSparkSubmitTaskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 trigger: Optional[pulumi.Input['JobTriggerArgs']] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 webhook_notifications: Optional[pulumi.Input['JobWebhookNotificationsArgs']] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input[str] budget_policy_id: The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        :param pulumi.Input['JobContinuousArgs'] continuous: Configuration block to configure pause status. See continuous Configuration Block.
        :param pulumi.Input[bool] control_run_state: (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.
               
               When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        :param pulumi.Input[str] description: An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        :param pulumi.Input[str] edit_mode: If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        :param pulumi.Input['JobEmailNotificationsArgs'] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input['JobGitSourceArgs'] git_source: Specifices the a Git repository for task source code. See git_source Configuration Block below.
        :param pulumi.Input['JobHealthArgs'] health: An optional block that specifies the health conditions for the job documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]] libraries: (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input['JobNotificationSettingsArgs'] notification_settings: An optional block controlling the notification settings on the job level documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]] parameters: Specifices job parameter for the job. See parameter Configuration Block
        :param pulumi.Input['JobQueueArgs'] queue: The queue status for the job. See queue Configuration Block below.
        :param pulumi.Input['JobRunAsArgs'] run_as: The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        :param pulumi.Input['JobScheduleArgs'] schedule: An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: An optional map of the tags associated with the job. See tags Configuration Map
        :param pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]] tasks: A list of task specification that the job will execute. See task Configuration Block below.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input['JobTriggerArgs'] trigger: The conditions that triggers the job to start. See trigger Configuration Block below.
        :param pulumi.Input[str] url: URL of the job on the given workspace
        :param pulumi.Input['JobWebhookNotificationsArgs'] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        if always_running is not None:
            warnings.warn("""always_running will be replaced by control_run_state in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""always_running is deprecated: always_running will be replaced by control_run_state in the next major release.""")
        if always_running is not None:
            pulumi.set(__self__, "always_running", always_running)
        if budget_policy_id is not None:
            pulumi.set(__self__, "budget_policy_id", budget_policy_id)
        if continuous is not None:
            pulumi.set(__self__, "continuous", continuous)
        if control_run_state is not None:
            pulumi.set(__self__, "control_run_state", control_run_state)
        if dbt_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""dbt_task is deprecated: should be used inside a task block and not inside a job block""")
        if dbt_task is not None:
            pulumi.set(__self__, "dbt_task", dbt_task)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edit_mode is not None:
            pulumi.set(__self__, "edit_mode", edit_mode)
        if email_notifications is not None:
            pulumi.set(__self__, "email_notifications", email_notifications)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if git_source is not None:
            pulumi.set(__self__, "git_source", git_source)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if job_clusters is not None:
            pulumi.set(__self__, "job_clusters", job_clusters)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if max_concurrent_runs is not None:
            pulumi.set(__self__, "max_concurrent_runs", max_concurrent_runs)
        if max_retries is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""max_retries is deprecated: should be used inside a task block and not inside a job block""")
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_retry_interval_millis is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""min_retry_interval_millis is deprecated: should be used inside a task block and not inside a job block""")
        if min_retry_interval_millis is not None:
            pulumi.set(__self__, "min_retry_interval_millis", min_retry_interval_millis)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_cluster is not None:
            pulumi.set(__self__, "new_cluster", new_cluster)
        if notebook_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""notebook_task is deprecated: should be used inside a task block and not inside a job block""")
        if notebook_task is not None:
            pulumi.set(__self__, "notebook_task", notebook_task)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if performance_target is not None:
            pulumi.set(__self__, "performance_target", performance_target)
        if pipeline_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""pipeline_task is deprecated: should be used inside a task block and not inside a job block""")
        if pipeline_task is not None:
            pulumi.set(__self__, "pipeline_task", pipeline_task)
        if python_wheel_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""python_wheel_task is deprecated: should be used inside a task block and not inside a job block""")
        if python_wheel_task is not None:
            pulumi.set(__self__, "python_wheel_task", python_wheel_task)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if retry_on_timeout is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""retry_on_timeout is deprecated: should be used inside a task block and not inside a job block""")
        if retry_on_timeout is not None:
            pulumi.set(__self__, "retry_on_timeout", retry_on_timeout)
        if run_as is not None:
            pulumi.set(__self__, "run_as", run_as)
        if run_job_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""run_job_task is deprecated: should be used inside a task block and not inside a job block""")
        if run_job_task is not None:
            pulumi.set(__self__, "run_job_task", run_job_task)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if spark_jar_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""spark_jar_task is deprecated: should be used inside a task block and not inside a job block""")
        if spark_jar_task is not None:
            pulumi.set(__self__, "spark_jar_task", spark_jar_task)
        if spark_python_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""spark_python_task is deprecated: should be used inside a task block and not inside a job block""")
        if spark_python_task is not None:
            pulumi.set(__self__, "spark_python_task", spark_python_task)
        if spark_submit_task is not None:
            warnings.warn("""should be used inside a task block and not inside a job block""", DeprecationWarning)
            pulumi.log.warn("""spark_submit_task is deprecated: should be used inside a task block and not inside a job block""")
        if spark_submit_task is not None:
            pulumi.set(__self__, "spark_submit_task", spark_submit_task)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if webhook_notifications is not None:
            pulumi.set(__self__, "webhook_notifications", webhook_notifications)

    @property
    @pulumi.getter(name="alwaysRunning")
    @_utilities.deprecated("""always_running will be replaced by control_run_state in the next major release.""")
    def always_running(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        """
        return pulumi.get(self, "always_running")

    @always_running.setter
    def always_running(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_running", value)

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        """
        return pulumi.get(self, "budget_policy_id")

    @budget_policy_id.setter
    def budget_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "budget_policy_id", value)

    @property
    @pulumi.getter
    def continuous(self) -> Optional[pulumi.Input['JobContinuousArgs']]:
        """
        Configuration block to configure pause status. See continuous Configuration Block.
        """
        return pulumi.get(self, "continuous")

    @continuous.setter
    def continuous(self, value: Optional[pulumi.Input['JobContinuousArgs']]):
        pulumi.set(self, "continuous", value)

    @property
    @pulumi.getter(name="controlRunState")
    def control_run_state(self) -> Optional[pulumi.Input[bool]]:
        """
        (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.

        When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        """
        return pulumi.get(self, "control_run_state")

    @control_run_state.setter
    def control_run_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "control_run_state", value)

    @property
    @pulumi.getter(name="dbtTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def dbt_task(self) -> Optional[pulumi.Input['JobDbtTaskArgs']]:
        return pulumi.get(self, "dbt_task")

    @dbt_task.setter
    def dbt_task(self, value: Optional[pulumi.Input['JobDbtTaskArgs']]):
        pulumi.set(self, "dbt_task", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['JobDeploymentArgs']]:
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['JobDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="editMode")
    def edit_mode(self) -> Optional[pulumi.Input[str]]:
        """
        If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        """
        return pulumi.get(self, "edit_mode")

    @edit_mode.setter
    def edit_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edit_mode", value)

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> Optional[pulumi.Input['JobEmailNotificationsArgs']]:
        """
        (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        """
        return pulumi.get(self, "email_notifications")

    @email_notifications.setter
    def email_notifications(self, value: Optional[pulumi.Input['JobEmailNotificationsArgs']]):
        pulumi.set(self, "email_notifications", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobEnvironmentArgs']]]]:
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_cluster_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="gitSource")
    def git_source(self) -> Optional[pulumi.Input['JobGitSourceArgs']]:
        """
        Specifices the a Git repository for task source code. See git_source Configuration Block below.
        """
        return pulumi.get(self, "git_source")

    @git_source.setter
    def git_source(self, value: Optional[pulumi.Input['JobGitSourceArgs']]):
        pulumi.set(self, "git_source", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input['JobHealthArgs']]:
        """
        An optional block that specifies the health conditions for the job documented below.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input['JobHealthArgs']]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="jobClusters")
    def job_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]:
        """
        A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        """
        return pulumi.get(self, "job_clusters")

    @job_clusters.setter
    def job_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobClusterArgs']]]]):
        pulumi.set(self, "job_clusters", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]:
        """
        (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @max_concurrent_runs.setter
    def max_concurrent_runs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_runs", value)

    @property
    @pulumi.getter(name="maxRetries")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="minRetryIntervalMillis")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def min_retry_interval_millis(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        """
        return pulumi.get(self, "min_retry_interval_millis")

    @min_retry_interval_millis.setter
    def min_retry_interval_millis(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_retry_interval_millis", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        An optional name for the job. The default value is Untitled.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newCluster")
    def new_cluster(self) -> Optional[pulumi.Input['JobNewClusterArgs']]:
        return pulumi.get(self, "new_cluster")

    @new_cluster.setter
    def new_cluster(self, value: Optional[pulumi.Input['JobNewClusterArgs']]):
        pulumi.set(self, "new_cluster", value)

    @property
    @pulumi.getter(name="notebookTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def notebook_task(self) -> Optional[pulumi.Input['JobNotebookTaskArgs']]:
        return pulumi.get(self, "notebook_task")

    @notebook_task.setter
    def notebook_task(self, value: Optional[pulumi.Input['JobNotebookTaskArgs']]):
        pulumi.set(self, "notebook_task", value)

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['JobNotificationSettingsArgs']]:
        """
        An optional block controlling the notification settings on the job level documented below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['JobNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]]]:
        """
        Specifices job parameter for the job. See parameter Configuration Block
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="performanceTarget")
    def performance_target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "performance_target")

    @performance_target.setter
    def performance_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_target", value)

    @property
    @pulumi.getter(name="pipelineTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def pipeline_task(self) -> Optional[pulumi.Input['JobPipelineTaskArgs']]:
        return pulumi.get(self, "pipeline_task")

    @pipeline_task.setter
    def pipeline_task(self, value: Optional[pulumi.Input['JobPipelineTaskArgs']]):
        pulumi.set(self, "pipeline_task", value)

    @property
    @pulumi.getter(name="pythonWheelTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def python_wheel_task(self) -> Optional[pulumi.Input['JobPythonWheelTaskArgs']]:
        return pulumi.get(self, "python_wheel_task")

    @python_wheel_task.setter
    def python_wheel_task(self, value: Optional[pulumi.Input['JobPythonWheelTaskArgs']]):
        pulumi.set(self, "python_wheel_task", value)

    @property
    @pulumi.getter
    def queue(self) -> Optional[pulumi.Input['JobQueueArgs']]:
        """
        The queue status for the job. See queue Configuration Block below.
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: Optional[pulumi.Input['JobQueueArgs']]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter(name="retryOnTimeout")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def retry_on_timeout(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "retry_on_timeout")

    @retry_on_timeout.setter
    def retry_on_timeout(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retry_on_timeout", value)

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> Optional[pulumi.Input['JobRunAsArgs']]:
        """
        The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        """
        return pulumi.get(self, "run_as")

    @run_as.setter
    def run_as(self, value: Optional[pulumi.Input['JobRunAsArgs']]):
        pulumi.set(self, "run_as", value)

    @property
    @pulumi.getter(name="runJobTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def run_job_task(self) -> Optional[pulumi.Input['JobRunJobTaskArgs']]:
        return pulumi.get(self, "run_job_task")

    @run_job_task.setter
    def run_job_task(self, value: Optional[pulumi.Input['JobRunJobTaskArgs']]):
        pulumi.set(self, "run_job_task", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['JobScheduleArgs']]:
        """
        An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['JobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sparkJarTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_jar_task(self) -> Optional[pulumi.Input['JobSparkJarTaskArgs']]:
        return pulumi.get(self, "spark_jar_task")

    @spark_jar_task.setter
    def spark_jar_task(self, value: Optional[pulumi.Input['JobSparkJarTaskArgs']]):
        pulumi.set(self, "spark_jar_task", value)

    @property
    @pulumi.getter(name="sparkPythonTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_python_task(self) -> Optional[pulumi.Input['JobSparkPythonTaskArgs']]:
        return pulumi.get(self, "spark_python_task")

    @spark_python_task.setter
    def spark_python_task(self, value: Optional[pulumi.Input['JobSparkPythonTaskArgs']]):
        pulumi.set(self, "spark_python_task", value)

    @property
    @pulumi.getter(name="sparkSubmitTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_submit_task(self) -> Optional[pulumi.Input['JobSparkSubmitTaskArgs']]:
        return pulumi.get(self, "spark_submit_task")

    @spark_submit_task.setter
    def spark_submit_task(self, value: Optional[pulumi.Input['JobSparkSubmitTaskArgs']]):
        pulumi.set(self, "spark_submit_task", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An optional map of the tags associated with the job. See tags Configuration Map
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]:
        """
        A list of task specification that the job will execute. See task Configuration Block below.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskArgs']]]]):
        pulumi.set(self, "tasks", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input['JobTriggerArgs']]:
        """
        The conditions that triggers the job to start. See trigger Configuration Block below.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input['JobTriggerArgs']]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the job on the given workspace
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="webhookNotifications")
    def webhook_notifications(self) -> Optional[pulumi.Input['JobWebhookNotificationsArgs']]:
        """
        (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        return pulumi.get(self, "webhook_notifications")

    @webhook_notifications.setter
    def webhook_notifications(self, value: Optional[pulumi.Input['JobWebhookNotificationsArgs']]):
        pulumi.set(self, "webhook_notifications", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 budget_policy_id: Optional[pulumi.Input[str]] = None,
                 continuous: Optional[pulumi.Input[Union['JobContinuousArgs', 'JobContinuousArgsDict']]] = None,
                 control_run_state: Optional[pulumi.Input[bool]] = None,
                 dbt_task: Optional[pulumi.Input[Union['JobDbtTaskArgs', 'JobDbtTaskArgsDict']]] = None,
                 deployment: Optional[pulumi.Input[Union['JobDeploymentArgs', 'JobDeploymentArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edit_mode: Optional[pulumi.Input[str]] = None,
                 email_notifications: Optional[pulumi.Input[Union['JobEmailNotificationsArgs', 'JobEmailNotificationsArgsDict']]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobEnvironmentArgs', 'JobEnvironmentArgsDict']]]]] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input[Union['JobGitSourceArgs', 'JobGitSourceArgsDict']]] = None,
                 health: Optional[pulumi.Input[Union['JobHealthArgs', 'JobHealthArgsDict']]] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobClusterArgs', 'JobJobClusterArgsDict']]]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLibraryArgs', 'JobLibraryArgsDict']]]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input[Union['JobNewClusterArgs', 'JobNewClusterArgsDict']]] = None,
                 notebook_task: Optional[pulumi.Input[Union['JobNotebookTaskArgs', 'JobNotebookTaskArgsDict']]] = None,
                 notification_settings: Optional[pulumi.Input[Union['JobNotificationSettingsArgs', 'JobNotificationSettingsArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobParameterArgs', 'JobParameterArgsDict']]]]] = None,
                 performance_target: Optional[pulumi.Input[str]] = None,
                 pipeline_task: Optional[pulumi.Input[Union['JobPipelineTaskArgs', 'JobPipelineTaskArgsDict']]] = None,
                 python_wheel_task: Optional[pulumi.Input[Union['JobPythonWheelTaskArgs', 'JobPythonWheelTaskArgsDict']]] = None,
                 queue: Optional[pulumi.Input[Union['JobQueueArgs', 'JobQueueArgsDict']]] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 run_as: Optional[pulumi.Input[Union['JobRunAsArgs', 'JobRunAsArgsDict']]] = None,
                 run_job_task: Optional[pulumi.Input[Union['JobRunJobTaskArgs', 'JobRunJobTaskArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['JobScheduleArgs', 'JobScheduleArgsDict']]] = None,
                 spark_jar_task: Optional[pulumi.Input[Union['JobSparkJarTaskArgs', 'JobSparkJarTaskArgsDict']]] = None,
                 spark_python_task: Optional[pulumi.Input[Union['JobSparkPythonTaskArgs', 'JobSparkPythonTaskArgsDict']]] = None,
                 spark_submit_task: Optional[pulumi.Input[Union['JobSparkSubmitTaskArgs', 'JobSparkSubmitTaskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobTaskArgs', 'JobTaskArgsDict']]]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 trigger: Optional[pulumi.Input[Union['JobTriggerArgs', 'JobTriggerArgsDict']]] = None,
                 webhook_notifications: Optional[pulumi.Input[Union['JobWebhookNotificationsArgs', 'JobWebhookNotificationsArgsDict']]] = None,
                 __props__=None):
        """
        The `Job` resource allows you to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.

        ## Example Usage

        > In Pulumi configuration, it is recommended to define tasks in alphabetical order of their `task_key` arguments, so that you get consistent and readable diff. Whenever tasks are added or removed, or `task_key` is renamed, you'll observe a change in the majority of tasks. It's related to the fact that the current version of the provider treats `task` blocks as an ordered list. Alternatively, `task` block could have been an unordered set, though end-users would see the entire block replaced upon a change in single property of the task.

        It is possible to create [a Databricks job](https://docs.databricks.com/data-engineering/jobs/jobs-user-guide.html) using `task` blocks. A single task is defined with the `task` block containing one of the `*_task` blocks, `task_key`, and additional arguments described below.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Job("this",
            name="Job with multiple tasks",
            description="This job executes multiple tasks on a shared job cluster, which will be provisioned as part of execution, and terminated once all tasks are finished.",
            job_clusters=[{
                "job_cluster_key": "j",
                "new_cluster": {
                    "num_workers": 2,
                    "spark_version": latest["id"],
                    "node_type_id": smallest["id"],
                },
            }],
            tasks=[
                {
                    "task_key": "a",
                    "new_cluster": {
                        "num_workers": 1,
                        "spark_version": latest["id"],
                        "node_type_id": smallest["id"],
                    },
                    "notebook_task": {
                        "notebook_path": this_databricks_notebook["path"],
                    },
                },
                {
                    "task_key": "b",
                    "depends_ons": [{
                        "task_key": "a",
                    }],
                    "existing_cluster_id": shared["id"],
                    "spark_jar_task": {
                        "main_class_name": "com.acme.data.Main",
                    },
                },
                {
                    "task_key": "c",
                    "job_cluster_key": "j",
                    "notebook_task": {
                        "notebook_path": this_databricks_notebook["path"],
                    },
                },
                {
                    "task_key": "d",
                    "pipeline_task": {
                        "pipeline_id": this_databricks_pipeline["id"],
                    },
                },
            ])
        ```

        ## Access Control

        By default, all users can create and modify jobs unless an administrator [enables jobs access control](https://docs.databricks.com/administration-guide/access-control/jobs-acl.html). With jobs access control, individual permissions determine a user’s abilities.

        * Permissions can control which groups or individual users can *Can View*, *Can Manage Run*, and *Can Manage*.
        * ClusterPolicy can control which kinds of clusters users can create for jobs.

        ## Import

        The resource job can be imported using the id of the job

        bash

        ```sh
        $ pulumi import databricks:index/job:Job this <job-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input[str] budget_policy_id: The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        :param pulumi.Input[Union['JobContinuousArgs', 'JobContinuousArgsDict']] continuous: Configuration block to configure pause status. See continuous Configuration Block.
        :param pulumi.Input[bool] control_run_state: (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.
               
               When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        :param pulumi.Input[str] description: An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        :param pulumi.Input[str] edit_mode: If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        :param pulumi.Input[Union['JobEmailNotificationsArgs', 'JobEmailNotificationsArgsDict']] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input[Union['JobGitSourceArgs', 'JobGitSourceArgsDict']] git_source: Specifices the a Git repository for task source code. See git_source Configuration Block below.
        :param pulumi.Input[Union['JobHealthArgs', 'JobHealthArgsDict']] health: An optional block that specifies the health conditions for the job documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobClusterArgs', 'JobJobClusterArgsDict']]]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobLibraryArgs', 'JobLibraryArgsDict']]]] libraries: (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input[Union['JobNotificationSettingsArgs', 'JobNotificationSettingsArgsDict']] notification_settings: An optional block controlling the notification settings on the job level documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobParameterArgs', 'JobParameterArgsDict']]]] parameters: Specifices job parameter for the job. See parameter Configuration Block
        :param pulumi.Input[Union['JobQueueArgs', 'JobQueueArgsDict']] queue: The queue status for the job. See queue Configuration Block below.
        :param pulumi.Input[Union['JobRunAsArgs', 'JobRunAsArgsDict']] run_as: The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        :param pulumi.Input[Union['JobScheduleArgs', 'JobScheduleArgsDict']] schedule: An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: An optional map of the tags associated with the job. See tags Configuration Map
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobTaskArgs', 'JobTaskArgsDict']]]] tasks: A list of task specification that the job will execute. See task Configuration Block below.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input[Union['JobTriggerArgs', 'JobTriggerArgsDict']] trigger: The conditions that triggers the job to start. See trigger Configuration Block below.
        :param pulumi.Input[Union['JobWebhookNotificationsArgs', 'JobWebhookNotificationsArgsDict']] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[JobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Job` resource allows you to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.

        ## Example Usage

        > In Pulumi configuration, it is recommended to define tasks in alphabetical order of their `task_key` arguments, so that you get consistent and readable diff. Whenever tasks are added or removed, or `task_key` is renamed, you'll observe a change in the majority of tasks. It's related to the fact that the current version of the provider treats `task` blocks as an ordered list. Alternatively, `task` block could have been an unordered set, though end-users would see the entire block replaced upon a change in single property of the task.

        It is possible to create [a Databricks job](https://docs.databricks.com/data-engineering/jobs/jobs-user-guide.html) using `task` blocks. A single task is defined with the `task` block containing one of the `*_task` blocks, `task_key`, and additional arguments described below.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Job("this",
            name="Job with multiple tasks",
            description="This job executes multiple tasks on a shared job cluster, which will be provisioned as part of execution, and terminated once all tasks are finished.",
            job_clusters=[{
                "job_cluster_key": "j",
                "new_cluster": {
                    "num_workers": 2,
                    "spark_version": latest["id"],
                    "node_type_id": smallest["id"],
                },
            }],
            tasks=[
                {
                    "task_key": "a",
                    "new_cluster": {
                        "num_workers": 1,
                        "spark_version": latest["id"],
                        "node_type_id": smallest["id"],
                    },
                    "notebook_task": {
                        "notebook_path": this_databricks_notebook["path"],
                    },
                },
                {
                    "task_key": "b",
                    "depends_ons": [{
                        "task_key": "a",
                    }],
                    "existing_cluster_id": shared["id"],
                    "spark_jar_task": {
                        "main_class_name": "com.acme.data.Main",
                    },
                },
                {
                    "task_key": "c",
                    "job_cluster_key": "j",
                    "notebook_task": {
                        "notebook_path": this_databricks_notebook["path"],
                    },
                },
                {
                    "task_key": "d",
                    "pipeline_task": {
                        "pipeline_id": this_databricks_pipeline["id"],
                    },
                },
            ])
        ```

        ## Access Control

        By default, all users can create and modify jobs unless an administrator [enables jobs access control](https://docs.databricks.com/administration-guide/access-control/jobs-acl.html). With jobs access control, individual permissions determine a user’s abilities.

        * Permissions can control which groups or individual users can *Can View*, *Can Manage Run*, and *Can Manage*.
        * ClusterPolicy can control which kinds of clusters users can create for jobs.

        ## Import

        The resource job can be imported using the id of the job

        bash

        ```sh
        $ pulumi import databricks:index/job:Job this <job-id>
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_running: Optional[pulumi.Input[bool]] = None,
                 budget_policy_id: Optional[pulumi.Input[str]] = None,
                 continuous: Optional[pulumi.Input[Union['JobContinuousArgs', 'JobContinuousArgsDict']]] = None,
                 control_run_state: Optional[pulumi.Input[bool]] = None,
                 dbt_task: Optional[pulumi.Input[Union['JobDbtTaskArgs', 'JobDbtTaskArgsDict']]] = None,
                 deployment: Optional[pulumi.Input[Union['JobDeploymentArgs', 'JobDeploymentArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edit_mode: Optional[pulumi.Input[str]] = None,
                 email_notifications: Optional[pulumi.Input[Union['JobEmailNotificationsArgs', 'JobEmailNotificationsArgsDict']]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobEnvironmentArgs', 'JobEnvironmentArgsDict']]]]] = None,
                 existing_cluster_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 git_source: Optional[pulumi.Input[Union['JobGitSourceArgs', 'JobGitSourceArgsDict']]] = None,
                 health: Optional[pulumi.Input[Union['JobHealthArgs', 'JobHealthArgsDict']]] = None,
                 job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobClusterArgs', 'JobJobClusterArgsDict']]]]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLibraryArgs', 'JobLibraryArgsDict']]]]] = None,
                 max_concurrent_runs: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_cluster: Optional[pulumi.Input[Union['JobNewClusterArgs', 'JobNewClusterArgsDict']]] = None,
                 notebook_task: Optional[pulumi.Input[Union['JobNotebookTaskArgs', 'JobNotebookTaskArgsDict']]] = None,
                 notification_settings: Optional[pulumi.Input[Union['JobNotificationSettingsArgs', 'JobNotificationSettingsArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobParameterArgs', 'JobParameterArgsDict']]]]] = None,
                 performance_target: Optional[pulumi.Input[str]] = None,
                 pipeline_task: Optional[pulumi.Input[Union['JobPipelineTaskArgs', 'JobPipelineTaskArgsDict']]] = None,
                 python_wheel_task: Optional[pulumi.Input[Union['JobPythonWheelTaskArgs', 'JobPythonWheelTaskArgsDict']]] = None,
                 queue: Optional[pulumi.Input[Union['JobQueueArgs', 'JobQueueArgsDict']]] = None,
                 retry_on_timeout: Optional[pulumi.Input[bool]] = None,
                 run_as: Optional[pulumi.Input[Union['JobRunAsArgs', 'JobRunAsArgsDict']]] = None,
                 run_job_task: Optional[pulumi.Input[Union['JobRunJobTaskArgs', 'JobRunJobTaskArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['JobScheduleArgs', 'JobScheduleArgsDict']]] = None,
                 spark_jar_task: Optional[pulumi.Input[Union['JobSparkJarTaskArgs', 'JobSparkJarTaskArgsDict']]] = None,
                 spark_python_task: Optional[pulumi.Input[Union['JobSparkPythonTaskArgs', 'JobSparkPythonTaskArgsDict']]] = None,
                 spark_submit_task: Optional[pulumi.Input[Union['JobSparkSubmitTaskArgs', 'JobSparkSubmitTaskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobTaskArgs', 'JobTaskArgsDict']]]]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 trigger: Optional[pulumi.Input[Union['JobTriggerArgs', 'JobTriggerArgsDict']]] = None,
                 webhook_notifications: Optional[pulumi.Input[Union['JobWebhookNotificationsArgs', 'JobWebhookNotificationsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["always_running"] = always_running
            __props__.__dict__["budget_policy_id"] = budget_policy_id
            __props__.__dict__["continuous"] = continuous
            __props__.__dict__["control_run_state"] = control_run_state
            __props__.__dict__["dbt_task"] = dbt_task
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["description"] = description
            __props__.__dict__["edit_mode"] = edit_mode
            __props__.__dict__["email_notifications"] = email_notifications
            __props__.__dict__["environments"] = environments
            __props__.__dict__["existing_cluster_id"] = existing_cluster_id
            __props__.__dict__["format"] = format
            __props__.__dict__["git_source"] = git_source
            __props__.__dict__["health"] = health
            __props__.__dict__["job_clusters"] = job_clusters
            __props__.__dict__["libraries"] = libraries
            __props__.__dict__["max_concurrent_runs"] = max_concurrent_runs
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["min_retry_interval_millis"] = min_retry_interval_millis
            __props__.__dict__["name"] = name
            __props__.__dict__["new_cluster"] = new_cluster
            __props__.__dict__["notebook_task"] = notebook_task
            __props__.__dict__["notification_settings"] = notification_settings
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["performance_target"] = performance_target
            __props__.__dict__["pipeline_task"] = pipeline_task
            __props__.__dict__["python_wheel_task"] = python_wheel_task
            __props__.__dict__["queue"] = queue
            __props__.__dict__["retry_on_timeout"] = retry_on_timeout
            __props__.__dict__["run_as"] = run_as
            __props__.__dict__["run_job_task"] = run_job_task
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["spark_jar_task"] = spark_jar_task
            __props__.__dict__["spark_python_task"] = spark_python_task
            __props__.__dict__["spark_submit_task"] = spark_submit_task
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tasks"] = tasks
            __props__.__dict__["timeout_seconds"] = timeout_seconds
            __props__.__dict__["trigger"] = trigger
            __props__.__dict__["webhook_notifications"] = webhook_notifications
            __props__.__dict__["url"] = None
        super(Job, __self__).__init__(
            'databricks:index/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_running: Optional[pulumi.Input[bool]] = None,
            budget_policy_id: Optional[pulumi.Input[str]] = None,
            continuous: Optional[pulumi.Input[Union['JobContinuousArgs', 'JobContinuousArgsDict']]] = None,
            control_run_state: Optional[pulumi.Input[bool]] = None,
            dbt_task: Optional[pulumi.Input[Union['JobDbtTaskArgs', 'JobDbtTaskArgsDict']]] = None,
            deployment: Optional[pulumi.Input[Union['JobDeploymentArgs', 'JobDeploymentArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            edit_mode: Optional[pulumi.Input[str]] = None,
            email_notifications: Optional[pulumi.Input[Union['JobEmailNotificationsArgs', 'JobEmailNotificationsArgsDict']]] = None,
            environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobEnvironmentArgs', 'JobEnvironmentArgsDict']]]]] = None,
            existing_cluster_id: Optional[pulumi.Input[str]] = None,
            format: Optional[pulumi.Input[str]] = None,
            git_source: Optional[pulumi.Input[Union['JobGitSourceArgs', 'JobGitSourceArgsDict']]] = None,
            health: Optional[pulumi.Input[Union['JobHealthArgs', 'JobHealthArgsDict']]] = None,
            job_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobClusterArgs', 'JobJobClusterArgsDict']]]]] = None,
            libraries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLibraryArgs', 'JobLibraryArgsDict']]]]] = None,
            max_concurrent_runs: Optional[pulumi.Input[int]] = None,
            max_retries: Optional[pulumi.Input[int]] = None,
            min_retry_interval_millis: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_cluster: Optional[pulumi.Input[Union['JobNewClusterArgs', 'JobNewClusterArgsDict']]] = None,
            notebook_task: Optional[pulumi.Input[Union['JobNotebookTaskArgs', 'JobNotebookTaskArgsDict']]] = None,
            notification_settings: Optional[pulumi.Input[Union['JobNotificationSettingsArgs', 'JobNotificationSettingsArgsDict']]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobParameterArgs', 'JobParameterArgsDict']]]]] = None,
            performance_target: Optional[pulumi.Input[str]] = None,
            pipeline_task: Optional[pulumi.Input[Union['JobPipelineTaskArgs', 'JobPipelineTaskArgsDict']]] = None,
            python_wheel_task: Optional[pulumi.Input[Union['JobPythonWheelTaskArgs', 'JobPythonWheelTaskArgsDict']]] = None,
            queue: Optional[pulumi.Input[Union['JobQueueArgs', 'JobQueueArgsDict']]] = None,
            retry_on_timeout: Optional[pulumi.Input[bool]] = None,
            run_as: Optional[pulumi.Input[Union['JobRunAsArgs', 'JobRunAsArgsDict']]] = None,
            run_job_task: Optional[pulumi.Input[Union['JobRunJobTaskArgs', 'JobRunJobTaskArgsDict']]] = None,
            schedule: Optional[pulumi.Input[Union['JobScheduleArgs', 'JobScheduleArgsDict']]] = None,
            spark_jar_task: Optional[pulumi.Input[Union['JobSparkJarTaskArgs', 'JobSparkJarTaskArgsDict']]] = None,
            spark_python_task: Optional[pulumi.Input[Union['JobSparkPythonTaskArgs', 'JobSparkPythonTaskArgsDict']]] = None,
            spark_submit_task: Optional[pulumi.Input[Union['JobSparkSubmitTaskArgs', 'JobSparkSubmitTaskArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobTaskArgs', 'JobTaskArgsDict']]]]] = None,
            timeout_seconds: Optional[pulumi.Input[int]] = None,
            trigger: Optional[pulumi.Input[Union['JobTriggerArgs', 'JobTriggerArgsDict']]] = None,
            url: Optional[pulumi.Input[str]] = None,
            webhook_notifications: Optional[pulumi.Input[Union['JobWebhookNotificationsArgs', 'JobWebhookNotificationsArgsDict']]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] always_running: (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        :param pulumi.Input[str] budget_policy_id: The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        :param pulumi.Input[Union['JobContinuousArgs', 'JobContinuousArgsDict']] continuous: Configuration block to configure pause status. See continuous Configuration Block.
        :param pulumi.Input[bool] control_run_state: (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.
               
               When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        :param pulumi.Input[str] description: An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        :param pulumi.Input[str] edit_mode: If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        :param pulumi.Input[Union['JobEmailNotificationsArgs', 'JobEmailNotificationsArgsDict']] email_notifications: (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        :param pulumi.Input[Union['JobGitSourceArgs', 'JobGitSourceArgsDict']] git_source: Specifices the a Git repository for task source code. See git_source Configuration Block below.
        :param pulumi.Input[Union['JobHealthArgs', 'JobHealthArgsDict']] health: An optional block that specifies the health conditions for the job documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobClusterArgs', 'JobJobClusterArgsDict']]]] job_clusters: A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobLibraryArgs', 'JobLibraryArgsDict']]]] libraries: (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        :param pulumi.Input[int] max_concurrent_runs: (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        :param pulumi.Input[int] min_retry_interval_millis: (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        :param pulumi.Input[str] name: An optional name for the job. The default value is Untitled.
        :param pulumi.Input[Union['JobNotificationSettingsArgs', 'JobNotificationSettingsArgsDict']] notification_settings: An optional block controlling the notification settings on the job level documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobParameterArgs', 'JobParameterArgsDict']]]] parameters: Specifices job parameter for the job. See parameter Configuration Block
        :param pulumi.Input[Union['JobQueueArgs', 'JobQueueArgsDict']] queue: The queue status for the job. See queue Configuration Block below.
        :param pulumi.Input[Union['JobRunAsArgs', 'JobRunAsArgsDict']] run_as: The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        :param pulumi.Input[Union['JobScheduleArgs', 'JobScheduleArgsDict']] schedule: An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: An optional map of the tags associated with the job. See tags Configuration Map
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobTaskArgs', 'JobTaskArgsDict']]]] tasks: A list of task specification that the job will execute. See task Configuration Block below.
        :param pulumi.Input[int] timeout_seconds: (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        :param pulumi.Input[Union['JobTriggerArgs', 'JobTriggerArgsDict']] trigger: The conditions that triggers the job to start. See trigger Configuration Block below.
        :param pulumi.Input[str] url: URL of the job on the given workspace
        :param pulumi.Input[Union['JobWebhookNotificationsArgs', 'JobWebhookNotificationsArgsDict']] webhook_notifications: (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["always_running"] = always_running
        __props__.__dict__["budget_policy_id"] = budget_policy_id
        __props__.__dict__["continuous"] = continuous
        __props__.__dict__["control_run_state"] = control_run_state
        __props__.__dict__["dbt_task"] = dbt_task
        __props__.__dict__["deployment"] = deployment
        __props__.__dict__["description"] = description
        __props__.__dict__["edit_mode"] = edit_mode
        __props__.__dict__["email_notifications"] = email_notifications
        __props__.__dict__["environments"] = environments
        __props__.__dict__["existing_cluster_id"] = existing_cluster_id
        __props__.__dict__["format"] = format
        __props__.__dict__["git_source"] = git_source
        __props__.__dict__["health"] = health
        __props__.__dict__["job_clusters"] = job_clusters
        __props__.__dict__["libraries"] = libraries
        __props__.__dict__["max_concurrent_runs"] = max_concurrent_runs
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["min_retry_interval_millis"] = min_retry_interval_millis
        __props__.__dict__["name"] = name
        __props__.__dict__["new_cluster"] = new_cluster
        __props__.__dict__["notebook_task"] = notebook_task
        __props__.__dict__["notification_settings"] = notification_settings
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["performance_target"] = performance_target
        __props__.__dict__["pipeline_task"] = pipeline_task
        __props__.__dict__["python_wheel_task"] = python_wheel_task
        __props__.__dict__["queue"] = queue
        __props__.__dict__["retry_on_timeout"] = retry_on_timeout
        __props__.__dict__["run_as"] = run_as
        __props__.__dict__["run_job_task"] = run_job_task
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["spark_jar_task"] = spark_jar_task
        __props__.__dict__["spark_python_task"] = spark_python_task
        __props__.__dict__["spark_submit_task"] = spark_submit_task
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tasks"] = tasks
        __props__.__dict__["timeout_seconds"] = timeout_seconds
        __props__.__dict__["trigger"] = trigger
        __props__.__dict__["url"] = url
        __props__.__dict__["webhook_notifications"] = webhook_notifications
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alwaysRunning")
    @_utilities.deprecated("""always_running will be replaced by control_run_state in the next major release.""")
    def always_running(self) -> pulumi.Output[Optional[bool]]:
        """
        (Bool) Whenever the job is always running, like a Spark Streaming application, on every update restart the current active run or start it again, if nothing it is not running. False by default. Any job runs are started with `parameters` specified in `spark_jar_task` or `spark_submit_task` or `spark_python_task` or `notebook_task` blocks.
        """
        return pulumi.get(self, "always_running")

    @property
    @pulumi.getter(name="budgetPolicyId")
    def budget_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the user-specified budget policy to use for this job. If not specified, a default budget policy may be applied when creating or modifying the job.
        """
        return pulumi.get(self, "budget_policy_id")

    @property
    @pulumi.getter
    def continuous(self) -> pulumi.Output[Optional['outputs.JobContinuous']]:
        """
        Configuration block to configure pause status. See continuous Configuration Block.
        """
        return pulumi.get(self, "continuous")

    @property
    @pulumi.getter(name="controlRunState")
    def control_run_state(self) -> pulumi.Output[Optional[bool]]:
        """
        (Bool) If true, the Databricks provider will stop and start the job as needed to ensure that the active run for the job reflects the deployed configuration. For continuous jobs, the provider respects the `pause_status` by stopping the current active run. This flag cannot be set for non-continuous jobs.

        When migrating from `always_running` to `control_run_state`, set `continuous` as follows:
        """
        return pulumi.get(self, "control_run_state")

    @property
    @pulumi.getter(name="dbtTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def dbt_task(self) -> pulumi.Output[Optional['outputs.JobDbtTask']]:
        return pulumi.get(self, "dbt_task")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output[Optional['outputs.JobDeployment']]:
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description for the job. The maximum length is 1024 characters in UTF-8 encoding.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="editMode")
    def edit_mode(self) -> pulumi.Output[Optional[str]]:
        """
        If `"UI_LOCKED"`, the user interface for the job will be locked. If `"EDITABLE"` (the default), the user interface will be editable.
        """
        return pulumi.get(self, "edit_mode")

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> pulumi.Output[Optional['outputs.JobEmailNotifications']]:
        """
        (List) An optional set of email addresses notified when runs of this job begins, completes or fails. The default behavior is to not send any emails. This field is a block and is documented below.
        """
        return pulumi.get(self, "email_notifications")

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Optional[Sequence['outputs.JobEnvironment']]]:
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "existing_cluster_id")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[str]:
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="gitSource")
    def git_source(self) -> pulumi.Output[Optional['outputs.JobGitSource']]:
        """
        Specifices the a Git repository for task source code. See git_source Configuration Block below.
        """
        return pulumi.get(self, "git_source")

    @property
    @pulumi.getter
    def health(self) -> pulumi.Output[Optional['outputs.JobHealth']]:
        """
        An optional block that specifies the health conditions for the job documented below.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="jobClusters")
    def job_clusters(self) -> pulumi.Output[Optional[Sequence['outputs.JobJobCluster']]]:
        """
        A list of job Cluster specifications that can be shared and reused by tasks of this job. Libraries cannot be declared in a shared job cluster. You must declare dependent libraries in task settings. *Multi-task syntax*
        """
        return pulumi.get(self, "job_clusters")

    @property
    @pulumi.getter
    def libraries(self) -> pulumi.Output[Optional[Sequence['outputs.JobLibrary']]]:
        """
        (List) An optional list of libraries to be installed on the cluster that will execute the job. See library Configuration Block below.
        """
        return pulumi.get(self, "libraries")

    @property
    @pulumi.getter(name="maxConcurrentRuns")
    def max_concurrent_runs(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional maximum allowed number of concurrent runs of the job. Defaults to *1*.
        """
        return pulumi.get(self, "max_concurrent_runs")

    @property
    @pulumi.getter(name="maxRetries")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def max_retries(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="minRetryIntervalMillis")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def min_retry_interval_millis(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
        """
        return pulumi.get(self, "min_retry_interval_millis")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        An optional name for the job. The default value is Untitled.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newCluster")
    def new_cluster(self) -> pulumi.Output[Optional['outputs.JobNewCluster']]:
        return pulumi.get(self, "new_cluster")

    @property
    @pulumi.getter(name="notebookTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def notebook_task(self) -> pulumi.Output[Optional['outputs.JobNotebookTask']]:
        return pulumi.get(self, "notebook_task")

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Output[Optional['outputs.JobNotificationSettings']]:
        """
        An optional block controlling the notification settings on the job level documented below.
        """
        return pulumi.get(self, "notification_settings")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.JobParameter']]]:
        """
        Specifices job parameter for the job. See parameter Configuration Block
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="performanceTarget")
    def performance_target(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "performance_target")

    @property
    @pulumi.getter(name="pipelineTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def pipeline_task(self) -> pulumi.Output[Optional['outputs.JobPipelineTask']]:
        return pulumi.get(self, "pipeline_task")

    @property
    @pulumi.getter(name="pythonWheelTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def python_wheel_task(self) -> pulumi.Output[Optional['outputs.JobPythonWheelTask']]:
        return pulumi.get(self, "python_wheel_task")

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Output[Optional['outputs.JobQueue']]:
        """
        The queue status for the job. See queue Configuration Block below.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter(name="retryOnTimeout")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def retry_on_timeout(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "retry_on_timeout")

    @property
    @pulumi.getter(name="runAs")
    def run_as(self) -> pulumi.Output['outputs.JobRunAs']:
        """
        The user or the service prinicipal the job runs as. See run_as Configuration Block below.
        """
        return pulumi.get(self, "run_as")

    @property
    @pulumi.getter(name="runJobTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def run_job_task(self) -> pulumi.Output[Optional['outputs.JobRunJobTask']]:
        return pulumi.get(self, "run_job_task")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.JobSchedule']]:
        """
        An optional periodic schedule for this job. The default behavior is that the job runs when triggered by clicking Run Now in the Jobs UI or sending an API request to runNow. See schedule Configuration Block below.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sparkJarTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_jar_task(self) -> pulumi.Output[Optional['outputs.JobSparkJarTask']]:
        return pulumi.get(self, "spark_jar_task")

    @property
    @pulumi.getter(name="sparkPythonTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_python_task(self) -> pulumi.Output[Optional['outputs.JobSparkPythonTask']]:
        return pulumi.get(self, "spark_python_task")

    @property
    @pulumi.getter(name="sparkSubmitTask")
    @_utilities.deprecated("""should be used inside a task block and not inside a job block""")
    def spark_submit_task(self) -> pulumi.Output[Optional['outputs.JobSparkSubmitTask']]:
        return pulumi.get(self, "spark_submit_task")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        An optional map of the tags associated with the job. See tags Configuration Map
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tasks(self) -> pulumi.Output[Optional[Sequence['outputs.JobTask']]]:
        """
        A list of task specification that the job will execute. See task Configuration Block below.
        """
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        (Integer) An optional timeout applied to each run of this job. The default behavior is to have no timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[Optional['outputs.JobTrigger']]:
        """
        The conditions that triggers the job to start. See trigger Configuration Block below.
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        URL of the job on the given workspace
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="webhookNotifications")
    def webhook_notifications(self) -> pulumi.Output[Optional['outputs.JobWebhookNotifications']]:
        """
        (List) An optional set of system destinations (for example, webhook destinations or Slack) to be notified when runs of this job begins, completes or fails. The default behavior is to not send any notifications. This field is a block and is documented below.
        """
        return pulumi.get(self, "webhook_notifications")

