# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelServingArgs', 'ModelServing']

@pulumi.input_type
class ModelServingArgs:
    def __init__(__self__, *,
                 ai_gateway: Optional[pulumi.Input['ModelServingAiGatewayArgs']] = None,
                 config: Optional[pulumi.Input['ModelServingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]]] = None,
                 route_optimized: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]]] = None):
        """
        The set of arguments for constructing a ModelServing resource.
        :param pulumi.Input['ModelServingAiGatewayArgs'] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input['ModelServingConfigArgs'] config: The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        :param pulumi.Input[str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]] rate_limits: A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        :param pulumi.Input[bool] route_optimized: A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        :param pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        if ai_gateway is not None:
            pulumi.set(__self__, "ai_gateway", ai_gateway)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limits is not None:
            pulumi.set(__self__, "rate_limits", rate_limits)
        if route_optimized is not None:
            pulumi.set(__self__, "route_optimized", route_optimized)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="aiGateway")
    def ai_gateway(self) -> Optional[pulumi.Input['ModelServingAiGatewayArgs']]:
        """
        A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        """
        return pulumi.get(self, "ai_gateway")

    @ai_gateway.setter
    def ai_gateway(self, value: Optional[pulumi.Input['ModelServingAiGatewayArgs']]):
        pulumi.set(self, "ai_gateway", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ModelServingConfigArgs']]:
        """
        The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ModelServingConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]]]:
        """
        A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        """
        return pulumi.get(self, "rate_limits")

    @rate_limits.setter
    def rate_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]]]):
        pulumi.set(self, "rate_limits", value)

    @property
    @pulumi.getter(name="routeOptimized")
    def route_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        """
        return pulumi.get(self, "route_optimized")

    @route_optimized.setter
    def route_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_optimized", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]]]:
        """
        Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ModelServingState:
    def __init__(__self__, *,
                 ai_gateway: Optional[pulumi.Input['ModelServingAiGatewayArgs']] = None,
                 config: Optional[pulumi.Input['ModelServingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]]] = None,
                 route_optimized: Optional[pulumi.Input[bool]] = None,
                 serving_endpoint_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering ModelServing resources.
        :param pulumi.Input['ModelServingAiGatewayArgs'] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input['ModelServingConfigArgs'] config: The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        :param pulumi.Input[str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]] rate_limits: A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        :param pulumi.Input[bool] route_optimized: A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        :param pulumi.Input[str] serving_endpoint_id: Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        :param pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        if ai_gateway is not None:
            pulumi.set(__self__, "ai_gateway", ai_gateway)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limits is not None:
            pulumi.set(__self__, "rate_limits", rate_limits)
        if route_optimized is not None:
            pulumi.set(__self__, "route_optimized", route_optimized)
        if serving_endpoint_id is not None:
            pulumi.set(__self__, "serving_endpoint_id", serving_endpoint_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="aiGateway")
    def ai_gateway(self) -> Optional[pulumi.Input['ModelServingAiGatewayArgs']]:
        """
        A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        """
        return pulumi.get(self, "ai_gateway")

    @ai_gateway.setter
    def ai_gateway(self, value: Optional[pulumi.Input['ModelServingAiGatewayArgs']]):
        pulumi.set(self, "ai_gateway", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ModelServingConfigArgs']]:
        """
        The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ModelServingConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]]]:
        """
        A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        """
        return pulumi.get(self, "rate_limits")

    @rate_limits.setter
    def rate_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingRateLimitArgs']]]]):
        pulumi.set(self, "rate_limits", value)

    @property
    @pulumi.getter(name="routeOptimized")
    def route_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        """
        return pulumi.get(self, "route_optimized")

    @route_optimized.setter
    def route_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_optimized", value)

    @property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        """
        return pulumi.get(self, "serving_endpoint_id")

    @serving_endpoint_id.setter
    def serving_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serving_endpoint_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]]]:
        """
        Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelServingTagArgs']]]]):
        pulumi.set(self, "tags", value)


class ModelServing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_gateway: Optional[pulumi.Input[Union['ModelServingAiGatewayArgs', 'ModelServingAiGatewayArgsDict']]] = None,
                 config: Optional[pulumi.Input[Union['ModelServingConfigArgs', 'ModelServingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingRateLimitArgs', 'ModelServingRateLimitArgsDict']]]]] = None,
                 route_optimized: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingTagArgs', 'ModelServingTagArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource allows you to manage [Model Serving](https://docs.databricks.com/machine-learning/model-serving/index.html) endpoints in Databricks.

        > If you replace `served_models` with `served_entities` in an existing serving endpoint, the serving endpoint will briefly go into an update state (~30 seconds) and increment the config version.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.ModelServing("this",
            name="ads-serving-endpoint",
            config={
                "served_entities": [
                    {
                        "name": "prod_model",
                        "entity_name": "ads-model",
                        "entity_version": "2",
                        "workload_size": "Small",
                        "scale_to_zero_enabled": True,
                    },
                    {
                        "name": "candidate_model",
                        "entity_name": "ads-model",
                        "entity_version": "4",
                        "workload_size": "Small",
                        "scale_to_zero_enabled": False,
                    },
                ],
                "traffic_config": {
                    "routes": [
                        {
                            "served_model_name": "prod_model",
                            "traffic_percentage": 90,
                        },
                        {
                            "served_model_name": "candidate_model",
                            "traffic_percentage": 10,
                        },
                    ],
                },
            })
        ```

        ## Access Control

        * Permissions can control which groups or individual users can *Manage*, *Query* or *View* individual serving endpoints.

        ## Related Resources

        The following resources are often used in the same context:

        * RegisteredModel to create [Models in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html) in Databricks.
        * End to end workspace management guide.
        * Directory to manage directories in [Databricks Workspace](https://docs.databricks.com/workspace/workspace-objects.html).
        * MlflowModel to create models in the [workspace model registry](https://docs.databricks.com/en/mlflow/model-registry.html) in Databricks.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        * Notebook data to export a notebook from Databricks Workspace.
        * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).

        ## Import

        The model serving resource can be imported using the name of the endpoint.

        bash

        ```sh
        $ pulumi import databricks:index/modelServing:ModelServing this <model-serving-endpoint-name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ModelServingAiGatewayArgs', 'ModelServingAiGatewayArgsDict']] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input[Union['ModelServingConfigArgs', 'ModelServingConfigArgsDict']] config: The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        :param pulumi.Input[str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelServingRateLimitArgs', 'ModelServingRateLimitArgsDict']]]] rate_limits: A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        :param pulumi.Input[bool] route_optimized: A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelServingTagArgs', 'ModelServingTagArgsDict']]]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ModelServingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [Model Serving](https://docs.databricks.com/machine-learning/model-serving/index.html) endpoints in Databricks.

        > If you replace `served_models` with `served_entities` in an existing serving endpoint, the serving endpoint will briefly go into an update state (~30 seconds) and increment the config version.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.ModelServing("this",
            name="ads-serving-endpoint",
            config={
                "served_entities": [
                    {
                        "name": "prod_model",
                        "entity_name": "ads-model",
                        "entity_version": "2",
                        "workload_size": "Small",
                        "scale_to_zero_enabled": True,
                    },
                    {
                        "name": "candidate_model",
                        "entity_name": "ads-model",
                        "entity_version": "4",
                        "workload_size": "Small",
                        "scale_to_zero_enabled": False,
                    },
                ],
                "traffic_config": {
                    "routes": [
                        {
                            "served_model_name": "prod_model",
                            "traffic_percentage": 90,
                        },
                        {
                            "served_model_name": "candidate_model",
                            "traffic_percentage": 10,
                        },
                    ],
                },
            })
        ```

        ## Access Control

        * Permissions can control which groups or individual users can *Manage*, *Query* or *View* individual serving endpoints.

        ## Related Resources

        The following resources are often used in the same context:

        * RegisteredModel to create [Models in Unity Catalog](https://docs.databricks.com/en/mlflow/models-in-uc.html) in Databricks.
        * End to end workspace management guide.
        * Directory to manage directories in [Databricks Workspace](https://docs.databricks.com/workspace/workspace-objects.html).
        * MlflowModel to create models in the [workspace model registry](https://docs.databricks.com/en/mlflow/model-registry.html) in Databricks.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
        * Notebook data to export a notebook from Databricks Workspace.
        * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).

        ## Import

        The model serving resource can be imported using the name of the endpoint.

        bash

        ```sh
        $ pulumi import databricks:index/modelServing:ModelServing this <model-serving-endpoint-name>
        ```

        :param str resource_name: The name of the resource.
        :param ModelServingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelServingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_gateway: Optional[pulumi.Input[Union['ModelServingAiGatewayArgs', 'ModelServingAiGatewayArgsDict']]] = None,
                 config: Optional[pulumi.Input[Union['ModelServingConfigArgs', 'ModelServingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingRateLimitArgs', 'ModelServingRateLimitArgsDict']]]]] = None,
                 route_optimized: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingTagArgs', 'ModelServingTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelServingArgs.__new__(ModelServingArgs)

            __props__.__dict__["ai_gateway"] = ai_gateway
            __props__.__dict__["config"] = config
            __props__.__dict__["name"] = name
            __props__.__dict__["rate_limits"] = rate_limits
            __props__.__dict__["route_optimized"] = route_optimized
            __props__.__dict__["tags"] = tags
            __props__.__dict__["serving_endpoint_id"] = None
        super(ModelServing, __self__).__init__(
            'databricks:index/modelServing:ModelServing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ai_gateway: Optional[pulumi.Input[Union['ModelServingAiGatewayArgs', 'ModelServingAiGatewayArgsDict']]] = None,
            config: Optional[pulumi.Input[Union['ModelServingConfigArgs', 'ModelServingConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rate_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingRateLimitArgs', 'ModelServingRateLimitArgsDict']]]]] = None,
            route_optimized: Optional[pulumi.Input[bool]] = None,
            serving_endpoint_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelServingTagArgs', 'ModelServingTagArgsDict']]]]] = None) -> 'ModelServing':
        """
        Get an existing ModelServing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ModelServingAiGatewayArgs', 'ModelServingAiGatewayArgsDict']] ai_gateway: A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        :param pulumi.Input[Union['ModelServingConfigArgs', 'ModelServingConfigArgsDict']] config: The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        :param pulumi.Input[str] name: The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelServingRateLimitArgs', 'ModelServingRateLimitArgsDict']]]] rate_limits: A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        :param pulumi.Input[bool] route_optimized: A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        :param pulumi.Input[str] serving_endpoint_id: Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelServingTagArgs', 'ModelServingTagArgsDict']]]] tags: Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelServingState.__new__(_ModelServingState)

        __props__.__dict__["ai_gateway"] = ai_gateway
        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        __props__.__dict__["rate_limits"] = rate_limits
        __props__.__dict__["route_optimized"] = route_optimized
        __props__.__dict__["serving_endpoint_id"] = serving_endpoint_id
        __props__.__dict__["tags"] = tags
        return ModelServing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiGateway")
    def ai_gateway(self) -> pulumi.Output[Optional['outputs.ModelServingAiGateway']]:
        """
        A block with AI Gateway configuration for the serving endpoint. *Note: only external model endpoints are supported as of now.*
        """
        return pulumi.get(self, "ai_gateway")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.ModelServingConfig']:
        """
        The model serving endpoint configuration. This is optional and can be added and modified after creation. If `config` was provided in a previous apply but is not provided in the current apply, no change to the model serving endpoint will occur. To recreate the model serving endpoint without the `config` block, the model serving endpoint must be destroyed and recreated.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the model serving endpoint. This field is required and must be unique across a workspace. An endpoint name can consist of alphanumeric characters, dashes, and underscores. NOTE: Changing this name will delete the existing endpoint and create a new endpoint with the updated name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> pulumi.Output[Optional[Sequence['outputs.ModelServingRateLimit']]]:
        """
        A list of rate limit blocks to be applied to the serving endpoint. *Note: only external and foundation model endpoints are supported as of now.*
        """
        return pulumi.get(self, "rate_limits")

    @property
    @pulumi.getter(name="routeOptimized")
    def route_optimized(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean enabling route optimization for the endpoint. *Note: only available for custom models.*
        """
        return pulumi.get(self, "route_optimized")

    @property
    @pulumi.getter(name="servingEndpointId")
    def serving_endpoint_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of the serving endpoint primarily used to set permissions and refer to this instance for other operations.
        """
        return pulumi.get(self, "serving_endpoint_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ModelServingTag']]]:
        """
        Tags to be attached to the serving endpoint and automatically propagated to billing logs.
        """
        return pulumi.get(self, "tags")

